/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.net.InetAddress;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

public class EnterLockdownModeTask
extends Task {
    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_ENTER_LOCKDOWN_MODE_NAME.get();
    }

    public void initializeTask() throws DirectoryException {
        Operation operation = this.getOperation();
        if (operation != null) {
            DN authzDN = operation.getAuthorizationDN();
            if (authzDN == null || !DirectoryServer.isRootDN(authzDN)) {
                Message message = TaskMessages.ERR_TASK_ENTERLOCKDOWN_NOT_ROOT.get();
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            InetAddress clientAddress = operation.getClientConnection().getRemoteAddress();
            if (clientAddress != null && !clientAddress.isLoopbackAddress()) {
                Message message = TaskMessages.ERR_TASK_ENTERLOCKDOWN_NOT_LOOPBACK.get();
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
        }
    }

    protected TaskState runTask() {
        DirectoryServer.setLockdownMode(true);
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

