/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.RelativeSubtreeSpecification;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelativeSubtreeSpecificationSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public static AttributeValueDecoder<RelativeSubtreeSpecification> createAttributeValueDecoder(DN rootDN) {
        return new Decoder(rootDN);
    }

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.17");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.17", "ds-relative-subtree-specification"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.18");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.18", "ds-relative-subtree-specification"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.19");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.19", "ds-relative-subtree-specification"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "ds-relative-subtree-specification";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.26027.1.3.2";
    }

    @Override
    public String getDescription() {
        return "Relative Subtree Specification";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, MessageBuilder invalidReason) {
        try {
            RelativeSubtreeSpecification.valueOf(DN.nullDN(), value.stringValue());
            return true;
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            invalidReason.append(e.getMessageObject());
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Decoder
    implements AttributeValueDecoder<RelativeSubtreeSpecification> {
        private DN rootDN;

        public Decoder(DN rootDN) {
            this.rootDN = rootDN;
        }

        @Override
        public RelativeSubtreeSpecification decode(AttributeValue value) throws DirectoryException {
            return RelativeSubtreeSpecification.valueOf(this.rootDN, value.getStringValue());
        }
    }
}

