/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizedTimeSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static Object dateFormatLock;
    private static SimpleDateFormat dateFormat;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.27");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.27", "GeneralizedTime"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.28");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.28", "GeneralizedTime"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "GeneralizedTime"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "GeneralizedTime";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.24";
    }

    @Override
    public String getDescription() {
        return "Generalized Time";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, MessageBuilder invalidReason) {
        try {
            GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value);
            return true;
        }
        catch (DirectoryException de) {
            invalidReason.append(de.getMessageObject());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date d) {
        Object object = dateFormatLock;
        synchronized (object) {
            return dateFormat.format(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(long t) {
        Object object = dateFormatLock;
        synchronized (object) {
            return dateFormat.format(new Date(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeValue createGeneralizedTimeValue(long time) {
        String valueString;
        Object object = dateFormatLock;
        synchronized (object) {
            valueString = dateFormat.format(new Date(time));
        }
        return new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString));
    }

    public static long decodeGeneralizedTimeValue(ByteString value) throws DirectoryException {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        String valueString = value.stringValue().toUpperCase();
        int length = valueString.length();
        if (length < 11) {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_TOO_SHORT.get(valueString);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        block166: for (int i = 0; i < 4; ++i) {
            switch (valueString.charAt(i)) {
                case '0': {
                    year *= 10;
                    continue block166;
                }
                case '1': {
                    year = year * 10 + 1;
                    continue block166;
                }
                case '2': {
                    year = year * 10 + 2;
                    continue block166;
                }
                case '3': {
                    year = year * 10 + 3;
                    continue block166;
                }
                case '4': {
                    year = year * 10 + 4;
                    continue block166;
                }
                case '5': {
                    year = year * 10 + 5;
                    continue block166;
                }
                case '6': {
                    year = year * 10 + 6;
                    continue block166;
                }
                case '7': {
                    year = year * 10 + 7;
                    continue block166;
                }
                case '8': {
                    year = year * 10 + 8;
                    continue block166;
                }
                case '9': {
                    year = year * 10 + 9;
                    continue block166;
                }
                default: {
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_YEAR.get(valueString, String.valueOf(valueString.charAt(i)));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
            }
        }
        char m1 = valueString.charAt(4);
        char m2 = valueString.charAt(5);
        block18 : switch (m1) {
            case '0': {
                switch (m2) {
                    case '1': {
                        month = 0;
                        break block18;
                    }
                    case '2': {
                        month = 1;
                        break block18;
                    }
                    case '3': {
                        month = 2;
                        break block18;
                    }
                    case '4': {
                        month = 3;
                        break block18;
                    }
                    case '5': {
                        month = 4;
                        break block18;
                    }
                    case '6': {
                        month = 5;
                        break block18;
                    }
                    case '7': {
                        month = 6;
                        break block18;
                    }
                    case '8': {
                        month = 7;
                        break block18;
                    }
                    case '9': {
                        month = 8;
                        break block18;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH.get(valueString, valueString.substring(4, 6));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '1': {
                switch (m2) {
                    case '0': {
                        month = 9;
                        break block18;
                    }
                    case '1': {
                        month = 10;
                        break block18;
                    }
                    case '2': {
                        month = 11;
                        break block18;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH.get(valueString, valueString.substring(4, 6));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            default: {
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH.get(valueString, valueString.substring(4, 6));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        char d1 = valueString.charAt(6);
        char d2 = valueString.charAt(7);
        block38 : switch (d1) {
            case '0': {
                switch (d2) {
                    case '1': {
                        day = 1;
                        break block38;
                    }
                    case '2': {
                        day = 2;
                        break block38;
                    }
                    case '3': {
                        day = 3;
                        break block38;
                    }
                    case '4': {
                        day = 4;
                        break block38;
                    }
                    case '5': {
                        day = 5;
                        break block38;
                    }
                    case '6': {
                        day = 6;
                        break block38;
                    }
                    case '7': {
                        day = 7;
                        break block38;
                    }
                    case '8': {
                        day = 8;
                        break block38;
                    }
                    case '9': {
                        day = 9;
                        break block38;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get(valueString, valueString.substring(6, 8));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '1': {
                switch (d2) {
                    case '0': {
                        day = 10;
                        break block38;
                    }
                    case '1': {
                        day = 11;
                        break block38;
                    }
                    case '2': {
                        day = 12;
                        break block38;
                    }
                    case '3': {
                        day = 13;
                        break block38;
                    }
                    case '4': {
                        day = 14;
                        break block38;
                    }
                    case '5': {
                        day = 15;
                        break block38;
                    }
                    case '6': {
                        day = 16;
                        break block38;
                    }
                    case '7': {
                        day = 17;
                        break block38;
                    }
                    case '8': {
                        day = 18;
                        break block38;
                    }
                    case '9': {
                        day = 19;
                        break block38;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get(valueString, valueString.substring(6, 8));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '2': {
                switch (d2) {
                    case '0': {
                        day = 20;
                        break block38;
                    }
                    case '1': {
                        day = 21;
                        break block38;
                    }
                    case '2': {
                        day = 22;
                        break block38;
                    }
                    case '3': {
                        day = 23;
                        break block38;
                    }
                    case '4': {
                        day = 24;
                        break block38;
                    }
                    case '5': {
                        day = 25;
                        break block38;
                    }
                    case '6': {
                        day = 26;
                        break block38;
                    }
                    case '7': {
                        day = 27;
                        break block38;
                    }
                    case '8': {
                        day = 28;
                        break block38;
                    }
                    case '9': {
                        day = 29;
                        break block38;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get(valueString, valueString.substring(6, 8));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '3': {
                switch (d2) {
                    case '0': {
                        day = 30;
                        break block38;
                    }
                    case '1': {
                        day = 31;
                        break block38;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get(valueString, valueString.substring(6, 8));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            default: {
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get(valueString, valueString.substring(6, 8));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        char h1 = valueString.charAt(8);
        char h2 = valueString.charAt(9);
        block83 : switch (h1) {
            case '0': {
                switch (h2) {
                    case '0': {
                        hour = 0;
                        break block83;
                    }
                    case '1': {
                        hour = 1;
                        break block83;
                    }
                    case '2': {
                        hour = 2;
                        break block83;
                    }
                    case '3': {
                        hour = 3;
                        break block83;
                    }
                    case '4': {
                        hour = 4;
                        break block83;
                    }
                    case '5': {
                        hour = 5;
                        break block83;
                    }
                    case '6': {
                        hour = 6;
                        break block83;
                    }
                    case '7': {
                        hour = 7;
                        break block83;
                    }
                    case '8': {
                        hour = 8;
                        break block83;
                    }
                    case '9': {
                        hour = 9;
                        break block83;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get(valueString, valueString.substring(8, 10));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '1': {
                switch (h2) {
                    case '0': {
                        hour = 10;
                        break block83;
                    }
                    case '1': {
                        hour = 11;
                        break block83;
                    }
                    case '2': {
                        hour = 12;
                        break block83;
                    }
                    case '3': {
                        hour = 13;
                        break block83;
                    }
                    case '4': {
                        hour = 14;
                        break block83;
                    }
                    case '5': {
                        hour = 15;
                        break block83;
                    }
                    case '6': {
                        hour = 16;
                        break block83;
                    }
                    case '7': {
                        hour = 17;
                        break block83;
                    }
                    case '8': {
                        hour = 18;
                        break block83;
                    }
                    case '9': {
                        hour = 19;
                        break block83;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get(valueString, valueString.substring(8, 10));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '2': {
                switch (h2) {
                    case '0': {
                        hour = 20;
                        break block83;
                    }
                    case '1': {
                        hour = 21;
                        break block83;
                    }
                    case '2': {
                        hour = 22;
                        break block83;
                    }
                    case '3': {
                        hour = 23;
                        break block83;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get(valueString, valueString.substring(8, 10));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            default: {
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get(valueString, valueString.substring(8, 10));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        m1 = valueString.charAt(10);
        block118 : switch (m1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 13) {
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(m1), 10);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                minute = 10 * (m1 - 48);
                switch (valueString.charAt(11)) {
                    case '0': {
                        break block118;
                    }
                    case '1': {
                        ++minute;
                        break block118;
                    }
                    case '2': {
                        minute += 2;
                        break block118;
                    }
                    case '3': {
                        minute += 3;
                        break block118;
                    }
                    case '4': {
                        minute += 4;
                        break block118;
                    }
                    case '5': {
                        minute += 5;
                        break block118;
                    }
                    case '6': {
                        minute += 6;
                        break block118;
                    }
                    case '7': {
                        minute += 7;
                        break block118;
                    }
                    case '8': {
                        minute += 8;
                        break block118;
                    }
                    case '9': {
                        minute += 9;
                        break block118;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MINUTE.get(valueString, valueString.substring(10, 12));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case 'Z': {
                if (length == 11) {
                    try {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setLenient(false);
                        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                        calendar.set(year, month, day, hour, minute, second);
                        calendar.set(14, 0);
                        return calendar.getTimeInMillis();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get(valueString, String.valueOf(e));
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(m1), 10);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '+': 
            case '-': {
                if (length == 13 || length == 15) {
                    try {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setLenient(false);
                        calendar.setTimeZone(GeneralizedTimeSyntax.getTimeZoneForOffset(valueString, 10));
                        calendar.set(year, month, day, hour, minute, second);
                        calendar.set(14, 0);
                        return calendar.getTimeInMillis();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get(valueString, String.valueOf(e));
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(m1), 10);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case ',': 
            case '.': {
                return GeneralizedTimeSyntax.finishDecodingFraction(valueString, 11, year, month, day, hour, minute, second, 3600000);
            }
            default: {
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(m1), 10);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        char s1 = valueString.charAt(12);
        block136 : switch (s1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 15) {
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 12);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                second = 10 * (s1 - 48);
                switch (valueString.charAt(13)) {
                    case '0': {
                        break block136;
                    }
                    case '1': {
                        ++second;
                        break block136;
                    }
                    case '2': {
                        second += 2;
                        break block136;
                    }
                    case '3': {
                        second += 3;
                        break block136;
                    }
                    case '4': {
                        second += 4;
                        break block136;
                    }
                    case '5': {
                        second += 5;
                        break block136;
                    }
                    case '6': {
                        second += 6;
                        break block136;
                    }
                    case '7': {
                        second += 7;
                        break block136;
                    }
                    case '8': {
                        second += 8;
                        break block136;
                    }
                    case '9': {
                        second += 9;
                        break block136;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MINUTE.get(valueString, valueString.substring(12, 14));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '6': {
                if (length < 15) {
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 12);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                if (valueString.charAt(13) != '0') {
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_SECOND.get(valueString, valueString.substring(12, 14));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                second = 60;
                break;
            }
            case 'Z': {
                if (length == 13) {
                    try {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setLenient(false);
                        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                        calendar.set(year, month, day, hour, minute, second);
                        calendar.set(14, 0);
                        return calendar.getTimeInMillis();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get(valueString, String.valueOf(e));
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 12);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '+': 
            case '-': {
                if (length == 15 || length == 17) {
                    try {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setLenient(false);
                        calendar.setTimeZone(GeneralizedTimeSyntax.getTimeZoneForOffset(valueString, 12));
                        calendar.set(year, month, day, hour, minute, second);
                        calendar.set(14, 0);
                        return calendar.getTimeInMillis();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get(valueString, String.valueOf(e));
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 12);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case ',': 
            case '.': {
                return GeneralizedTimeSyntax.finishDecodingFraction(valueString, 13, year, month, day, hour, minute, second, 60000);
            }
            default: {
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 12);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        switch (valueString.charAt(14)) {
            case ',': 
            case '.': {
                return GeneralizedTimeSyntax.finishDecodingFraction(valueString, 15, year, month, day, hour, minute, second, 1000);
            }
            case 'Z': {
                if (length == 15) {
                    try {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setLenient(false);
                        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                        calendar.set(year, month, day, hour, minute, second);
                        calendar.set(14, 0);
                        return calendar.getTimeInMillis();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get(valueString, String.valueOf(e));
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(valueString.charAt(14)), 14);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '+': 
            case '-': {
                if (length == 17 || length == 19) {
                    try {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setLenient(false);
                        calendar.setTimeZone(GeneralizedTimeSyntax.getTimeZoneForOffset(valueString, 14));
                        calendar.set(year, month, day, hour, minute, second);
                        calendar.set(14, 0);
                        return calendar.getTimeInMillis();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get(valueString, String.valueOf(e));
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(valueString.charAt(14)), 14);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(valueString.charAt(14)), 14);
        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
    }

    private static long finishDecodingFraction(String value, int startPos, int year, int month, int day, int hour, int minute, int second, int multiplier) throws DirectoryException {
        int length = value.length();
        StringBuilder fractionBuffer = new StringBuilder(2 + length - startPos);
        fractionBuffer.append("0.");
        TimeZone timeZone = null;
        block7: for (int i = startPos; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    fractionBuffer.append(c);
                    continue block7;
                }
                case 'Z': {
                    if (i != value.length() - 1) {
                        Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_FRACTION_CHAR.get(value, String.valueOf(c));
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    timeZone = TimeZone.getTimeZone("UTC");
                    break block7;
                }
                case '+': 
                case '-': {
                    timeZone = GeneralizedTimeSyntax.getTimeZoneForOffset(value, i);
                    break block7;
                }
                default: {
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_FRACTION_CHAR.get(value, String.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
            }
        }
        if (fractionBuffer.length() == 2) {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_EMPTY_FRACTION.get(value);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (timeZone == null) {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_NO_TIME_ZONE_INFO.get(value);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        Double fractionValue = Double.parseDouble(fractionBuffer.toString());
        long additionalMilliseconds = Math.round(fractionValue * (double)multiplier);
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setLenient(false);
            calendar.setTimeZone(timeZone);
            calendar.set(year, month, day, hour, minute, second);
            calendar.set(14, 0);
            return calendar.getTimeInMillis() + additionalMilliseconds;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get(value, String.valueOf(e));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
        }
    }

    private static TimeZone getTimeZoneForOffset(String value, int startPos) throws DirectoryException {
        String offSetStr = value.substring(startPos);
        if (offSetStr.length() != 3 && offSetStr.length() != 5) {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        switch (offSetStr.charAt(0)) {
            case '+': 
            case '-': {
                break;
            }
            default: {
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        block3 : switch (offSetStr.charAt(1)) {
            case '0': 
            case '1': {
                switch (offSetStr.charAt(2)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block3;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            case '2': {
                switch (offSetStr.charAt(2)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block3;
                    }
                }
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            default: {
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        if (offSetStr.length() == 5) {
            block13 : switch (offSetStr.charAt(3)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    switch (offSetStr.charAt(4)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block13;
                        }
                    }
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                default: {
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
            }
        }
        return TimeZone.getTimeZone("GMT" + offSetStr);
    }

    static {
        dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormatLock = new Object();
    }
}

