/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistinguishedNameSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    public static final AttributeValueDecoder<DN> DECODER = new AttributeValueDecoder<DN>(){

        @Override
        public DN decode(AttributeValue value) throws DirectoryException {
            return DN.decode(value.getStringValue());
        }
    };

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.1");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.1", "DN"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "DN"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "DN";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.12";
    }

    @Override
    public String getDescription() {
        return "DN";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, MessageBuilder invalidReason) {
        try {
            DN.decode(value.stringValue());
            return true;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            invalidReason.append(de.getMessageObject());
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_DN_INVALID.get(value.stringValue(), String.valueOf(e)));
            return false;
        }
    }
}

