/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DITContentRuleSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException, InitializationException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "DITContentRuleDescription");
            throw new InitializationException(message);
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "DITContentRuleDescription");
            throw new InitializationException(message);
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "DITContentRuleDescription");
            throw new InitializationException(message);
        }
    }

    @Override
    public String getSyntaxName() {
        return "DITContentRuleDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.16";
    }

    @Override
    public String getDescription() {
        return "DIT Content Rule Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, MessageBuilder invalidReason) {
        try {
            DITContentRuleSyntax.decodeDITContentRule(value, DirectoryServer.getSchema(), true);
            return true;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            invalidReason.append(de.getMessageObject());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static DITContentRule decodeDITContentRule(ByteString value, Schema schema, boolean allowUnknownElements) throws DirectoryException {
        ObjectClass oc;
        AttributeType t;
        char c;
        int pos;
        String valueStr = value.stringValue();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_EMPTY_VALUE.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_EXPECTED_OPEN_PARENTHESIS.get(valueStr, pos - 1, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        int oidStartPos = pos;
        if (!StaticUtils.isDigit(c)) {
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR_IN_STRING_OID.get(valueStr, String.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        } else {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_DOUBLE_PERIOD_IN_NUMERIC_OID.get(valueStr, pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR_IN_NUMERIC_OID.get(valueStr, String.valueOf(c), pos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                lastWasPeriod = false;
            }
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        String oid = lowerStr.substring(oidStartPos, pos - 1);
        ObjectClass structuralClass = schema.getObjectClass(oid);
        if (structuralClass == null) {
            if (!allowUnknownElements) {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_STRUCTURAL_CLASS.get(valueStr, oid);
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            structuralClass = DirectoryServer.getDefaultObjectClass(oid);
        } else if (structuralClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_STRUCTURAL_CLASS_NOT_STRUCTURAL.get(valueStr, oid, structuralClass.getNameOrOID(), String.valueOf((Object)structuralClass.getObjectClassType()));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        String description = null;
        boolean isObsolete = false;
        LinkedHashSet<ObjectClass> auxiliaryClasses = new LinkedHashSet<ObjectClass>();
        LinkedHashSet<AttributeType> requiredAttributes = new LinkedHashSet<AttributeType>();
        LinkedHashSet<AttributeType> optionalAttributes = new LinkedHashSet<AttributeType>();
        LinkedHashSet<AttributeType> prohibitedAttributes = new LinkedHashSet<AttributeType>();
        LinkedHashMap<String, List<String>> extraProperties = new LinkedHashMap<String, List<String>>();
        block5: while (true) {
            LinkedList<AttributeType> attrs;
            block60: {
                AttributeType attr;
                StringBuilder woidBuffer;
                block70: {
                    block59: {
                        block68: {
                            block58: {
                                block66: {
                                    LinkedList<ObjectClass> ocs;
                                    block57: {
                                        ObjectClass oc2;
                                        block64: {
                                            StringBuilder lowerBuffer;
                                            StringBuilder userBuffer;
                                            block62: {
                                                String tokenName;
                                                block69: {
                                                    String lowerTokenName;
                                                    block67: {
                                                        block65: {
                                                            block63: {
                                                                block61: {
                                                                    Message message;
                                                                    StringBuilder tokenNameBuffer = new StringBuilder();
                                                                    pos = DITContentRuleSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
                                                                    tokenName = tokenNameBuffer.toString();
                                                                    lowerTokenName = StaticUtils.toLowerCase(tokenName);
                                                                    if (tokenName.equals(")")) {
                                                                        if (pos < length) {
                                                                            message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNEXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos - 1);
                                                                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                                                                        }
                                                                        break;
                                                                    }
                                                                    if (!lowerTokenName.equals("name")) break block61;
                                                                    if ((c = valueStr.charAt(pos++)) == '\'') {
                                                                        userBuffer = new StringBuilder();
                                                                        lowerBuffer = new StringBuilder();
                                                                        pos = DITContentRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos - 1);
                                                                        names.put(lowerBuffer.toString(), userBuffer.toString());
                                                                        continue;
                                                                    }
                                                                    if (c != '(') {
                                                                        message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1);
                                                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                                                                    }
                                                                    break block62;
                                                                }
                                                                if (lowerTokenName.equals("desc")) {
                                                                    StringBuilder descriptionBuffer = new StringBuilder();
                                                                    pos = DITContentRuleSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
                                                                    description = descriptionBuffer.toString();
                                                                    continue;
                                                                }
                                                                if (lowerTokenName.equals("obsolete")) {
                                                                    isObsolete = true;
                                                                    continue;
                                                                }
                                                                if (!lowerTokenName.equals("aux")) break block63;
                                                                ocs = new LinkedList<ObjectClass>();
                                                                if ((c = valueStr.charAt(pos++)) == '(') break block64;
                                                                woidBuffer = new StringBuilder();
                                                                pos = DITContentRuleSyntax.readWOID(lowerStr, woidBuffer, pos - 1);
                                                                oc2 = schema.getObjectClass(woidBuffer.toString());
                                                                if (oc2 == null) {
                                                                    if (!allowUnknownElements) {
                                                                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_AUXILIARY_CLASS.get(valueStr, woidBuffer.toString());
                                                                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                                                    }
                                                                    oc2 = DirectoryServer.getDefaultAuxiliaryObjectClass(woidBuffer.toString());
                                                                } else if (oc2.getObjectClassType() != ObjectClassType.AUXILIARY) {
                                                                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_AUXILIARY_CLASS_NOT_AUXILIARY.get(valueStr, woidBuffer.toString(), oc2.getObjectClassType().toString());
                                                                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                                                }
                                                                ocs.add(oc2);
                                                                break block57;
                                                            }
                                                            if (!lowerTokenName.equals("must")) break block65;
                                                            attrs = new LinkedList<AttributeType>();
                                                            if ((c = valueStr.charAt(pos++)) == '(') break block66;
                                                            woidBuffer = new StringBuilder();
                                                            pos = DITContentRuleSyntax.readWOID(lowerStr, woidBuffer, pos - 1);
                                                            attr = schema.getAttributeType(woidBuffer.toString());
                                                            if (attr == null) {
                                                                if (!allowUnknownElements) {
                                                                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_REQUIRED_ATTR.get(valueStr, woidBuffer.toString());
                                                                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                                                }
                                                                attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                                                            }
                                                            attrs.add(attr);
                                                            break block58;
                                                        }
                                                        if (!lowerTokenName.equals("may")) break block67;
                                                        attrs = new LinkedList();
                                                        if ((c = valueStr.charAt(pos++)) == '(') break block68;
                                                        woidBuffer = new StringBuilder();
                                                        pos = DITContentRuleSyntax.readWOID(lowerStr, woidBuffer, pos - 1);
                                                        attr = schema.getAttributeType(woidBuffer.toString());
                                                        if (attr == null) {
                                                            if (!allowUnknownElements) {
                                                                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_OPTIONAL_ATTR.get(valueStr, woidBuffer.toString());
                                                                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                                            }
                                                            attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                                                        }
                                                        attrs.add(attr);
                                                        break block59;
                                                    }
                                                    if (!lowerTokenName.equals("not")) break block69;
                                                    attrs = new LinkedList();
                                                    if ((c = valueStr.charAt(pos++)) == '(') break block70;
                                                    woidBuffer = new StringBuilder();
                                                    pos = DITContentRuleSyntax.readWOID(lowerStr, woidBuffer, pos - 1);
                                                    attr = schema.getAttributeType(woidBuffer.toString());
                                                    if (attr == null) {
                                                        if (!allowUnknownElements) {
                                                            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_PROHIBITED_ATTR.get(valueStr, woidBuffer.toString());
                                                            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                                        }
                                                        attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                                                    }
                                                    attrs.add(attr);
                                                    break block60;
                                                }
                                                LinkedList<String> valueList = new LinkedList<String>();
                                                pos = DITContentRuleSyntax.readExtraParameterValues(valueStr, valueList, pos);
                                                extraProperties.put(tokenName, valueList);
                                                continue;
                                            }
                                            userBuffer = new StringBuilder();
                                            lowerBuffer = new StringBuilder();
                                            pos = DITContentRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                                            names.put(lowerBuffer.toString(), userBuffer.toString());
                                            while (true) {
                                                if (valueStr.charAt(pos) == ')') {
                                                    ++pos;
                                                    while (true) {
                                                        if (pos >= length || (c = valueStr.charAt(pos)) != ' ') continue block5;
                                                        ++pos;
                                                    }
                                                }
                                                userBuffer = new StringBuilder();
                                                lowerBuffer = new StringBuilder();
                                                pos = DITContentRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                                                names.put(lowerBuffer.toString(), userBuffer.toString());
                                            }
                                        }
                                        do {
                                            woidBuffer = new StringBuilder();
                                            pos = DITContentRuleSyntax.readWOID(lowerStr, woidBuffer, pos);
                                            oc2 = schema.getObjectClass(woidBuffer.toString());
                                            if (oc2 == null) {
                                                if (!allowUnknownElements) {
                                                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_AUXILIARY_CLASS.get(valueStr, woidBuffer.toString());
                                                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                                }
                                                oc2 = DirectoryServer.getDefaultAuxiliaryObjectClass(woidBuffer.toString());
                                            } else if (oc2.getObjectClassType() != ObjectClassType.AUXILIARY) {
                                                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_AUXILIARY_CLASS_NOT_AUXILIARY.get(valueStr, woidBuffer.toString(), oc2.getObjectClassType().toString());
                                                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                            }
                                            ocs.add(oc2);
                                            c = valueStr.charAt(pos++);
                                            if (c == ')') break block57;
                                        } while (c == '$');
                                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1);
                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                                    }
                                    auxiliaryClasses.addAll(ocs);
                                    continue;
                                }
                                do {
                                    woidBuffer = new StringBuilder();
                                    pos = DITContentRuleSyntax.readWOID(lowerStr, woidBuffer, pos);
                                    attr = schema.getAttributeType(woidBuffer.toString());
                                    if (attr == null) {
                                        if (!allowUnknownElements) {
                                            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_REQUIRED_ATTR.get(valueStr, woidBuffer.toString());
                                            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                        }
                                        attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                                    }
                                    attrs.add(attr);
                                    c = valueStr.charAt(pos++);
                                    if (c == ')') break block58;
                                } while (c == '$');
                                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1);
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                            }
                            requiredAttributes.addAll(attrs);
                            continue;
                        }
                        do {
                            woidBuffer = new StringBuilder();
                            pos = DITContentRuleSyntax.readWOID(lowerStr, woidBuffer, pos);
                            attr = schema.getAttributeType(woidBuffer.toString());
                            if (attr == null) {
                                if (!allowUnknownElements) {
                                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_OPTIONAL_ATTR.get(valueStr, woidBuffer.toString());
                                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                }
                                attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                            }
                            attrs.add(attr);
                            c = valueStr.charAt(pos++);
                            if (c == ')') break block59;
                        } while (c == '$');
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    optionalAttributes.addAll(attrs);
                    continue;
                }
                do {
                    woidBuffer = new StringBuilder();
                    pos = DITContentRuleSyntax.readWOID(lowerStr, woidBuffer, pos);
                    attr = schema.getAttributeType(woidBuffer.toString());
                    if (attr == null) {
                        if (!allowUnknownElements) {
                            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_UNKNOWN_PROHIBITED_ATTR.get(valueStr, woidBuffer.toString());
                            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                        }
                        attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                    }
                    attrs.add(attr);
                    c = valueStr.charAt(pos++);
                    if (c == ')') break block60;
                } while (c == '$');
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            prohibitedAttributes.addAll(attrs);
        }
        Iterator i$ = prohibitedAttributes.iterator();
        block12: while (true) {
            if (!i$.hasNext()) {
                return new DITContentRule(value.stringValue(), structuralClass, names, description, auxiliaryClasses, requiredAttributes, optionalAttributes, prohibitedAttributes, isObsolete, extraProperties);
            }
            t = (AttributeType)i$.next();
            if (structuralClass.isRequired(t)) {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_STRUCTURAL.get(valueStr, t.getNameOrOID(), structuralClass.getNameOrOID());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            Iterator i$2 = auxiliaryClasses.iterator();
            do {
                if (!i$2.hasNext()) continue block12;
            } while (!(oc = (ObjectClass)i$2.next()).isRequired(t));
            break;
        }
        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_PROHIBITED_REQUIRED_BY_AUXILIARY.get(valueStr, t.getNameOrOID(), oc.getNameOrOID());
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, String lowerStr, StringBuilder userBuffer, StringBuilder lowerBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) != '\'') {
            lowerBuffer.append(c);
            userBuffer.append(valueStr.charAt(startPos));
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readWOID(String lowerStr, StringBuilder woidBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_DOUBLE_PERIOD_IN_NUMERIC_OID.get(lowerStr, startPos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    woidBuffer.append(c);
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return startPos - 1;
                    }
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR_IN_NUMERIC_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                woidBuffer.append(c);
                lastWasPeriod = false;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    woidBuffer.append(c);
                    continue;
                }
                if (c == ')') {
                    return startPos - 1;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR_IN_STRING_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        } else {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR.get(lowerStr, String.valueOf(c), startPos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readExtraParameterValues(String valueStr, List<String> valueList, int startPos) throws DirectoryException {
        StringBuilder valueBuffer;
        int length = valueStr.length();
        char c = valueStr.charAt(startPos++);
        while (startPos < length && c == ' ') {
            c = valueStr.charAt(startPos++);
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c == '\'') {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != '\'') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        } else if (c == '(') {
            while (true) {
                ++startPos;
                while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                    ++startPos;
                }
                if (startPos >= length) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(valueStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                if (c != ')') {
                    if (c == '(') {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), startPos);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    startPos = DITContentRuleSyntax.readExtraParameterValues(valueStr, valueList, startPos);
                    continue;
                }
                break;
            }
        } else {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        }
        while (startPos < length && valueStr.charAt(startPos) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DCR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }
}

