/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public class AuthPasswordExactEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "authPasswordExactMatch";
    }

    public String getOID() {
        return "1.3.6.1.4.1.4203.1.2.2";
    }

    public String getDescription() {
        return "authentication password exact matching rule";
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.4203.1.1.2";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        try {
            StringBuilder[] authPWComponents = AuthPasswordSyntax.decodeAuthPassword(value.stringValue());
            StringBuilder normalizedValue = new StringBuilder(2 + authPWComponents[0].length() + authPWComponents[1].length() + authPWComponents[2].length());
            normalizedValue.append((CharSequence)authPWComponents[0]);
            normalizedValue.append('$');
            normalizedValue.append((CharSequence)authPWComponents[1]);
            normalizedValue.append('$');
            normalizedValue.append((CharSequence)authPWComponents[2]);
            return new ASN1OctetString(normalizedValue.toString());
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw de;
                }
                case WARN: {
                    ErrorLogger.logError(de.getMessageObject());
                    return new ASN1OctetString(value.stringValue());
                }
            }
            return new ASN1OctetString(value.stringValue());
        }
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

