/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.server.ReplicationDB;

public class ReplicationIterator {
    private UpdateMessage currentChange = null;
    private ReplicationDB.ReplServerDBCursor cursor = null;

    public ReplicationIterator(short id, ReplicationDB db, ChangeNumber changeNumber) throws Exception, DatabaseException {
        this.cursor = db.openReadCursor(changeNumber);
        if (this.cursor == null) {
            throw new Exception("no new change");
        }
        if (!this.next()) {
            this.cursor.close();
            this.cursor = null;
            throw new Exception("no new change");
        }
    }

    public UpdateMessage getChange() {
        return this.currentChange;
    }

    public boolean next() {
        this.currentChange = this.cursor.next();
        return this.currentChange != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCursor() {
        ReplicationIterator replicationIterator = this;
        synchronized (replicationIterator) {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        }
    }

    protected void finalize() {
        this.releaseCursor();
    }
}

