/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.opends.messages.BackendMessages;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.admin.std.server.ReplicationSynchronizationProviderCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.backends.jeb.BackupManager;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.plugin.ReplicationServerListener;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Operation;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.DeleteChangeRecordEntry;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.ModifyDNChangeRecordEntry;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationBackend
extends Backend {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String BASE_DN = "dc=replicationchanges";
    private DN[] baseDNs;
    private HashSet<DN> baseDNSet;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private ReplicationServer server;
    private BackendCfg cfg;
    private long progressInterval = 10000L;
    private long exportedCount = 0L;
    private long skippedCount = 0L;
    private HashMap<ObjectClass, String> rootObjectclasses;
    private LinkedHashMap<AttributeType, List<Attribute>> attributes;
    private Map<AttributeType, List<Attribute>> operationalAttributes;

    public void setBaseDNs(DN[] baseDNs) {
        this.baseDNs = baseDNs;
    }

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        if (config != null) {
            Validator.ensureTrue(config instanceof BackendCfg);
            this.cfg = (BackendCfg)config;
            DN[] baseDNs = new DN[this.cfg.getBaseDN().size()];
            this.cfg.getBaseDN().toArray(baseDNs);
            this.setBaseDNs(baseDNs);
        }
    }

    @Override
    public synchronized void initializeBackend() throws ConfigException, InitializationException {
        if (this.baseDNs == null || this.baseDNs.length != 1) {
            Message message = BackendMessages.ERR_MEMORYBACKEND_REQUIRE_EXACTLY_ONE_BASE.get();
            throw new ConfigException(message);
        }
        this.baseDNSet = new HashSet();
        for (DN dn : this.baseDNs) {
            this.baseDNSet.add(dn);
        }
        this.supportedControls = new HashSet();
        this.supportedFeatures = new HashSet();
        for (DN dn : this.baseDNs) {
            try {
                DirectoryServer.registerBaseDN(dn, this, true);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(dn.toString(), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message, (Throwable)e);
            }
        }
        this.rootObjectclasses = new LinkedHashMap<ObjectClass, String>(3);
        this.rootObjectclasses.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass domainOC = DirectoryServer.getObjectClass("domain", true);
        this.rootObjectclasses.put(domainOC, "domain");
        ObjectClass objectclassOC = DirectoryServer.getObjectClass("objectclasses", true);
        this.rootObjectclasses.put(objectclassOC, "objectclasses");
        this.attributes = new LinkedHashMap();
        AttributeType changeType = DirectoryServer.getAttributeType("changetype", true);
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        valueSet.add(new AttributeValue(changeType, "add"));
        Attribute a = new Attribute(changeType, "changetype", valueSet);
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(a);
        this.attributes.put(changeType, attrList);
        this.operationalAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
    }

    @Override
    public synchronized void finalizeBackend() {
        for (DN dn : this.baseDNs) {
            try {
                DirectoryServer.deregisterBaseDN(dn);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public synchronized long getEntryCount() {
        if (this.server == null) {
            try {
                this.server = this.getReplicationServer();
                if (this.server == null) {
                    return 0L;
                }
            }
            catch (Exception e) {
                return 0L;
            }
        }
        long retNum = 0L;
        Iterator<ReplicationServerDomain> rcachei = this.server.getCacheIterator();
        if (rcachei != null) {
            while (rcachei.hasNext()) {
                ReplicationServerDomain rsd = rcachei.next();
                retNum += rsd.getChangesCount();
            }
        }
        return retNum;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        return true;
    }

    @Override
    public synchronized Entry getEntry(DN entryDN) {
        Entry e = null;
        try {
            if (this.baseDNSet.contains(entryDN)) {
                return new Entry(entryDN, this.rootObjectclasses, this.attributes, this.operationalAttributes);
            }
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            SearchFilter filter = SearchFilter.createFilterFromString("(changetype=*)");
            InternalSearchOperation searchOperation = new InternalSearchOperation((ClientConnection)conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, entryDN, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, null, null);
            this.search(searchOperation);
            LinkedList<SearchResultEntry> resultEntries = searchOperation.getSearchEntries();
            if (resultEntries.size() != 0) {
                e = resultEntries.getFirst();
            }
        }
        catch (DirectoryException ex) {
            e = null;
        }
        return e;
    }

    @Override
    public synchronized boolean entryExists(DN entryDN) {
        return this.getEntry(entryDN) != null;
    }

    @Override
    public synchronized void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_ADD_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public synchronized void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_DELETE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public synchronized void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_MODIFY_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public synchronized void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_MODIFY_DN_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        LDIFWriter ldifWriter;
        List<DN> includeBranches = exportConfig.getIncludeBranches();
        ArrayList<ReplicationServerDomain> exportContainers = new ArrayList<ReplicationServerDomain>();
        if (this.server == null) {
            Message message = ReplicationMessages.ERR_REPLICATONBACKEND_EXPORT_LDIF_FAILED.get();
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        Iterator<ReplicationServerDomain> rsdi = this.server.getCacheIterator();
        if (rsdi != null) {
            while (rsdi.hasNext()) {
                ReplicationServerDomain rc = rsdi.next();
                DN baseDN = DN.decode(rc.getBaseDn().toString() + "," + BASE_DN);
                if (includeBranches == null || includeBranches.isEmpty()) {
                    exportContainers.add(rc);
                    continue;
                }
                for (DN includeBranch : includeBranches) {
                    if (!includeBranch.isDescendantOf(baseDN) && !includeBranch.isAncestorOf(baseDN)) continue;
                    exportContainers.add(rc);
                }
            }
        }
        long startTime = System.currentTimeMillis();
        Timer timer = new Timer();
        ProgressTask progressTask = new ProgressTask();
        timer.scheduleAtFixedRate((TimerTask)progressTask, this.progressInterval, this.progressInterval);
        try {
            ldifWriter = new LDIFWriter(exportConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ReplicationMessages.ERR_BACKEND_CANNOT_CREATE_LDIF_WRITER.get(String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        this.exportRootChanges(exportContainers, exportConfig, ldifWriter);
        try {
            for (ReplicationServerDomain exportContainer : exportContainers) {
                if (exportConfig.isCancelled()) {
                    break;
                }
                this.processContainer(exportContainer, exportConfig, ldifWriter, null);
            }
        }
        finally {
            block19: {
                timer.cancel();
                try {
                    ldifWriter.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block19;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        long finishTime = System.currentTimeMillis();
        long totalTime = finishTime - startTime;
        float rate = 0.0f;
        if (totalTime > 0L) {
            rate = 1000.0f * (float)this.exportedCount / (float)totalTime;
        }
        Message message = JebMessages.NOTE_JEB_EXPORT_FINAL_STATUS.get(this.exportedCount, this.skippedCount, totalTime / 1000L, Float.valueOf(rate));
        ErrorLogger.logError(message);
    }

    private void exportRootChanges(List<ReplicationServerDomain> exportContainers, LDIFExportConfig exportConfig, LDIFWriter ldifWriter) {
        HashMap<AttributeType, List<Attribute>> attributes = new HashMap<AttributeType, List<Attribute>>();
        ArrayList<Attribute> ldapAttrList = new ArrayList<Attribute>();
        AttributeType ocType = DirectoryServer.getAttributeType("objectclass", true);
        LinkedHashSet<AttributeValue> ocValues = new LinkedHashSet<AttributeValue>();
        ocValues.add(new AttributeValue(ocType, "top"));
        ocValues.add(new AttributeValue(ocType, "domain"));
        Attribute ocAttr = new Attribute(ocType, "objectclass", ocValues);
        ldapAttrList.add(ocAttr);
        attributes.put(ocType, ldapAttrList);
        try {
            AddChangeRecordEntry changeRecord = new AddChangeRecordEntry(DN.decode(BASE_DN), attributes);
            ldifWriter.writeChangeRecord(changeRecord);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (ReplicationServerDomain exportContainer : exportContainers) {
            if (exportConfig != null && exportConfig.isCancelled()) break;
            attributes.clear();
            ldapAttrList.clear();
            ldapAttrList.add(ocAttr);
            AttributeType stateType = DirectoryServer.getAttributeType("state", true);
            LinkedHashSet<AttributeValue> stateValues = new LinkedHashSet<AttributeValue>();
            stateValues.add(new AttributeValue(stateType, exportContainer.getDbServerState().toString()));
            TRACER.debugInfo("State=" + exportContainer.getDbServerState().toString());
            Attribute stateAttr = new Attribute(ocType, "state", stateValues);
            ldapAttrList.add(stateAttr);
            AttributeType genidType = DirectoryServer.getAttributeType("generation-id", true);
            LinkedHashSet<AttributeValue> genidValues = new LinkedHashSet<AttributeValue>();
            genidValues.add(new AttributeValue(genidType, String.valueOf(exportContainer.getGenerationId()) + exportContainer.getBaseDn()));
            Attribute genidAttr = new Attribute(ocType, "generation-id", genidValues);
            ldapAttrList.add(genidAttr);
            attributes.put(genidType, ldapAttrList);
            try {
                AddChangeRecordEntry changeRecord = new AddChangeRecordEntry(DN.decode(exportContainer.getBaseDn() + "," + BASE_DN), attributes);
                ldifWriter.writeChangeRecord(changeRecord);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ReplicationMessages.ERR_BACKEND_EXPORT_ENTRY.get(exportContainer.getBaseDn() + "," + BASE_DN, String.valueOf(e));
                ErrorLogger.logError(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContainer(ReplicationServerDomain rsd, LDIFExportConfig exportConfig, LDIFWriter ldifWriter, SearchOperation searchOperation) {
        block3: for (Short serverId : rsd.getServers()) {
            if (exportConfig != null && exportConfig.isCancelled()) break;
            ReplicationIterator ri = rsd.getChangelogIterator(serverId, null);
            if (ri == null) continue;
            try {
                while (!(ri.getChange() == null || exportConfig != null && exportConfig.isCancelled())) {
                    UpdateMessage msg = ri.getChange();
                    this.processChange(msg, exportConfig, ldifWriter, searchOperation);
                    if (ri.next()) continue;
                    continue block3;
                }
            }
            finally {
                ri.releaseCursor();
            }
        }
    }

    private void processChange(UpdateMessage msg, LDIFExportConfig exportConfig, LDIFWriter ldifWriter, SearchOperation searchOperation) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        Entry entry = null;
        DN dn = null;
        try {
            Operation op;
            LDIFReader reader;
            LDIFWriter ldifWriter2;
            Writer writer;
            ChangeRecordEntry changeRecord;
            if (msg instanceof AddMsg) {
                AddMsg addMsg = (AddMsg)msg;
                AddOperation addOperation = (AddOperation)((Object)msg.createOperation(conn));
                dn = DN.decode("puid=" + addMsg.getParentUid() + "," + "changeNumber=" + msg.getChangeNumber().toString() + "," + msg.getDn() + "," + BASE_DN);
                HashMap<AttributeType, List<Attribute>> attributes = new HashMap<AttributeType, List<Attribute>>();
                for (RawAttribute a : addOperation.getRawAttributes()) {
                    Attribute attr = a.toAttribute();
                    AttributeType attrType = attr.getAttributeType();
                    ArrayList<Attribute> attrs = (ArrayList<Attribute>)attributes.get(attrType);
                    if (attrs == null) {
                        attrs = new ArrayList<Attribute>(1);
                        attrs.add(attr);
                        attributes.put(attrType, attrs);
                        continue;
                    }
                    attrs.add(attr);
                }
                AddChangeRecordEntry changeRecord2 = new AddChangeRecordEntry(dn, attributes);
                if (exportConfig != null) {
                    ldifWriter.writeChangeRecord(changeRecord2);
                } else {
                    Writer writer2 = new Writer();
                    LDIFWriter ldifWriter22 = writer2.getLDIFWriter();
                    ldifWriter22.writeChangeRecord(changeRecord2);
                    LDIFReader reader2 = writer2.getLDIFReader();
                    entry = reader2.readEntry();
                }
            } else if (msg instanceof DeleteMsg) {
                DeleteMsg delMsg = (DeleteMsg)msg;
                dn = DN.decode("uuid=" + msg.getUniqueId() + "," + "changeNumber=" + delMsg.getChangeNumber().toString() + "," + msg.getDn() + "," + BASE_DN);
                changeRecord = new DeleteChangeRecordEntry(dn);
                if (exportConfig != null) {
                    ldifWriter.writeChangeRecord(changeRecord);
                } else {
                    writer = new Writer();
                    ldifWriter2 = writer.getLDIFWriter();
                    ldifWriter2.writeChangeRecord(changeRecord);
                    reader = writer.getLDIFReader();
                    entry = reader.readEntry();
                }
            } else if (msg instanceof ModifyMsg) {
                op = (ModifyOperation)((Object)msg.createOperation(conn));
                dn = DN.decode("uuid=" + msg.getUniqueId() + "," + "changeNumber=" + msg.getChangeNumber().toString() + "," + msg.getDn() + "," + BASE_DN);
                op.setInternalOperation(true);
                changeRecord = new ModifyChangeRecordEntry(dn, op.getRawModifications());
                if (exportConfig != null) {
                    ldifWriter.writeChangeRecord(changeRecord);
                } else {
                    writer = new Writer();
                    ldifWriter2 = writer.getLDIFWriter();
                    ldifWriter2.writeChangeRecord(changeRecord);
                    reader = writer.getLDIFReader();
                    entry = reader.readEntry();
                }
            } else if (msg instanceof ModifyDNMsg) {
                op = (ModifyDNOperation)((Object)msg.createOperation(conn));
                dn = DN.decode("uuid=" + msg.getUniqueId() + "," + "changeNumber=" + msg.getChangeNumber().toString() + "," + msg.getDn() + "," + BASE_DN);
                op.setInternalOperation(true);
                changeRecord = new ModifyDNChangeRecordEntry(dn, op.getNewRDN(), op.deleteOldRDN(), op.getNewSuperior());
                if (exportConfig != null) {
                    ldifWriter.writeChangeRecord(changeRecord);
                } else {
                    Entry modDNEntry;
                    writer = new Writer();
                    ldifWriter2 = writer.getLDIFWriter();
                    ldifWriter2.writeChangeRecord(changeRecord);
                    reader = writer.getLDIFReader();
                    entry = modDNEntry = reader.readEntry();
                }
            }
            if (exportConfig != null) {
                ++this.exportedCount;
            } else {
                DN searchBaseDN = searchOperation.getBaseDN();
                SearchScope scope = searchOperation.getScope();
                SearchFilter filter = searchOperation.getFilter();
                boolean ms = entry.matchesBaseAndScope(searchBaseDN, scope);
                boolean mf = filter.matchesEntry(entry);
                if (ms && mf) {
                    searchOperation.returnEntry(entry, new LinkedList<Control>());
                }
            }
        }
        catch (Exception e) {
            ++this.skippedCount;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = null;
            message = exportConfig != null ? ReplicationMessages.ERR_BACKEND_EXPORT_ENTRY.get(dn.toNormalizedString(), String.valueOf(e)) : ReplicationMessages.ERR_BACKEND_SEARCH_ENTRY.get(dn.toNormalizedString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public synchronized LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        Message message = ReplicationMessages.ERR_REPLICATONBACKEND_IMPORT_LDIF_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsBackup() {
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return true;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        BackupManager backupManager = new BackupManager(this.getBackendID());
        File backendDir = StaticUtils.getFileForPath(this.getReplicationServerCfg().getReplicationDBDirectory());
        backupManager.createBackup(backendDir, backupConfig);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.removeBackup(backupDirectory, backupID);
    }

    @Override
    public boolean supportsRestore() {
        return true;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        BackupManager backupManager = new BackupManager(this.getBackendID());
        File backendDir = StaticUtils.getFileForPath(this.getReplicationServerCfg().getReplicationDBDirectory());
        backupManager.restoreBackup(backendDir, restoreConfig);
    }

    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, BackendMessages.ERR_NUM_SUBORDINATES_NOT_SUPPORTED.get());
    }

    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, BackendMessages.ERR_HAS_SUBORDINATES_NOT_SUPPORTED.get());
    }

    public void setServer(ReplicationServer server) {
        this.server = server;
    }

    @Override
    public synchronized void search(SearchOperation searchOperation) throws DirectoryException {
        Iterator<ReplicationServerDomain> rsdi;
        SearchFilter filter;
        SearchScope scope;
        DN searchBaseDN = searchOperation.getBaseDN();
        ArrayList<ReplicationServerDomain> searchContainers = new ArrayList<ReplicationServerDomain>();
        List<Control> requestControls = searchOperation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.1")) continue;
                return;
            }
        }
        if (!this.handlesEntry(searchBaseDN)) {
            DN matchedDN;
            for (matchedDN = searchBaseDN.getParentDNInSuffix(); matchedDN != null && !this.handlesEntry(matchedDN); matchedDN = matchedDN.getParentDNInSuffix()) {
            }
            Message message = ReplicationMessages.ERR_REPLICATIONBACKEND_ENTRY_DOESNT_EXIST.get(String.valueOf(searchBaseDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
        }
        if (this.server == null) {
            this.server = this.getReplicationServer();
            if (this.server == null) {
                if (this.baseDNSet.contains(searchBaseDN)) {
                    scope = searchOperation.getScope();
                    filter = searchOperation.getFilter();
                    Entry re = new Entry(searchBaseDN, this.rootObjectclasses, this.attributes, this.operationalAttributes);
                    if (re.matchesBaseAndScope(searchBaseDN, scope) && filter.matchesEntry(re)) {
                        searchOperation.returnEntry(re, new LinkedList<Control>());
                    }
                    return;
                }
                Message message = ReplicationMessages.ERR_REPLICATIONBACKEND_ENTRY_DOESNT_EXIST.get(String.valueOf(searchBaseDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, null, null);
            }
        }
        scope = searchOperation.getScope();
        filter = searchOperation.getFilter();
        Entry re = new Entry(searchBaseDN, this.rootObjectclasses, this.attributes, this.operationalAttributes);
        if (re.matchesBaseAndScope(searchBaseDN, scope) && filter.matchesEntry(re)) {
            searchOperation.returnEntry(re, new LinkedList<Control>());
        }
        if ((rsdi = this.server.getCacheIterator()) != null) {
            while (rsdi.hasNext()) {
                ReplicationServerDomain rsd = rsdi.next();
                DN baseDN = DN.decode(rsd.getBaseDn().toString() + "," + BASE_DN);
                if (!searchBaseDN.isDescendantOf(baseDN) && !searchBaseDN.isAncestorOf(baseDN)) continue;
                searchContainers.add(rsd);
            }
        }
        for (ReplicationServerDomain exportContainer : searchContainers) {
            this.processContainer(exportContainer, null, null, searchOperation);
        }
    }

    private ReplicationServer getReplicationServer() throws DirectoryException {
        ReplicationServer replicationServer = null;
        DirectoryServer.getSynchronizationProviders();
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            MultimasterReplication mmp;
            ReplicationServerListener list;
            if (!(provider instanceof MultimasterReplication) || (list = (mmp = (MultimasterReplication)provider).getReplicationServerListener()) == null) continue;
            replicationServer = list.getReplicationServer();
            break;
        }
        return replicationServer;
    }

    private ReplicationServerCfg getReplicationServerCfg() throws DirectoryException {
        RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
        for (String name : root.listSynchronizationProviders()) {
            SynchronizationProviderCfg cfg;
            try {
                cfg = root.getSynchronizationProvider(name);
            }
            catch (ConfigException e) {
                throw new DirectoryException(ResultCode.OPERATIONS_ERROR, ReplicationMessages.ERR_REPLICATION_SERVER_CONFIG_NOT_FOUND.get(), e);
            }
            if (!(cfg instanceof ReplicationSynchronizationProviderCfg)) continue;
            ReplicationSynchronizationProviderCfg scfg = (ReplicationSynchronizationProviderCfg)cfg;
            try {
                return scfg.getReplicationServer();
            }
            catch (ConfigException e) {
                throw new DirectoryException(ResultCode.OPERATIONS_ERROR, ReplicationMessages.ERR_REPLICATION_SERVER_CONFIG_NOT_FOUND.get(), e);
            }
        }
        throw new DirectoryException(ResultCode.OPERATIONS_ERROR, ReplicationMessages.ERR_REPLICATION_SERVER_CONFIG_NOT_FOUND.get());
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    private static final class Writer {
        private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        private final LDIFExportConfig config = new LDIFExportConfig(this.stream);
        private final LDIFWriter writer;

        public Writer() {
            try {
                this.writer = new LDIFWriter(this.config);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public LDIFWriter getLDIFWriter() {
            return this.writer;
        }

        public BufferedReader getLDIFBufferedReader() throws Exception {
            this.writer.close();
            String ldif = this.stream.toString("UTF-8");
            StringReader reader = new StringReader(ldif);
            return new BufferedReader(reader);
        }

        public LDIFReader getLDIFReader() throws Exception {
            this.writer.close();
            ByteArrayInputStream istream = new ByteArrayInputStream(this.stream.toByteArray());
            String ldif = this.stream.toString("UTF-8");
            ldif = ldif.replace("\n-\n", "\n");
            istream = new ByteArrayInputStream(ldif.getBytes());
            LDIFImportConfig config = new LDIFImportConfig(istream);
            return new LDIFReader(config);
        }
    }

    private final class ProgressTask
    extends TimerTask {
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();

        public void run() {
            long latestCount = ReplicationBackend.this.exportedCount;
            long deltaCount = latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            Message message = JebMessages.NOTE_JEB_EXPORT_PROGRESS_REPORT.get(latestCount, ReplicationBackend.this.skippedCount, Float.valueOf(rate));
            ErrorLogger.logError(message);
            this.previousCount = latestCount;
            this.previousTime = latestTime;
        }
    }
}

