/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.admin.std.server.ReplicationSynchronizationProviderCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationServerListener
implements ConfigurationAddListener<ReplicationServerCfg>,
ConfigurationDeleteListener<ReplicationServerCfg> {
    ReplicationServer replicationServer = null;

    public ReplicationServerListener(ReplicationSynchronizationProviderCfg configuration) throws ConfigException {
        configuration.addReplicationServerAddListener(this);
        configuration.addReplicationServerDeleteListener(this);
        if (configuration.hasReplicationServer()) {
            ReplicationServerCfg server = configuration.getReplicationServer();
            this.replicationServer = new ReplicationServer(server);
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ReplicationServerCfg configuration) {
        try {
            this.replicationServer = new ReplicationServer(configuration);
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }
        catch (ConfigException e) {
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(ReplicationServerCfg configuration, List<Message> unacceptableReasons) {
        return ReplicationServer.isConfigurationAcceptable(configuration, unacceptableReasons);
    }

    public void shutdown() {
        if (this.replicationServer != null) {
            this.replicationServer.shutdown();
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ReplicationServerCfg configuration) {
        if (this.replicationServer != null) {
            this.replicationServer.remove();
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(ReplicationServerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public ReplicationServer getReplicationServer() {
        return this.replicationServer;
    }
}

