/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.BindOperationBasis;
import org.opends.server.core.CompareOperationBasis;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.core.ExtendedOperationBasis;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalLDAPSocket;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class InternalLDAPOutputStream
extends OutputStream
implements InternalSearchListener {
    private boolean closed;
    private boolean needType;
    private byte elementType;
    private byte[] elementBytes;
    private byte[] lengthBytes;
    private int arrayOffset;
    private InternalLDAPSocket socket;

    public InternalLDAPOutputStream(InternalLDAPSocket socket) {
        this.socket = socket;
        this.closed = false;
        this.needType = true;
        this.elementType = 0;
        this.elementBytes = null;
        this.lengthBytes = null;
        this.arrayOffset = 0;
    }

    public void close() {
        this.socket.close();
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    void closeInternal() {
        this.closed = true;
    }

    public void flush() {
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int needed;
        if (this.closed) {
            Message m = ProtocolMessages.ERR_INTERNALOS_CLOSED.get();
            throw new IOException(m.toString());
        }
        if (len == 0) {
            return;
        }
        int position = off;
        int remaining = len;
        if (this.needType) {
            this.elementType = b[position++];
            this.needType = false;
            if (--remaining <= 0) {
                return;
            }
        }
        if (this.lengthBytes == null && this.elementBytes == null) {
            byte length;
            if ((length = b[position++]) == (length & 0x7F)) {
                this.elementBytes = new byte[length];
            } else {
                this.lengthBytes = new byte[length & 0x7F];
            }
            this.arrayOffset = 0;
            if (--remaining <= 0) {
                return;
            }
        }
        if (this.lengthBytes != null) {
            needed = this.lengthBytes.length - this.arrayOffset;
            if (remaining >= needed) {
                System.arraycopy(b, position, this.lengthBytes, this.arrayOffset, needed);
                position += needed;
                remaining -= needed;
                int length = 0;
                for (byte lb : this.lengthBytes) {
                    length <<= 8;
                    length |= lb & 0xFF;
                }
                this.elementBytes = new byte[length];
                this.lengthBytes = null;
                this.arrayOffset = 0;
                if (remaining <= 0) {
                    return;
                }
            } else {
                System.arraycopy(b, position, this.lengthBytes, this.arrayOffset, remaining);
                this.arrayOffset += remaining;
                return;
            }
        }
        if (this.elementBytes != null) {
            needed = this.elementBytes.length - this.arrayOffset;
            if (remaining >= needed) {
                System.arraycopy(b, position, this.elementBytes, this.arrayOffset, needed);
                position += needed;
                remaining -= needed;
                this.processElement(new ASN1Element(this.elementType, this.elementBytes));
                this.needType = true;
                this.arrayOffset = 0;
                this.lengthBytes = null;
                this.elementBytes = null;
            } else {
                System.arraycopy(b, position, this.lengthBytes, this.arrayOffset, remaining);
                this.arrayOffset += remaining;
                return;
            }
        }
        if (remaining > 0) {
            this.write(b, position, remaining);
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            Message m = ProtocolMessages.ERR_INTERNALOS_CLOSED.get();
            throw new IOException(m.toString());
        }
        if (this.needType) {
            this.elementType = (byte)(b & 0xFF);
            this.needType = false;
            return;
        }
        if (this.elementBytes != null) {
            this.elementBytes[this.arrayOffset++] = (byte)(b & 0xFF);
            if (this.arrayOffset == this.elementBytes.length) {
                this.processElement(new ASN1Element(this.elementType, this.elementBytes));
            }
            this.lengthBytes = null;
            this.elementBytes = null;
            this.arrayOffset = 0;
            this.needType = true;
            return;
        }
        if (this.lengthBytes != null) {
            this.lengthBytes[this.arrayOffset++] = (byte)(b & 0xFF);
            if (this.arrayOffset == this.lengthBytes.length) {
                int length = 0;
                for (int i = 0; i < this.lengthBytes.length; ++i) {
                    length <<= 8;
                    length |= this.lengthBytes[i] & 0xFF;
                }
                this.elementBytes = new byte[length];
                this.lengthBytes = null;
                this.arrayOffset = 0;
            }
            return;
        }
        if ((b & 0x7F) == b) {
            this.elementBytes = new byte[b];
            this.lengthBytes = null;
            this.arrayOffset = 0;
        } else {
            this.lengthBytes = new byte[b & 0x7F];
            this.elementBytes = null;
            this.arrayOffset = 0;
        }
    }

    private void processElement(ASN1Element element) throws IOException {
        LDAPMessage message;
        try {
            message = LDAPMessage.decode(element.decodeAsSequence());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        switch (message.getProtocolOpType()) {
            case 80: {
                return;
            }
            case 104: {
                this.processAddOperation(message);
                break;
            }
            case 96: {
                this.processBindOperation(message);
                break;
            }
            case 110: {
                this.processCompareOperation(message);
                break;
            }
            case 74: {
                this.processDeleteOperation(message);
                break;
            }
            case 119: {
                this.processExtendedOperation(message);
                break;
            }
            case 102: {
                this.processModifyOperation(message);
                break;
            }
            case 108: {
                this.processModifyDNOperation(message);
                break;
            }
            case 99: {
                this.processSearchOperation(message);
                break;
            }
            case 66: {
                this.socket.close();
                break;
            }
            default: {
                Message m = ProtocolMessages.ERR_INTERNALOS_INVALID_REQUEST.get(message.getProtocolElementName());
                throw new IOException(m.toString());
            }
        }
    }

    private void processAddOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        AddRequestProtocolOp request = message.getAddRequestProtocolOp();
        ArrayList<Control> requestControls = new ArrayList<Control>();
        if (message.getControls() != null) {
            for (LDAPControl c : message.getControls()) {
                requestControls.add(c.getControl());
            }
        }
        InternalClientConnection conn = this.socket.getConnection();
        AddOperationBasis op = new AddOperationBasis(conn, conn.nextOperationID(), messageID, requestControls, request.getDN(), request.getAttributes());
        op.run();
        AddResponseProtocolOp addResponse = new AddResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        ArrayList<LDAPControl> responseControls = new ArrayList<LDAPControl>();
        for (Control c : op.getResponseControls()) {
            responseControls.add(new LDAPControl(c));
        }
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, addResponse, responseControls));
    }

    private void processBindOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        BindRequestProtocolOp request = message.getBindRequestProtocolOp();
        if (request.getAuthenticationType() == AuthenticationType.SASL) {
            Message m = ProtocolMessages.ERR_INTERNALOS_SASL_BIND_NOT_SUPPORTED.get();
            BindResponseProtocolOp bindResponse = new BindResponseProtocolOp(53, m);
            this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, bindResponse));
            return;
        }
        ArrayList<Control> requestControls = new ArrayList<Control>();
        if (message.getControls() != null) {
            for (LDAPControl c : message.getControls()) {
                requestControls.add(c.getControl());
            }
        }
        InternalClientConnection conn = this.socket.getConnection();
        BindOperationBasis op = new BindOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, requestControls, String.valueOf(request.getProtocolVersion()), request.getDN(), (ByteString)request.getSimplePassword());
        op.run();
        BindResponseProtocolOp bindResponse = new BindResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        ArrayList<LDAPControl> responseControls = new ArrayList<LDAPControl>();
        for (Control c : op.getResponseControls()) {
            responseControls.add(new LDAPControl(c));
        }
        if (bindResponse.getResultCode() == 0) {
            this.socket.setConnection(new InternalClientConnection(op.getAuthenticationInfo()));
        }
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, bindResponse, responseControls));
    }

    private void processCompareOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        CompareRequestProtocolOp request = message.getCompareRequestProtocolOp();
        ArrayList<Control> requestControls = new ArrayList<Control>();
        if (message.getControls() != null) {
            for (LDAPControl c : message.getControls()) {
                requestControls.add(c.getControl());
            }
        }
        InternalClientConnection conn = this.socket.getConnection();
        CompareOperationBasis op = new CompareOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, requestControls, request.getDN(), request.getAttributeType(), (ByteString)request.getAssertionValue());
        op.run();
        CompareResponseProtocolOp compareResponse = new CompareResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        ArrayList<LDAPControl> responseControls = new ArrayList<LDAPControl>();
        for (Control c : op.getResponseControls()) {
            responseControls.add(new LDAPControl(c));
        }
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, compareResponse, responseControls));
    }

    private void processDeleteOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        DeleteRequestProtocolOp request = message.getDeleteRequestProtocolOp();
        ArrayList<Control> requestControls = new ArrayList<Control>();
        if (message.getControls() != null) {
            for (LDAPControl c : message.getControls()) {
                requestControls.add(c.getControl());
            }
        }
        InternalClientConnection conn = this.socket.getConnection();
        DeleteOperationBasis op = new DeleteOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, requestControls, request.getDN());
        op.run();
        DeleteResponseProtocolOp deleteResponse = new DeleteResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        ArrayList<LDAPControl> responseControls = new ArrayList<LDAPControl>();
        for (Control c : op.getResponseControls()) {
            responseControls.add(new LDAPControl(c));
        }
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, deleteResponse, responseControls));
    }

    private void processExtendedOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        ExtendedRequestProtocolOp request = message.getExtendedRequestProtocolOp();
        if (request.getOID().equals("1.3.6.1.4.1.1466.20037")) {
            Message m = ProtocolMessages.ERR_INTERNALOS_STARTTLS_NOT_SUPPORTED.get();
            ExtendedResponseProtocolOp extendedResponse = new ExtendedResponseProtocolOp(53, m);
            this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, extendedResponse));
            return;
        }
        ArrayList<Control> requestControls = new ArrayList<Control>();
        if (message.getControls() != null) {
            for (LDAPControl c : message.getControls()) {
                requestControls.add(c.getControl());
            }
        }
        InternalClientConnection conn = this.socket.getConnection();
        ExtendedOperationBasis op = new ExtendedOperationBasis(conn, conn.nextOperationID(), messageID, requestControls, request.getOID(), request.getValue());
        op.run();
        ExtendedResponseProtocolOp extendedResponse = new ExtendedResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs(), op.getResponseOID(), op.getResponseValue());
        ArrayList<LDAPControl> responseControls = new ArrayList<LDAPControl>();
        for (Control c : op.getResponseControls()) {
            responseControls.add(new LDAPControl(c));
        }
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, extendedResponse, responseControls));
    }

    private void processModifyOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        ModifyRequestProtocolOp request = message.getModifyRequestProtocolOp();
        ArrayList<Control> requestControls = new ArrayList<Control>();
        if (message.getControls() != null) {
            for (LDAPControl c : message.getControls()) {
                requestControls.add(c.getControl());
            }
        }
        InternalClientConnection conn = this.socket.getConnection();
        ModifyOperationBasis op = new ModifyOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, requestControls, request.getDN(), request.getModifications());
        op.run();
        ModifyResponseProtocolOp modifyResponse = new ModifyResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        ArrayList<LDAPControl> responseControls = new ArrayList<LDAPControl>();
        for (Control c : op.getResponseControls()) {
            responseControls.add(new LDAPControl(c));
        }
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, modifyResponse, responseControls));
    }

    private void processModifyDNOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        ModifyDNRequestProtocolOp request = message.getModifyDNRequestProtocolOp();
        ArrayList<Control> requestControls = new ArrayList<Control>();
        if (message.getControls() != null) {
            for (LDAPControl c : message.getControls()) {
                requestControls.add(c.getControl());
            }
        }
        InternalClientConnection conn = this.socket.getConnection();
        ModifyDNOperationBasis op = new ModifyDNOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, requestControls, request.getEntryDN(), request.getNewRDN(), request.deleteOldRDN(), request.getNewSuperior());
        op.run();
        ModifyDNResponseProtocolOp modifyDNResponse = new ModifyDNResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        ArrayList<LDAPControl> responseControls = new ArrayList<LDAPControl>();
        for (Control c : op.getResponseControls()) {
            responseControls.add(new LDAPControl(c));
        }
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, modifyDNResponse, responseControls));
    }

    private void processSearchOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        SearchRequestProtocolOp request = message.getSearchRequestProtocolOp();
        ArrayList<Control> requestControls = new ArrayList<Control>();
        if (message.getControls() != null) {
            for (LDAPControl c : message.getControls()) {
                requestControls.add(c.getControl());
            }
        }
        InternalClientConnection conn = this.socket.getConnection();
        InternalSearchOperation op = new InternalSearchOperation((ClientConnection)conn, conn.nextOperationID(), messageID, requestControls, request.getBaseDN(), request.getScope(), request.getDereferencePolicy(), request.getSizeLimit(), request.getTimeLimit(), request.getTypesOnly(), request.getFilter(), request.getAttributes(), (InternalSearchListener)this);
        op.run();
        SearchResultDoneProtocolOp searchDone = new SearchResultDoneProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        ArrayList<LDAPControl> responseControls = new ArrayList<LDAPControl>();
        for (Control c : op.getResponseControls()) {
            responseControls.add(new LDAPControl(c));
        }
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, searchDone, responseControls));
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void handleInternalSearchEntry(InternalSearchOperation searchOperation, SearchResultEntry searchEntry) {
        ArrayList<LDAPControl> entryControls = new ArrayList<LDAPControl>();
        for (Control c : searchEntry.getControls()) {
            entryControls.add(new LDAPControl(c));
        }
        SearchResultEntryProtocolOp entry = new SearchResultEntryProtocolOp(searchEntry);
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(searchOperation.getMessageID(), entry, entryControls));
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void handleInternalSearchReference(InternalSearchOperation searchOperation, SearchResultReference searchReference) {
        ArrayList<LDAPControl> entryControls = new ArrayList<LDAPControl>();
        for (Control c : searchReference.getControls()) {
            entryControls.add(new LDAPControl(c));
        }
        SearchResultReferenceProtocolOp reference = new SearchResultReferenceProtocolOp(searchReference);
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(searchOperation.getMessageID(), reference, entryControls));
    }

    public String toString() {
        return "InternalLDAPOutputStream";
    }
}

