/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.EntryUUIDPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntryUUIDPlugin
extends DirectoryServerPlugin<EntryUUIDPluginCfg>
implements ConfigurationChangeListener<EntryUUIDPluginCfg> {
    private static final String ENTRYUUID = "entryuuid";
    private final AttributeType entryUUIDType;
    private EntryUUIDPluginCfg currentConfig;

    public EntryUUIDPlugin() {
        AttributeType at = DirectoryConfig.getAttributeType(ENTRYUUID, false);
        if (at == null) {
            String definition = "( 1.3.6.1.1.16.4 NAME 'entryUUID' DESC 'UUID of the entry' EQUALITY uuidMatch ORDERING uuidOrderingMatch SYNTAX 1.3.6.1.1.16.1 SINGLE-VALUE NO-USER-MODIFICATION USAGE directoryOperation X-ORIGIN 'RFC 4530' )";
            at = new AttributeType(definition, ENTRYUUID, Collections.singleton(ENTRYUUID), ENTRYUUID, null, null, DirectoryConfig.getDefaultAttributeSyntax(), AttributeUsage.DIRECTORY_OPERATION, false, true, false, true);
        }
        this.entryUUIDType = at;
    }

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, EntryUUIDPluginCfg configuration) throws ConfigException {
        this.currentConfig = configuration;
        configuration.addEntryUUIDChangeListener(this);
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case LDIF_IMPORT: 
                case PRE_OPERATION_ADD: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_ENTRYUUID_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
    }

    @Override
    public final void finalizePlugin() {
        this.currentConfig.removeEntryUUIDChangeListener(this);
    }

    @Override
    public final PluginResult.ImportLDIF doLDIFImport(LDIFImportConfig importConfig, Entry entry) {
        List<Attribute> uuidList = entry.getAttribute(this.entryUUIDType);
        if (uuidList != null) {
            return PluginResult.ImportLDIF.continueEntryProcessing();
        }
        byte[] dnBytes = StaticUtils.getBytes(entry.getDN().toNormalizedString());
        UUID uuid = UUID.nameUUIDFromBytes(dnBytes);
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
        values.add(new AttributeValue(this.entryUUIDType, ByteStringFactory.create(uuid.toString())));
        uuidList = new ArrayList<Attribute>(1);
        Attribute uuidAttr = new Attribute(this.entryUUIDType, "entryUUID", values);
        uuidList.add(uuidAttr);
        entry.putAttribute(this.entryUUIDType, uuidList);
        return PluginResult.ImportLDIF.continueEntryProcessing();
    }

    @Override
    public final PluginResult.PreOperation doPreOperation(PreOperationAddOperation addOperation) {
        Map<AttributeType, List<Attribute>> operationalAttributes = addOperation.getOperationalAttributes();
        List<Attribute> uuidList = operationalAttributes.get(this.entryUUIDType);
        if (uuidList != null) {
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        UUID uuid = UUID.randomUUID();
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
        values.add(new AttributeValue(this.entryUUIDType, ByteStringFactory.create(uuid.toString())));
        uuidList = new ArrayList<Attribute>(1);
        Attribute uuidAttr = new Attribute(this.entryUUIDType, "entryUUID", values);
        uuidList.add(uuidAttr);
        addOperation.setAttribute(this.entryUUIDType, uuidList);
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        EntryUUIDPluginCfg cfg = (EntryUUIDPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(EntryUUIDPluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case LDIFIMPORT: 
                case PREOPERATIONADD: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_ENTRYUUID_INVALID_PLUGIN_TYPE.get(pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(EntryUUIDPluginCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

