/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.VirtualStaticGroupImplementationCfg;
import org.opends.server.api.Group;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.MemberList;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualStaticGroup
extends Group<VirtualStaticGroupImplementationCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN groupEntryDN;
    private DN targetGroupDN;

    public VirtualStaticGroup() {
    }

    public VirtualStaticGroup(DN groupEntryDN, DN targetGroupDN) {
        Validator.ensureNotNull(groupEntryDN, targetGroupDN);
        this.groupEntryDN = groupEntryDN;
        this.targetGroupDN = targetGroupDN;
    }

    @Override
    public void initializeGroupImplementation(VirtualStaticGroupImplementationCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public VirtualStaticGroup newInstance(Entry groupEntry) throws DirectoryException {
        Validator.ensureNotNull(groupEntry);
        DN targetDN = null;
        AttributeType targetType = DirectoryServer.getAttributeType("ds-target-group-dn", true);
        List<Attribute> attrList = groupEntry.getAttribute(targetType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a.getValues()) {
                    if (targetDN != null) {
                        Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_MULTIPLE_TARGETS.get(String.valueOf(groupEntry.getDN()));
                        throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
                    }
                    try {
                        targetDN = DN.decode(v.getValue());
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_CANNOT_DECODE_TARGET.get(v.getStringValue(), String.valueOf(groupEntry.getDN()), de.getMessageObject());
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, de);
                    }
                }
            }
        }
        if (targetDN == null) {
            Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_NO_TARGET.get(String.valueOf(groupEntry.getDN()));
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
        }
        return new VirtualStaticGroup(groupEntry.getDN(), targetDN);
    }

    @Override
    public SearchFilter getGroupDefinitionFilter() throws DirectoryException {
        return SearchFilter.createFilterFromString("(objectClass=ds-virtual-static-group)");
    }

    @Override
    public boolean isGroupDefinition(Entry entry) {
        Validator.ensureNotNull(entry);
        ObjectClass virtualStaticGroupClass = DirectoryServer.getObjectClass("ds-virtual-static-group", true);
        return entry.hasObjectClass(virtualStaticGroupClass);
    }

    @Override
    public DN getGroupDN() {
        return this.groupEntryDN;
    }

    public DN getTargetGroupDN() {
        return this.targetGroupDN;
    }

    @Override
    public boolean supportsNestedGroups() {
        return false;
    }

    @Override
    public List<DN> getNestedGroupDNs() {
        return Collections.emptyList();
    }

    @Override
    public void addNestedGroup(DN nestedGroupDN) throws UnsupportedOperationException, DirectoryException {
        Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_NESTING_NOT_SUPPORTED.get();
        throw new UnsupportedOperationException(message.toString());
    }

    @Override
    public void removeNestedGroup(DN nestedGroupDN) throws UnsupportedOperationException, DirectoryException {
        Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_NESTING_NOT_SUPPORTED.get();
        throw new UnsupportedOperationException(message.toString());
    }

    @Override
    public boolean isMember(DN userDN, Set<DN> examinedGroups) throws DirectoryException {
        if (!examinedGroups.add(this.getGroupDN())) {
            return false;
        }
        Group targetGroup = DirectoryServer.getGroupManager().getGroupInstance(this.targetGroupDN);
        if (targetGroup == null) {
            Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_NO_TARGET_GROUP.get(String.valueOf(this.targetGroupDN), String.valueOf(this.groupEntryDN));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (targetGroup instanceof VirtualStaticGroup) {
            Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_TARGET_CANNOT_BE_VIRTUAL.get(String.valueOf(this.groupEntryDN), String.valueOf(this.targetGroupDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        return targetGroup.isMember(userDN);
    }

    @Override
    public boolean isMember(Entry userEntry, Set<DN> examinedGroups) throws DirectoryException {
        if (!examinedGroups.add(this.getGroupDN())) {
            return false;
        }
        Group targetGroup = DirectoryServer.getGroupManager().getGroupInstance(this.targetGroupDN);
        if (targetGroup == null) {
            Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_NO_TARGET_GROUP.get(String.valueOf(this.targetGroupDN), String.valueOf(this.groupEntryDN));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (targetGroup instanceof VirtualStaticGroup) {
            Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_TARGET_CANNOT_BE_VIRTUAL.get(String.valueOf(this.groupEntryDN), String.valueOf(this.targetGroupDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        return targetGroup.isMember(userEntry);
    }

    @Override
    public MemberList getMembers() throws DirectoryException {
        Group targetGroup = DirectoryServer.getGroupManager().getGroupInstance(this.targetGroupDN);
        if (targetGroup == null) {
            Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_NO_TARGET_GROUP.get(String.valueOf(this.targetGroupDN), String.valueOf(this.groupEntryDN));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (targetGroup instanceof VirtualStaticGroup) {
            Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_TARGET_CANNOT_BE_VIRTUAL.get(String.valueOf(this.groupEntryDN), String.valueOf(this.targetGroupDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        return targetGroup.getMembers();
    }

    @Override
    public MemberList getMembers(DN baseDN, SearchScope scope, SearchFilter filter) throws DirectoryException {
        Group targetGroup = DirectoryServer.getGroupManager().getGroupInstance(this.targetGroupDN);
        if (targetGroup == null) {
            Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_NO_TARGET_GROUP.get(String.valueOf(this.targetGroupDN), String.valueOf(this.groupEntryDN));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (targetGroup instanceof VirtualStaticGroup) {
            Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_TARGET_CANNOT_BE_VIRTUAL.get(String.valueOf(this.groupEntryDN), String.valueOf(this.targetGroupDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        return targetGroup.getMembers(baseDN, scope, filter);
    }

    @Override
    public boolean mayAlterMemberList() {
        return false;
    }

    @Override
    public void addMember(Entry userEntry) throws UnsupportedOperationException, DirectoryException {
        Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_ALTERING_MEMBERS_NOT_SUPPORTED.get(String.valueOf(this.groupEntryDN));
        throw new UnsupportedOperationException(message.toString());
    }

    @Override
    public void removeMember(DN userDN) throws UnsupportedOperationException, DirectoryException {
        Message message = ExtensionMessages.ERR_VIRTUAL_STATIC_GROUP_ALTERING_MEMBERS_NOT_SUPPORTED.get(String.valueOf(this.groupEntryDN));
        throw new UnsupportedOperationException(message.toString());
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("VirtualStaticGroup(dn=");
        buffer.append(this.groupEntryDN);
        buffer.append(",targetGroupDN=");
        buffer.append(this.targetGroupDN);
        buffer.append(")");
    }
}

