/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.GSSAPISASLMechanismHandler;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSSAPIStateInfo
implements PrivilegedExceptionAction<Boolean>,
CallbackHandler {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private BindOperation bindOperation;
    private ClientConnection clientConnection;
    private Entry userEntry;
    private GSSAPISASLMechanismHandler gssapiHandler;
    private LoginContext loginContext;
    private SaslServer saslServer;
    private String protocol;
    private String serverFQDN;

    public GSSAPIStateInfo(GSSAPISASLMechanismHandler gssapiHandler, BindOperation bindOperation, String serverFQDN) throws InitializationException {
        this.gssapiHandler = gssapiHandler;
        this.bindOperation = bindOperation;
        this.serverFQDN = serverFQDN;
        this.clientConnection = bindOperation.getClientConnection();
        this.protocol = StaticUtils.toLowerCase(this.clientConnection.getProtocol());
        this.userEntry = null;
        try {
            this.loginContext = new LoginContext(GSSAPISASLMechanismHandler.class.getName(), this);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_CREATE_LOGIN_CONTEXT.get(StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        try {
            this.loginContext.login();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_AUTHENTICATE_SERVER.get(StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.saslServer = null;
    }

    public void setBindOperation(BindOperation bindOperation) {
        this.bindOperation = bindOperation;
    }

    public Entry getUserEntry() {
        return this.userEntry;
    }

    public void dispose() {
        block2: {
            try {
                this.saslServer.dispose();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public void processAuthenticationStage() {
        block2: {
            try {
                Subject.doAs(this.loginContext.getSubject(), this);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public Boolean run() {
        block27: {
            ASN1OctetString serverSASLCredentials;
            ASN1OctetString clientCredentials;
            if (this.saslServer == null) {
                try {
                    HashMap<String, String> saslProperties = new HashMap<String, String>();
                    saslProperties.put("javax.security.sasl.qop", "auth");
                    saslProperties.put("javax.security.sasl.reuse", "false");
                    this.saslServer = Sasl.createSaslServer("GSSAPI", this.protocol, this.serverFQDN, saslProperties, this);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_CREATE_SASL_SERVER.get(StaticUtils.getExceptionMessage(e));
                    this.clientConnection.setSASLAuthStateInfo(null);
                    this.bindOperation.setAuthFailureReason(message);
                    this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    return false;
                }
            }
            byte[] clientCredBytes = (clientCredentials = this.bindOperation.getSASLCredentials()) == null ? new byte[]{} : clientCredentials.value();
            try {
                byte[] serverCredBytes = this.saslServer.evaluateResponse(clientCredBytes);
                serverSASLCredentials = serverCredBytes == null ? null : new ASN1OctetString(serverCredBytes);
            }
            catch (Exception e) {
                block23: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    try {
                        this.saslServer.dispose();
                    }
                    catch (Exception e2) {
                        if (!DebugLogger.debugEnabled()) break block23;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                }
                Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_EVALUATE_RESPONSE.get(StaticUtils.getExceptionMessage(e));
                this.clientConnection.setSASLAuthStateInfo(null);
                this.bindOperation.setAuthFailureReason(message);
                this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                return false;
            }
            if (!this.saslServer.isComplete()) {
                this.clientConnection.setSASLAuthStateInfo(this.saslServer);
                this.bindOperation.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
                this.bindOperation.setServerSASLCredentials(serverSASLCredentials);
                return true;
            }
            String authzID = this.saslServer.getAuthorizationID();
            if (authzID == null || authzID.length() == 0) {
                block24: {
                    try {
                        this.saslServer.dispose();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block24;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                Message message = ExtensionMessages.ERR_SASLGSSAPI_NO_AUTHZ_ID.get();
                this.clientConnection.setSASLAuthStateInfo(null);
                this.bindOperation.setAuthFailureReason(message);
                this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                return false;
            }
            try {
                this.userEntry = this.gssapiHandler.getUserForAuthzID(this.bindOperation, authzID);
            }
            catch (DirectoryException de) {
                block25: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    try {
                        this.saslServer.dispose();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block25;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                this.bindOperation.setAuthFailureReason(de.getMessageObject());
                this.clientConnection.setSASLAuthStateInfo(null);
                return false;
            }
            if (this.userEntry == null) {
                block26: {
                    try {
                        this.saslServer.dispose();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block26;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_MAP_AUTHZID.get(authzID);
                this.clientConnection.setSASLAuthStateInfo(null);
                this.bindOperation.setAuthFailureReason(message);
                this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                return false;
            }
            this.bindOperation.setSASLAuthUserEntry(this.userEntry);
            AuthenticationInfo authInfo = new AuthenticationInfo(this.userEntry, "GSSAPI", DirectoryServer.isRootDN(this.userEntry.getDN()));
            this.bindOperation.setAuthenticationInfo(authInfo);
            this.bindOperation.setResultCode(ResultCode.SUCCESS);
            this.clientConnection.setSASLAuthStateInfo(null);
            try {
                this.saslServer.dispose();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block27;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return true;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                String authID = StaticUtils.toLowerCase(this.clientConnection.getProtocol()) + "/" + this.serverFQDN;
                ((NameCallback)callback).setName(authID);
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                String authzID;
                AuthorizeCallback authzCallback = (AuthorizeCallback)callback;
                String authID = authzCallback.getAuthenticationID();
                if (authID.equals(authzID = authzCallback.getAuthorizationID())) {
                    authzCallback.setAuthorizedID(authzID);
                    authzCallback.setAuthorized(true);
                    continue;
                }
                Message message = ExtensionMessages.ERR_SASLGSSAPI_DIFFERENT_AUTHID_AND_AUTHZID.get(authID, authzID);
                this.bindOperation.setAuthFailureReason(message);
                authzCallback.setAuthorized(false);
                continue;
            }
            Message message = ExtensionMessages.INFO_SASLGSSAPI_UNEXPECTED_CALLBACK.get(String.valueOf(callback));
            throw new UnsupportedCallbackException(callback, message.toString());
        }
    }
}

