/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.NetworkGroupCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.NetworkGroup;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkGroupConfigManager
implements ConfigurationChangeListener<NetworkGroupCfg>,
ConfigurationAddListener<NetworkGroupCfg>,
ConfigurationDeleteListener<NetworkGroupCfg> {
    private ConcurrentHashMap<DN, NetworkGroup> networkGroups = new ConcurrentHashMap();

    public void initializeNetworkGroups() throws ConfigException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addNetworkGroupAddListener(this);
        rootConfiguration.addNetworkGroupDeleteListener(this);
        for (String networkGroupName : rootConfiguration.listNetworkGroups()) {
            NetworkGroupCfg networkGroupConfiguration = rootConfiguration.getNetworkGroup(networkGroupName);
            networkGroupConfiguration.addChangeListener(this);
            if (!networkGroupConfiguration.isEnabled()) continue;
            try {
                this.createAndRegisterNetworkGroup(networkGroupConfiguration);
            }
            catch (DirectoryException de) {
                throw new ConfigException(de.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(NetworkGroupCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            try {
                this.createAndRegisterNetworkGroup(configuration);
            }
            catch (DirectoryException de) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                messages.add(de.getMessageObject());
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(NetworkGroupCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        NetworkGroup networkGroup = this.networkGroups.remove(configuration.dn());
        if (networkGroup != null) {
            networkGroup.deregister();
            networkGroup.finalizeNetworkGroup();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(NetworkGroupCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        NetworkGroup existingNetworkGroup = this.networkGroups.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingNetworkGroup != null) {
                this.networkGroups.remove(configuration.dn());
                existingNetworkGroup.deregister();
                existingNetworkGroup.finalizeNetworkGroup();
            }
            return configChangeResult;
        }
        if (existingNetworkGroup == null) {
            try {
                this.createAndRegisterNetworkGroup(configuration);
            }
            catch (DirectoryException de) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                messages.add(de.getMessageObject());
            }
        }
        return configChangeResult;
    }

    private void createAndRegisterNetworkGroup(NetworkGroupCfg networkGroupCfg) throws DirectoryException {
        String networkGroupId = networkGroupCfg.getNetworkGroupId();
        NetworkGroup networkGroup = new NetworkGroup(networkGroupId);
        for (String workflowID : networkGroupCfg.getWorkflow()) {
            WorkflowImpl workflowImpl = (WorkflowImpl)WorkflowImpl.getWorkflow(workflowID);
            networkGroup.registerWorkflow(workflowImpl);
        }
        this.networkGroups.put(networkGroupCfg.dn(), networkGroup);
        networkGroup.register();
    }
}

