/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;
import org.opends.server.admin.std.server.DebugLogPublisherCfg;
import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.admin.std.server.LogPublisherCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerConfigManager
implements ConfigurationAddListener<LogPublisherCfg>,
ConfigurationDeleteListener<LogPublisherCfg> {
    public void initializeLoggerConfig() throws ConfigException, InitializationException {
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        root.addLogPublisherAddListener(this);
        root.addLogPublisherDeleteListener(this);
        ArrayList<DebugLogPublisherCfg> debugPublisherCfgs = new ArrayList<DebugLogPublisherCfg>();
        ArrayList<AccessLogPublisherCfg> accessPublisherCfgs = new ArrayList<AccessLogPublisherCfg>();
        ArrayList<ErrorLogPublisherCfg> errorPublisherCfgs = new ArrayList<ErrorLogPublisherCfg>();
        for (String name : root.listLogPublishers()) {
            LogPublisherCfg config = root.getLogPublisher(name);
            if (config instanceof DebugLogPublisherCfg) {
                debugPublisherCfgs.add((DebugLogPublisherCfg)config);
                continue;
            }
            if (config instanceof AccessLogPublisherCfg) {
                accessPublisherCfgs.add((AccessLogPublisherCfg)config);
                continue;
            }
            if (config instanceof ErrorLogPublisherCfg) {
                errorPublisherCfgs.add((ErrorLogPublisherCfg)config);
                continue;
            }
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_OBJECTCLASS.get(String.valueOf(config.dn()));
            throw new ConfigException(message);
        }
        if (accessPublisherCfgs.isEmpty()) {
            ErrorLogger.logError(ConfigMessages.WARN_CONFIG_LOGGER_NO_ACTIVE_ACCESS_LOGGERS.get());
        }
        if (errorPublisherCfgs.isEmpty()) {
            ErrorLogger.logError(ConfigMessages.WARN_CONFIG_LOGGER_NO_ACTIVE_ERROR_LOGGERS.get());
        }
        DebugLogger.getInstance().initializeDebugLogger(debugPublisherCfgs);
        AccessLogger.getInstance().initializeAccessLogger(accessPublisherCfgs);
        ErrorLogger.getInstance().initializeErrorLogger(errorPublisherCfgs);
    }

    @Override
    public boolean isConfigurationAddAcceptable(LogPublisherCfg config, List<Message> unacceptableReasons) {
        if (config instanceof DebugLogPublisherCfg) {
            return DebugLogger.getInstance().isConfigurationAddAcceptable((DebugLogPublisherCfg)config, unacceptableReasons);
        }
        if (config instanceof AccessLogPublisherCfg) {
            return AccessLogger.getInstance().isConfigurationAddAcceptable((AccessLogPublisherCfg)config, unacceptableReasons);
        }
        if (config instanceof ErrorLogPublisherCfg) {
            return ErrorLogger.getInstance().isConfigurationAddAcceptable((ErrorLogPublisherCfg)config, unacceptableReasons);
        }
        unacceptableReasons.add(ConfigMessages.ERR_CONFIG_LOGGER_INVALID_OBJECTCLASS.get(String.valueOf(config.dn())));
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(LogPublisherCfg config) {
        if (config instanceof DebugLogPublisherCfg) {
            return DebugLogger.getInstance().applyConfigurationAdd((DebugLogPublisherCfg)config);
        }
        if (config instanceof AccessLogPublisherCfg) {
            return AccessLogger.getInstance().applyConfigurationAdd((AccessLogPublisherCfg)config);
        }
        if (config instanceof ErrorLogPublisherCfg) {
            return ErrorLogger.getInstance().applyConfigurationAdd((ErrorLogPublisherCfg)config);
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(ConfigMessages.ERR_CONFIG_LOGGER_INVALID_OBJECTCLASS.get(String.valueOf(config.dn())));
        boolean adminActionRequired = false;
        ResultCode resultCode = ResultCode.UNWILLING_TO_PERFORM;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(LogPublisherCfg config, List<Message> unacceptableReasons) {
        if (config instanceof DebugLogPublisherCfg) {
            return DebugLogger.getInstance().isConfigurationDeleteAcceptable((DebugLogPublisherCfg)config, unacceptableReasons);
        }
        if (config instanceof AccessLogPublisherCfg) {
            return AccessLogger.getInstance().isConfigurationDeleteAcceptable((AccessLogPublisherCfg)config, unacceptableReasons);
        }
        if (config instanceof ErrorLogPublisherCfg) {
            return ErrorLogger.getInstance().isConfigurationDeleteAcceptable((ErrorLogPublisherCfg)config, unacceptableReasons);
        }
        unacceptableReasons.add(ConfigMessages.ERR_CONFIG_LOGGER_INVALID_OBJECTCLASS.get(String.valueOf(config.dn())));
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(LogPublisherCfg config) {
        if (config instanceof DebugLogPublisherCfg) {
            return DebugLogger.getInstance().applyConfigurationDelete((DebugLogPublisherCfg)config);
        }
        if (config instanceof AccessLogPublisherCfg) {
            return AccessLogger.getInstance().applyConfigurationDelete((AccessLogPublisherCfg)config);
        }
        if (config instanceof ErrorLogPublisherCfg) {
            return ErrorLogger.getInstance().applyConfigurationDelete((ErrorLogPublisherCfg)config);
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(ConfigMessages.ERR_CONFIG_LOGGER_INVALID_OBJECTCLASS.get(String.valueOf(config.dn())));
        boolean adminActionRequired = false;
        ResultCode resultCode = ResultCode.UNWILLING_TO_PERFORM;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

