/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.Control;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

public class ServerSideSortResponseControl
extends Control {
    private static final byte TYPE_ATTRIBUTE_TYPE = -128;
    private int resultCode;
    private String attributeType;

    public ServerSideSortResponseControl(int resultCode, String attributeType) {
        super("1.2.840.113556.1.4.474", false, ServerSideSortResponseControl.encodeControlValue(resultCode, attributeType));
        this.resultCode = resultCode;
        this.attributeType = attributeType;
    }

    private ServerSideSortResponseControl(String oid, boolean isCritical, ASN1OctetString controlValue, int resultCode, String attributeType) {
        super(oid, isCritical, controlValue);
        this.resultCode = resultCode;
        this.attributeType = attributeType;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    private static ASN1OctetString encodeControlValue(int resultCode, String attributeType) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1Enumerated(resultCode));
        if (attributeType != null) {
            elements.add(new ASN1OctetString(-128, attributeType));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public static ServerSideSortResponseControl decodeControl(Control control) throws LDAPException {
        ASN1OctetString controlValue = control.getValue();
        if (controlValue == null) {
            Message message = ProtocolMessages.INFO_SORTRES_CONTROL_NO_VALUE.get();
            throw new LDAPException(2, message);
        }
        try {
            ArrayList<ASN1Element> elements = ASN1Sequence.decodeAsSequence(control.getValue().value()).elements();
            int resultCode = elements.get(0).decodeAsEnumerated().intValue();
            String attributeType = null;
            if (elements.size() > 1) {
                attributeType = elements.get(1).decodeAsOctetString().stringValue();
            }
            return new ServerSideSortResponseControl(control.getOID(), control.isCritical(), control.getValue(), resultCode, attributeType);
        }
        catch (Exception e) {
            Message message = ProtocolMessages.INFO_SORTRES_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, message, e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ServerSideSortResponseControl(resultCode=");
        buffer.append(this.resultCode);
        if (this.attributeType != null) {
            buffer.append(", attributeType=");
            buffer.append(this.attributeType);
        }
        buffer.append(")");
    }
}

