/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Control;
import org.opends.server.types.LDAPException;

public class PasswordExpiredControl
extends Control {
    public PasswordExpiredControl() {
        super("2.16.840.1.113730.3.4.4", false, new ASN1OctetString("0"));
    }

    public PasswordExpiredControl(String oid, boolean isCritical) {
        super(oid, isCritical, new ASN1OctetString("0"));
    }

    public static PasswordExpiredControl decodeControl(Control control) throws LDAPException {
        if (control.hasValue()) {
            String valueStr = control.getValue().stringValue();
            try {
                Integer.parseInt(valueStr);
            }
            catch (Exception e) {
                Message message = ProtocolMessages.ERR_PWEXPIRED_CONTROL_INVALID_VALUE.get();
                throw new LDAPException(2, message);
            }
        }
        return new PasswordExpiredControl(control.getOID(), control.isCritical());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("PasswordExpiredControl()");
    }
}

