/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.MemoryBudget;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.importLDIF.ImportIDSet;
import org.opends.server.backends.jeb.importLDIF.IntegerImportIDSet;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.Entry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferManager {
    private long memoryUsage = 0L;
    private long memoryLimit;
    private KeyHashElement nextElem;
    private final int extraBytes = 0x100000;
    private long total = 0L;
    private long hit = 0L;
    private TreeMap<KeyHashElement, KeyHashElement> elementMap = new TreeMap();
    private int currentMap = 1;
    private TreeMap<KeyHashElement, KeyHashElement> backupMap;
    private TreeMap<KeyHashElement, KeyHashElement> backupMap2 = new TreeMap();
    private TreeMap<KeyHashElement, KeyHashElement> backupMap1 = new TreeMap();
    private static final int TREEMAP_ENTRY_OVERHEAD = 29;
    private static final int KEY_ELEMENT_OVERHEAD = 32;
    private ReentrantLock lock = new ReentrantLock();
    private final Object backupSynchObj = new Object();

    public BufferManager(long memoryLimit) {
        this.memoryLimit = memoryLimit;
        this.nextElem = null;
        this.backupMap = this.backupMap1;
    }

    void insert(Index index, Entry entry, EntryID entryID, Set<byte[]> keySet) throws DatabaseException {
        keySet.clear();
        index.indexer.indexEntry(entry, keySet);
        if (!this.lock.tryLock()) {
            this.insertBackupMap(keySet, index, entryID);
            return;
        }
        this.insertKeySet(keySet, index, entryID, this.elementMap, true);
        if (!this.backupMap.isEmpty()) {
            this.mergeMap();
        }
        if (this.memoryUsage > this.memoryLimit) {
            this.flushUntilUnderLimit();
        }
        this.lock.unlock();
    }

    void insert(Index id2children, Index id2subtree, Entry entry, EntryID entryID, Set<byte[]> childKeySet, Set<byte[]> subKeySet) throws DatabaseException {
        childKeySet.clear();
        id2children.indexer.indexEntry(entry, childKeySet);
        subKeySet.clear();
        id2subtree.indexer.indexEntry(entry, subKeySet);
        if (!this.lock.tryLock()) {
            this.insertBackupMap(childKeySet, id2children, subKeySet, id2subtree, entryID);
            return;
        }
        this.insertKeySet(childKeySet, id2children, entryID, this.elementMap, true);
        this.insertKeySet(subKeySet, id2subtree, entryID, this.elementMap, true);
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertBackupMap(Set<byte[]> childrenKeySet, Index id2children, Set<byte[]> subtreeKeySet, Index id2subtree, EntryID entryID) {
        Object object = this.backupSynchObj;
        synchronized (object) {
            this.insertKeySet(childrenKeySet, id2children, entryID, this.backupMap, false);
            this.insertKeySet(subtreeKeySet, id2subtree, entryID, this.backupMap, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertBackupMap(Set<byte[]> keySet, Index index, EntryID entryID) {
        Object object = this.backupSynchObj;
        synchronized (object) {
            this.insertKeySet(keySet, index, entryID, this.backupMap, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeMap() {
        TreeMap<KeyHashElement, KeyHashElement> tmpMap;
        Object object = this.backupSynchObj;
        synchronized (object) {
            if (this.currentMap == 1) {
                this.backupMap = this.backupMap2;
                tmpMap = this.backupMap1;
                this.currentMap = 2;
            } else {
                this.backupMap = this.backupMap1;
                tmpMap = this.backupMap2;
                this.currentMap = 1;
            }
        }
        TreeSet<KeyHashElement> tSet = new TreeSet<KeyHashElement>(tmpMap.keySet());
        for (KeyHashElement elem : tSet) {
            ++this.total;
            if (!this.elementMap.containsKey(elem)) {
                this.elementMap.put(elem, elem);
                this.memoryUsage += (long)(29 + elem.getMemorySize());
                continue;
            }
            KeyHashElement curElem = this.elementMap.get(elem);
            if (!curElem.isDefined() && !curElem.getIndex().getMaintainCount()) continue;
            int oldSize = curElem.getMemorySize();
            curElem.merge(elem);
            this.memoryUsage += (long)(curElem.getMemorySize() - oldSize);
            ++this.hit;
        }
        tmpMap.clear();
    }

    private void insertKeySet(Set<byte[]> keySet, Index index, EntryID entryID, TreeMap<KeyHashElement, KeyHashElement> map, boolean trackStats) {
        KeyHashElement elem = new KeyHashElement();
        int entryLimit = index.getIndexEntryLimit();
        for (byte[] key : keySet) {
            elem.reset(key, index);
            if (trackStats) {
                ++this.total;
            }
            if (!map.containsKey(elem)) {
                KeyHashElement newElem = new KeyHashElement(key, index, entryID);
                map.put(newElem, newElem);
                if (!trackStats) continue;
                this.memoryUsage += (long)(29 + newElem.getMemorySize());
                continue;
            }
            KeyHashElement curElem = map.get(elem);
            if (!curElem.isDefined() && !index.getMaintainCount()) continue;
            int oldSize = curElem.getMemorySize();
            curElem.addEntryID(entryID, entryLimit);
            if (!trackStats) continue;
            this.memoryUsage += (long)(curElem.getMemorySize() - oldSize);
            ++this.hit;
        }
    }

    private void flushUntilUnderLimit() throws DatabaseException {
        Iterator<KeyHashElement> iter = this.nextElem == null ? this.elementMap.keySet().iterator() : this.elementMap.tailMap(this.nextElem).keySet().iterator();
        DatabaseEntry dbEntry = new DatabaseEntry();
        DatabaseEntry entry = new DatabaseEntry();
        while (this.memoryUsage + 0x100000L > this.memoryLimit) {
            if (iter.hasNext()) {
                KeyHashElement curElem = iter.next();
                if (!curElem.isDefined()) continue;
                int oldSize = curElem.getMemorySize();
                Index index = curElem.getIndex();
                dbEntry.setData(curElem.getKey());
                index.insert(dbEntry, curElem.getIDSet(), entry);
                if (curElem.isDefined()) {
                    this.memoryUsage -= (long)(29 + curElem.getMemorySize());
                    iter.remove();
                    continue;
                }
                this.memoryUsage -= (long)(oldSize - curElem.getMemorySize());
                continue;
            }
            this.nextElem = this.elementMap.firstKey();
            iter = this.elementMap.keySet().iterator();
        }
        this.nextElem = iter.next();
    }

    void prepareFlush() {
        Message msg = JebMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_FLUSH.get(this.elementMap.size(), this.total, this.hit);
        ErrorLogger.logError(msg);
    }

    void flushAll() throws DatabaseException {
        this.mergeMap();
        TreeSet<KeyHashElement> tSet = new TreeSet<KeyHashElement>(this.elementMap.keySet());
        DatabaseEntry dbEntry = new DatabaseEntry();
        DatabaseEntry entry = new DatabaseEntry();
        for (KeyHashElement curElem : tSet) {
            if (!curElem.isDirty()) continue;
            Index index = curElem.getIndex();
            dbEntry.setData(curElem.getKey());
            index.insert(dbEntry, curElem.getIDSet(), entry);
        }
    }

    class KeyHashElement
    implements Comparable {
        private byte[] key;
        private int indexHashCode;
        private Index index;
        private ImportIDSet importIDSet;
        private int keyHashCode;

        public KeyHashElement() {
        }

        public void reset(byte[] key, Index index) {
            this.key = key;
            this.index = index;
            this.indexHashCode = System.identityHashCode(index);
            this.keyHashCode = Arrays.hashCode(key);
            if (this.importIDSet != null) {
                this.importIDSet.reset();
            }
        }

        public KeyHashElement(byte[] key, Index index, EntryID entryID) {
            this.key = key;
            this.index = index;
            this.importIDSet = new IntegerImportIDSet(entryID);
            this.indexHashCode = System.identityHashCode(index);
            this.keyHashCode = Arrays.hashCode(key);
        }

        void addEntryID(EntryID entryID, int entryLimit) {
            this.importIDSet.addEntryID(entryID, entryLimit, this.index.getMaintainCount());
        }

        Index getIndex() {
            return this.index;
        }

        byte[] getKey() {
            return this.key;
        }

        int getKeyHashCode() {
            return this.keyHashCode;
        }

        ImportIDSet getIDSet() {
            return this.importIDSet;
        }

        boolean isDefined() {
            return this.importIDSet.isDefined();
        }

        private int compare(byte[] a, byte[] b) {
            for (int i = 0; i < a.length && i < b.length; ++i) {
                if (a[i] > b[i]) {
                    return 1;
                }
                if (a[i] >= b[i]) continue;
                return -1;
            }
            if (a.length == b.length) {
                return 0;
            }
            if (a.length > b.length) {
                return 1;
            }
            return -1;
        }

        private int compare(KeyHashElement elem) {
            if (this.keyHashCode == elem.getKeyHashCode()) {
                return this.compare(this.key, elem.key);
            }
            if (this.keyHashCode < elem.getKeyHashCode()) {
                return -1;
            }
            return 1;
        }

        public int compareTo(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            KeyHashElement inElem = (KeyHashElement)o;
            int keyCompare = this.compare(inElem);
            if (keyCompare == 0) {
                if (this.indexHashCode == inElem.indexHashCode) {
                    return 0;
                }
                if (this.indexHashCode < inElem.indexHashCode) {
                    return -1;
                }
                return 1;
            }
            return keyCompare;
        }

        int getMemorySize() {
            return 32 + MemoryBudget.byteArraySize((int)this.key.length) + this.importIDSet.getMemorySize();
        }

        public void merge(KeyHashElement e) {
            this.importIDSet.merge(e.importIDSet, e.getIndex().getIndexEntryLimit(), e.getIndex().getMaintainCount());
        }

        public boolean isDirty() {
            return this.importIDSet.isDirty();
        }
    }
}

