/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebuildConfig {
    private DN baseDN;
    private ArrayList<String> rebuildList = new ArrayList();
    private int maxRebuildThreads = -1;

    public DN getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(DN baseDN) {
        this.baseDN = baseDN;
    }

    public ArrayList<String> getRebuildList() {
        return this.rebuildList;
    }

    public void addRebuildIndex(String index) {
        String[] newIndexParts = index.split("\\.");
        for (String s : new ArrayList<String>(this.rebuildList)) {
            String[] existingIndexParts = s.split("\\.");
            if (!existingIndexParts[0].equalsIgnoreCase(newIndexParts[0])) continue;
            if (newIndexParts.length == 1 && existingIndexParts.length == 1) {
                return;
            }
            if (newIndexParts.length > 1 && existingIndexParts.length == 1) {
                return;
            }
            if (newIndexParts.length == 1 && existingIndexParts.length > 1) {
                this.rebuildList.remove(s);
                continue;
            }
            if (!newIndexParts[1].equalsIgnoreCase(existingIndexParts[1])) continue;
            return;
        }
        this.rebuildList.add(index);
    }

    public String checkConflicts(RebuildConfig config) {
        if (this.baseDN.equals(config.baseDN)) {
            for (String thisIndex : this.rebuildList) {
                for (String thatIndex : config.rebuildList) {
                    String[] newIndexParts;
                    String[] existingIndexParts = thisIndex.split("\\.");
                    if (!existingIndexParts[0].equalsIgnoreCase((newIndexParts = thatIndex.split("\\."))[0])) continue;
                    if (newIndexParts.length == 1 && existingIndexParts.length == 1) {
                        return thatIndex;
                    }
                    if (newIndexParts.length > 1 && existingIndexParts.length == 1) {
                        return thatIndex;
                    }
                    if (newIndexParts.length == 1 && existingIndexParts.length > 1) {
                        return thatIndex;
                    }
                    if (!newIndexParts[1].equalsIgnoreCase(existingIndexParts[1])) continue;
                    return thatIndex;
                }
            }
        }
        return null;
    }

    public int getMaxRebuildThreads() {
        return this.maxRebuildThreads;
    }

    public void setMaxRebuildThreads(int maxRebuildThreads) {
        this.maxRebuildThreads = maxRebuildThreads;
    }

    public boolean includesSystemIndex() {
        for (String index : this.rebuildList) {
            if (index.equalsIgnoreCase("id2entry")) {
                return true;
            }
            if (index.equalsIgnoreCase("dn2id")) {
                return true;
            }
            if (index.equalsIgnoreCase("dn2uri")) {
                return true;
            }
            if (index.equalsIgnoreCase("id2children")) {
                return true;
            }
            if (!index.equalsIgnoreCase("id2subtree")) continue;
            return true;
        }
        return false;
    }
}

