/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;

public class ID2Entry
extends DatabaseContainer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DataConfig dataConfig;

    ID2Entry(String name, DataConfig dataConfig, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.dataConfig = dataConfig;
        DatabaseConfig dbNodupsConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dbNodupsConfig.setReadOnly(true);
            dbNodupsConfig.setAllowCreate(false);
            dbNodupsConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(false);
            dbNodupsConfig.setDeferredWrite(true);
        } else {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(true);
        }
        this.dbConfig = dbNodupsConfig;
    }

    public DatabaseEntry entryData(Entry entry) throws DirectoryException {
        byte[] entryBytes = JebFormat.entryToDatabase(entry, this.dataConfig);
        return new DatabaseEntry(entryBytes);
    }

    public boolean insert(Transaction txn, EntryID id, Entry entry) throws DatabaseException, DirectoryException {
        DatabaseEntry data;
        DatabaseEntry key = id.getDatabaseEntry();
        OperationStatus status = this.insert(txn, key, data = this.entryData(entry));
        return status == OperationStatus.SUCCESS;
    }

    public boolean put(Transaction txn, EntryID id, Entry entry) throws DatabaseException, DirectoryException {
        DatabaseEntry data;
        DatabaseEntry key = id.getDatabaseEntry();
        OperationStatus status = this.put(txn, key, data = this.entryData(entry));
        return status == OperationStatus.SUCCESS;
    }

    public boolean putRaw(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        OperationStatus status = this.put(txn, key, data);
        return status == OperationStatus.SUCCESS;
    }

    public boolean remove(Transaction txn, EntryID id) throws DatabaseException {
        DatabaseEntry key = id.getDatabaseEntry();
        OperationStatus status = this.delete(txn, key);
        return status == OperationStatus.SUCCESS;
    }

    public Entry get(Transaction txn, EntryID id, LockMode lockMode) throws DirectoryException, DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = id.getDatabaseEntry();
        OperationStatus status = this.read(txn, key, data = new DatabaseEntry(), lockMode);
        if (status != OperationStatus.SUCCESS) {
            return null;
        }
        byte[] entryBytes = data.getData();
        byte entryVersion = JebFormat.getEntryVersion(entryBytes);
        Entry entry = null;
        switch (entryVersion) {
            case 1: {
                try {
                    entry = JebFormat.entryFromDatabase(entryBytes, this.entryContainer.getRootContainer().getCompressedSchema());
                    break;
                }
                catch (Exception e) {
                    Message message = JebMessages.ERR_JEB_ENTRY_DATABASE_CORRUPT.get(id.toString());
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
                }
            }
            default: {
                Message message = JebMessages.ERR_JEB_INCOMPATIBLE_ENTRY_VERSION.get(id.toString(), entryVersion);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
        }
        if (entry != null) {
            entry.processVirtualAttributes();
        }
        return entry;
    }

    public void setDataConfig(DataConfig dataConfig) {
        this.dataConfig = dataConfig;
    }
}

