/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.api.Group;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.KeywordBindRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.GroupManager;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDN
implements KeywordBindRule {
    LinkedList<DN> groupDNs = null;
    private EnumBindRuleType type = null;
    public static final String LDAP_URLS = "\\s*(ldap:///[^\\|]+)\\s*(\\|\\|\\s*\\s*(ldap:///[^\\|]+))*";

    private GroupDN(EnumBindRuleType type, LinkedList<DN> groupDNs) {
        this.groupDNs = groupDNs;
        this.type = type;
    }

    public static KeywordBindRule decode(String expr, EnumBindRuleType type) throws AciException {
        if (!Pattern.matches(LDAP_URLS, expr)) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_GROUPDN_EXPRESSION.get(expr);
            throw new AciException(message);
        }
        LinkedList<DN> groupDNs = new LinkedList<DN>();
        int ldapURLPos = 1;
        Pattern ldapURLPattern = Pattern.compile("\\s*(ldap:///[^\\|]+)");
        Matcher ldapURLMatcher = ldapURLPattern.matcher(expr);
        while (ldapURLMatcher.find()) {
            try {
                String value = ldapURLMatcher.group(ldapURLPos).trim();
                DN dn = LDAPURL.decode(value, true).getBaseDN();
                groupDNs.add(dn);
            }
            catch (DirectoryException ex) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_GROUPDN_URL.get(ex.getMessageObject());
                throw new AciException(message);
            }
        }
        return new GroupDN(type, groupDNs);
    }

    @Override
    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        Iterator it = this.groupDNs.iterator();
        while (it.hasNext() && matched != EnumEvalResult.TRUE) {
            DN groupDN = (DN)it.next();
            Group group = GroupDN.getGroupManager().getGroupInstance(groupDN);
            if (group == null || !evalCtx.isMemberOf(group)) continue;
            matched = EnumEvalResult.TRUE;
        }
        return matched.getRet(this.type, false);
    }

    public static EnumEvalResult evaluate(Entry e, AciEvalContext evalCtx, AttributeType attributeType, DN suffixDN) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        List<Attribute> attrs = e.getAttribute(attributeType);
        LinkedHashSet<AttributeValue> vals = attrs.get(0).getValues();
        for (AttributeValue v : vals) {
            try {
                Group group;
                DN groupDN = DN.decode(v.getStringValue());
                if (suffixDN != null && !groupDN.isDescendantOf(suffixDN) || (group = GroupDN.getGroupManager().getGroupInstance(groupDN)) == null || !evalCtx.isMemberOf(group)) continue;
                matched = EnumEvalResult.TRUE;
            }
            catch (DirectoryException ex) {}
            break;
        }
        return matched;
    }

    private static GroupManager getGroupManager() {
        return DirectoryServer.getGroupManager();
    }
}

