/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.condition;

import java.util.Arrays;
import java.util.List;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.condition.Condition;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.config.ConfigException;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ANDCondition
implements Condition {
    private final List<Condition> conditions;

    public ANDCondition(Condition ... conditions) {
        Validator.ensureNotNull(conditions);
        this.conditions = Arrays.asList(conditions);
    }

    @Override
    public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws AuthorizationException, CommunicationException {
        for (Condition condition : this.conditions) {
            if (condition.evaluate(context, managedObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
        for (Condition condition : this.conditions) {
            if (condition.evaluate(managedObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        for (Condition condition : this.conditions) {
            condition.initialize(d);
        }
    }
}

