/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyDefinition<T>
implements Comparator<T>,
Comparable<PropertyDefinition<?>> {
    private final AdministratorAction adminAction;
    private final DefaultBehaviorProvider<T> defaultBehavior;
    private final AbstractManagedObjectDefinition<?, ?> definition;
    private final Set<PropertyOption> options;
    private final String propertyName;
    private final Class<T> theClass;

    protected PropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, Class<T> theClass, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<T> defaultBehavior) {
        Validator.ensureNotNull(d, theClass, propertyName);
        Validator.ensureNotNull(options, adminAction, defaultBehavior);
        this.definition = d;
        this.theClass = theClass;
        this.propertyName = propertyName;
        this.options = EnumSet.copyOf(options);
        this.adminAction = adminAction;
        this.defaultBehavior = defaultBehavior;
    }

    public abstract <R, P> R accept(PropertyDefinitionVisitor<R, P> var1, P var2);

    public abstract <R, P> R accept(PropertyValueVisitor<R, P> var1, T var2, P var3);

    public final T castValue(Object object) throws ClassCastException {
        return this.theClass.cast(object);
    }

    @Override
    public int compare(T o1, T o2) {
        Validator.ensureNotNull(o1, o2);
        String s1 = this.normalizeValue(o1);
        String s2 = this.normalizeValue(o2);
        return s1.compareTo(s2);
    }

    @Override
    public final int compareTo(PropertyDefinition<?> o) {
        int rc = this.propertyName.compareTo(o.propertyName);
        if (rc == 0) {
            rc = this.theClass.getName().compareTo(o.theClass.getName());
        }
        return rc;
    }

    public abstract T decodeValue(String var1) throws IllegalPropertyValueStringException;

    public String encodeValue(T value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        return value.toString();
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PropertyDefinition) {
            PropertyDefinition other = (PropertyDefinition)o;
            return this.propertyName.equals(other.propertyName) && this.theClass.equals(other.theClass);
        }
        return false;
    }

    public final AdministratorAction getAdministratorAction() {
        return this.adminAction;
    }

    public final DefaultBehaviorProvider<T> getDefaultBehaviorProvider() {
        return this.defaultBehavior;
    }

    public final Message getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public final Message getDescription(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.propertyName + ".description";
        try {
            return resource.getMessage(this.definition, property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final AbstractManagedObjectDefinition<?, ?> getManagedObjectDefinition() {
        return this.definition;
    }

    public final String getName() {
        return this.propertyName;
    }

    public final Message getSynopsis() {
        return this.getSynopsis(Locale.getDefault());
    }

    public final Message getSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.propertyName + ".synopsis";
        return resource.getMessage(this.definition, property, locale);
    }

    public final int hashCode() {
        int rc = 17 + this.propertyName.hashCode();
        return 37 * rc + this.theClass.hashCode();
    }

    public final boolean hasOption(PropertyOption option) {
        return this.options.contains((Object)option);
    }

    public String normalizeValue(T value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        return this.encodeValue(value);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        builder.append(this.propertyName);
    }

    public abstract void validateValue(T var1) throws IllegalPropertyValueException;

    protected void initialize() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractBuilder<T, D extends PropertyDefinition<T>> {
        private AdministratorAction adminAction;
        private DefaultBehaviorProvider<T> defaultBehavior;
        private final AbstractManagedObjectDefinition<?, ?> definition;
        private final EnumSet<PropertyOption> options;
        private final String propertyName;

        protected AbstractBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            this.definition = d;
            this.propertyName = propertyName;
            this.options = EnumSet.noneOf(PropertyOption.class);
            this.adminAction = new AdministratorAction(AdministratorAction.Type.NONE, d, propertyName);
            this.defaultBehavior = new UndefinedDefaultBehaviorProvider();
        }

        public final D getInstance() {
            return this.buildInstance(this.definition, this.propertyName, this.options, this.adminAction, this.defaultBehavior);
        }

        public final void setAdministratorAction(AdministratorAction adminAction) {
            Validator.ensureNotNull(adminAction);
            this.adminAction = adminAction;
        }

        public final void setDefaultBehaviorProvider(DefaultBehaviorProvider<T> defaultBehavior) {
            Validator.ensureNotNull(defaultBehavior);
            this.defaultBehavior = defaultBehavior;
        }

        public final void setOption(PropertyOption option) {
            Validator.ensureNotNull((Object)option);
            this.options.add(option);
        }

        protected abstract D buildInstance(AbstractManagedObjectDefinition<?, ?> var1, String var2, EnumSet<PropertyOption> var3, AdministratorAction var4, DefaultBehaviorProvider<T> var5);
    }
}

