/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.EnumSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DNPropertyDefinition
extends PropertyDefinition<DN> {
    private final DN baseDN;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private DNPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<DN> defaultBehavior, DN baseDN) {
        super(d, DN.class, propertyName, options, adminAction, defaultBehavior);
        this.baseDN = baseDN;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    @Override
    public void validateValue(DN value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        if (this.baseDN != null) {
            DN parent = value.getParent();
            if (parent == null) {
                parent = DN.nullDN();
            }
            if (!parent.equals(this.baseDN)) {
                throw new IllegalPropertyValueException(this, value);
            }
        }
    }

    @Override
    public DN decodeValue(String value) throws IllegalPropertyValueStringException {
        Validator.ensureNotNull(value);
        try {
            DN dn = DN.decode(value);
            this.validateValue(dn);
            return dn;
        }
        catch (DirectoryException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
        catch (IllegalPropertyValueException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitDN(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, DN value, P p) {
        return v.visitDN(this, value, p);
    }

    @Override
    public int compare(DN o1, DN o2) {
        return o1.compareTo(o2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends PropertyDefinition.AbstractBuilder<DN, DNPropertyDefinition> {
        private DN baseDN = null;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public void setBaseDN(String baseDN) throws IllegalArgumentException {
            if (baseDN == null) {
                this.setBaseDN((DN)null);
            } else {
                try {
                    this.setBaseDN(DN.decode(baseDN));
                }
                catch (DirectoryException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }

        public void setBaseDN(DN baseDN) {
            this.baseDN = baseDN;
        }

        @Override
        protected DNPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<DN> defaultBehavior) {
            return new DNPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.baseDN);
        }
    }
}

