/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.ReviewPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.upgrader.Upgrader;
import org.opends.quicksetup.util.Utils;

public class UpgraderReviewPanel
extends ReviewPanel {
    private static final Logger LOG = Logger.getLogger(UpgraderReviewPanel.class.getName());
    private static final long serialVersionUID = 5942916658585976799L;
    JLabel tcServerLocation = null;
    JLabel tcOldBuild = null;
    JLabel tcNewBuild = null;
    private JCheckBox checkBox;

    public UpgraderReviewPanel(Upgrader application) {
        super(application);
    }

    public void beginDisplay(UserData data) {
        this.tcServerLocation.setText(this.getServerToUpgrade());
        this.tcOldBuild.setText(this.getOldBuildString());
        this.tcNewBuild.setText(this.getNewBuildString());
    }

    public Object getFieldValue(FieldName fieldName) {
        Boolean value = null;
        if (fieldName == FieldName.SERVER_START_UPGRADER) {
            value = this.getBottomComponent().isSelected();
        }
        return value;
    }

    public boolean blockingBeginDisplay() {
        return true;
    }

    protected Message getTitle() {
        return QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_TITLE.get();
    }

    protected Message getInstructions() {
        return QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_INSTRUCTIONS.get();
    }

    protected JPanel createFieldsPanel() {
        JPanel p = UIFactory.makeJPanel();
        LabelFieldDescriptor serverDescriptor = new LabelFieldDescriptor(QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_SERVER_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_SERVER_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0);
        LabelFieldDescriptor oldVersionDescriptor = new LabelFieldDescriptor(QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_OLD_VERSION_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_OLD_VERSION_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0);
        LabelFieldDescriptor newVersionDescriptor = new LabelFieldDescriptor(QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_NEW_VERSION_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_NEW_VERSION_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0);
        this.tcServerLocation = UIFactory.makeJLabel(serverDescriptor);
        UIFactory.setTextStyle(this.tcServerLocation, UIFactory.TextStyle.READ_ONLY);
        this.tcOldBuild = UIFactory.makeJLabel(oldVersionDescriptor);
        UIFactory.setTextStyle(this.tcOldBuild, UIFactory.TextStyle.READ_ONLY);
        this.tcNewBuild = UIFactory.makeJLabel(newVersionDescriptor);
        UIFactory.setTextStyle(this.tcNewBuild, UIFactory.TextStyle.READ_ONLY);
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        LabelFieldDescriptor[] descs = new LabelFieldDescriptor[]{serverDescriptor, oldVersionDescriptor, newVersionDescriptor};
        JLabel[] labels = new JLabel[]{this.tcServerLocation, this.tcOldBuild, this.tcNewBuild};
        for (int i = 0; i < descs.length; ++i) {
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.insets.top = i > 0 ? 10 : 0;
            gbc.insets.left = 0;
            gbc.anchor = 18;
            p.add((Component)UIFactory.makeJLabel(descs[i]), gbc);
            gbc.insets.left = 10;
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            p.add((Component)labels[i], gbc);
        }
        return p;
    }

    private String getServerToUpgrade() {
        return this.getUserData().getServerLocation();
    }

    private String getOldBuildString() {
        return Utils.getBuildString(this.getApplication().getInstallation());
    }

    private String getNewBuildString() {
        String b = null;
        try {
            BuildInformation bi = BuildInformation.getCurrent();
            if (bi != null) {
                b = bi.toString();
            }
        }
        catch (ApplicationException e) {
            LOG.log(Level.INFO, "error trying to determine new build string", e);
        }
        if (b == null) {
            b = QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
        }
        return b;
    }

    protected JCheckBox getBottomComponent() {
        if (this.checkBox == null) {
            this.checkBox = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_START_SERVER.get(), QuickSetupMessages.INFO_START_SERVER_TOOLTIP.get(), UIFactory.TextStyle.CHECKBOX);
            this.checkBox.setSelected(this.getApplication().getUserData().getStartServer());
        }
        return this.checkBox;
    }
}

