/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.FormView;
import javax.swing.text.html.HTMLEditorKit;

public class CustomHTMLEditorKit
extends HTMLEditorKit {
    private HashSet<ActionListener> listeners = new HashSet();
    private static final long serialVersionUID = 298103926252426388L;
    private static long lastActionWhen = 0L;

    public ViewFactory getViewFactory() {
        return new MyHTMLFactory();
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    class MyFormView
    extends FormView {
        MyFormView(Element elem) {
            super(elem);
        }

        public void actionPerformed(ActionEvent ev) {
            if (ev != null && ev.getWhen() != lastActionWhen) {
                lastActionWhen = ev.getWhen();
                for (ActionListener l : CustomHTMLEditorKit.this.listeners) {
                    l.actionPerformed(ev);
                }
            }
        }
    }

    class MyHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        MyHTMLFactory() {
        }

        public View create(Element elem) {
            View v = super.create(elem);
            if (v instanceof FormView) {
                v = new MyFormView(elem);
            }
            return v;
        }
    }
}

