/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ProgressDescriptor;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.event.ButtonActionListener;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.ProgressPanel;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupPanel;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;

public class CurrentStepPanel
extends QuickSetupPanel {
    private static final long serialVersionUID = 5474803491510999334L;
    private static final String LOADING_PANEL = "loading";
    private HashMap<WizardStep, QuickSetupStepPanel> hmPanels = new HashMap();

    public CurrentStepPanel(GuiApplication app, QuickSetup qs) {
        super(app);
        this.setQuickSetup(qs);
        this.createLayout(app);
    }

    public Object getFieldValue(FieldName fieldName) {
        WizardStep s;
        Object value = null;
        Iterator<WizardStep> i$ = this.hmPanels.keySet().iterator();
        while (i$.hasNext() && (value = this.getPanel(s = i$.next()).getFieldValue(fieldName)) == null) {
        }
        return value;
    }

    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        for (WizardStep s : this.hmPanels.keySet()) {
            this.getPanel(s).displayFieldInvalid(fieldName, invalid);
        }
    }

    ProgressPanel getProgressPanel() {
        return (ProgressPanel)this.hmPanels.get(Step.PROGRESS);
    }

    private void createLayout(GuiApplication app) {
        int n;
        Set<? extends WizardStep> steps = app.getWizardSteps();
        if (steps != null) {
            for (WizardStep wizardStep : steps) {
                QuickSetupStepPanel panel = app.createWizardStepPanel(wizardStep);
                if (panel == null) continue;
                panel.setQuickSetup(this.getQuickSetup());
                panel.initialize();
                this.hmPanels.put(wizardStep, panel);
            }
        }
        int minWidth = 0;
        boolean bl = false;
        this.setLayout(new CardLayout());
        for (WizardStep s : this.hmPanels.keySet()) {
            minWidth = Math.max(minWidth, this.getPanel(s).getMinimumWidth());
            n = Math.max(n, this.getPanel(s).getMinimumHeight());
            this.add((Component)this.getPanel(s), s.toString());
        }
        JPanel loadingPanel = UIFactory.makeJPanel();
        loadingPanel.setLayout(new GridBagLayout());
        loadingPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_GENERAL_LOADING.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), new GridBagConstraints());
        this.add((Component)loadingPanel, LOADING_PANEL);
        int n2 = n + this.getApplication().getExtraDialogHeight();
        this.setPreferredSize(new Dimension(minWidth, n2));
        this.setMinimumSize(new Dimension(minWidth, n2));
    }

    public void addButtonActionListener(ButtonActionListener l) {
        for (WizardStep s : this.hmPanels.keySet()) {
            this.getPanel(s).addButtonActionListener(l);
        }
    }

    public void removeButtonActionListener(ButtonActionListener l) {
        for (WizardStep s : this.hmPanels.keySet()) {
            this.getPanel(s).removeButtonActionListener(l);
        }
    }

    public void setDisplayedStep(final WizardStep step, final UserData userData) {
        final CardLayout cl = (CardLayout)this.getLayout();
        if (this.getPanel(step).blockingBeginDisplay()) {
            cl.show(this, LOADING_PANEL);
            new Thread(new Runnable(){

                public void run() {
                    CurrentStepPanel.this.getPanel(step).beginDisplay(userData);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            cl.show(CurrentStepPanel.this, step.toString());
                            CurrentStepPanel.this.getPanel(step).endDisplay();
                        }
                    });
                }
            }, "panel begin display thread").start();
        } else {
            this.getPanel(step).beginDisplay(userData);
            cl.show(this, step.toString());
            this.getPanel(step).endDisplay();
        }
    }

    public void displayProgress(ProgressDescriptor descriptor) {
        for (WizardStep s : this.hmPanels.keySet()) {
            this.getPanel(s).displayProgress(descriptor);
        }
    }

    public void setIcon(UIFactory.IconType iconType) {
        for (WizardStep s : this.hmPanels.keySet()) {
            this.getPanel(s).setIcon(iconType);
        }
    }

    private QuickSetupStepPanel getPanel(WizardStep step) {
        return this.hmPanels.get(step);
    }
}

