/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.HistoricalRecord;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalLog {
    private File file;

    public HistoricalLog(File file) throws IOException {
        this.file = file;
        if (!file.exists()) {
            Utils.createFile(file);
        }
    }

    public List<HistoricalRecord> getRecords() throws IOException {
        String s;
        ArrayList<HistoricalRecord> records = new ArrayList<HistoricalRecord>();
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        while (null != (s = br.readLine())) {
            records.add(HistoricalRecord.fromString(s));
        }
        return Collections.unmodifiableList(records);
    }

    public Long append(BuildInformation from, BuildInformation to, HistoricalRecord.Status status, String note) throws IOException {
        HistoricalRecord record = new HistoricalRecord(from, to, status, note);
        Long id = record.getOperationId();
        this.append(record);
        return id;
    }

    public void append(Long id, BuildInformation from, BuildInformation to, HistoricalRecord.Status status, String note) throws IOException {
        HistoricalRecord record = new HistoricalRecord(id, from, to, status, note);
        this.append(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(HistoricalRecord record) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(this.file, true));
            bw.write(record.toString());
            bw.newLine();
            bw.flush();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

