/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opends.guitools.statuspanel.BaseDNDescriptor;
import org.opends.guitools.statuspanel.DatabaseDescriptor;
import org.opends.guitools.statuspanel.ListenerDescriptor;
import org.opends.guitools.statuspanel.ServerStatusDescriptor;
import org.opends.guitools.statuspanel.event.StatusPanelButtonListener;
import org.opends.guitools.statuspanel.ui.DatabasesTableModel;
import org.opends.guitools.statuspanel.ui.InstantaneousToolTipManager;
import org.opends.guitools.statuspanel.ui.ListenersTableModel;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.HtmlProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;

public class StatusPanelDialog
extends JFrame {
    private static final long serialVersionUID = 6832422469078074151L;
    private ServerStatusDescriptor lastDescriptor;
    private ServerStatusDescriptor lastPackDescriptor;
    private HashSet<StatusPanelButtonListener> listeners = new HashSet();
    private JButton quitButton;
    private JButton authenticateButton;
    private JLabel lServerStatus;
    private JLabel lCurrentConnections;
    private JLabel lHostname;
    private JLabel lAdministrativeUsers;
    private JLabel lInstallPath;
    private JLabel lOpenDSVersion;
    private JLabel lJavaVersion;
    private JLabel lDbTableEmpty;
    private JLabel lListenersTableEmpty;
    private JEditorPane lError;
    private JButton stopButton;
    private JButton startButton;
    private JButton restartButton;
    private HtmlProgressMessageFormatter formatter = new HtmlProgressMessageFormatter();
    private HashSet<JLabel> subsectionLabels = new HashSet();
    private DatabasesTableModel dbTableModelWithReplication;
    private DatabasesTableModel dbTableModelWithoutReplication;
    private JTable dbTableWithReplication;
    private JTable dbTableWithoutReplication;
    private ListenersTableModel listenersTableModel;
    private JTable listenersTable;
    private InstantaneousToolTipManager toolTipManager;
    private final Message NOT_AVAILABLE = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get();

    public StatusPanelDialog() {
        this.setTitle(AdminToolMessages.INFO_STATUSPANEL_DIALOG_TITLE.get().toString());
        this.createLayout();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                StatusPanelDialog.this.quitClicked();
            }
        });
        this.setDefaultCloseOperation(0);
        Utilities.setFrameIcon(this);
    }

    public void packAndShow() {
        this.pack();
        int packedMinWidth = (int)this.getPreferredSize().getWidth();
        int packedMinHeight = (int)this.getPreferredSize().getHeight();
        int minWidth = Math.min(packedMinWidth, this.getMaximalWidth());
        int minHeight = Math.min(packedMinHeight, this.getMaximalHeight());
        this.addComponentListener(new MinimumSizeComponentListener(this, minWidth, minHeight));
        if (minWidth != packedMinWidth || minHeight != packedMinHeight) {
            this.setPreferredSize(new Dimension(minWidth, minHeight));
            this.pack();
        }
        Utilities.centerOnScreen(this);
        this.lastPackDescriptor = this.lastDescriptor;
        this.setVisible(true);
    }

    public void updateContents(ServerStatusDescriptor desc) {
        boolean mustRepack;
        this.lastDescriptor = desc;
        this.updateStatusContents(desc);
        this.updateCurrentConnectionContents(desc);
        this.updateHostnameContents(desc);
        this.updateAdministrativeUserContents(desc);
        this.updateInstallPathContents(desc);
        this.updateVersionContents(desc);
        this.updateJavaVersionContents(desc);
        this.updateListenerContents(desc);
        this.updateDatabaseContents(desc);
        this.updateErrorContents(desc);
        if (this.lastPackDescriptor == null) {
            mustRepack = true;
        } else {
            boolean lastSmall = this.lastPackDescriptor.getListeners().size() == 0 && this.lastPackDescriptor.getDatabases().size() == 0;
            boolean currentBig = this.lastDescriptor.getListeners().size() > 0 || this.lastDescriptor.getDatabases().size() > 0;
            boolean bl = mustRepack = lastSmall && currentBig;
        }
        if (mustRepack) {
            this.pack();
            int packedMinWidth = (int)this.getPreferredSize().getWidth();
            int packedMinHeight = (int)this.getPreferredSize().getHeight();
            int minWidth = Math.min(packedMinWidth, this.getMaximalWidth());
            int minHeight = Math.min(packedMinHeight, this.getMaximalHeight());
            if (minWidth != packedMinWidth || minHeight != packedMinHeight) {
                this.setPreferredSize(new Dimension(minWidth, minHeight));
                this.pack();
            }
            this.lastPackDescriptor = this.lastDescriptor;
        }
    }

    public void addButtonListener(StatusPanelButtonListener l) {
        this.listeners.add(l);
    }

    public void removeButtonListener(StatusPanelButtonListener l) {
        this.listeners.remove(l);
    }

    public void setAuthenticateButtonEnabled(boolean enable) {
        this.authenticateButton.setEnabled(enable);
    }

    public void setStartButtonEnabled(boolean enable) {
        this.startButton.setEnabled(enable);
    }

    public void setStopButtonEnabled(boolean enable) {
        this.stopButton.setEnabled(enable);
    }

    public void setRestartButtonEnabled(boolean enable) {
        this.restartButton.setEnabled(enable);
    }

    private void createLayout() {
        this.toolTipManager = new InstantaneousToolTipManager();
        JPanel inputPanel = new JPanel(new GridBagLayout());
        inputPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.bottom = 10;
        this.lError = UIFactory.makeHtmlPane(Message.EMPTY, UIFactory.PROGRESS_FONT);
        this.lError.setOpaque(false);
        this.lError.setEditable(false);
        inputPanel.add((Component)this.lError, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 30 - UIFactory.getCurrentStepPanelInsets().top;
        inputPanel.add((Component)this.createServerStatusPanel(), gbc);
        inputPanel.add((Component)this.createServerDetailsPanel(), gbc);
        inputPanel.add((Component)this.createListenersPanel(), gbc);
        inputPanel.add((Component)this.createDatabasesPanel(), gbc);
        gbc.weighty = 1.0;
        inputPanel.add(Box.createVerticalGlue(), gbc);
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.setOpaque(false);
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.gridwidth = 4;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.insets.left = UIFactory.getCurrentStepPanelInsets().left;
        buttonsPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.OPENDS_SMALL, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        --gbc.gridwidth;
        gbc.insets.left = 0;
        buttonsPanel.add(Box.createHorizontalGlue(), gbc);
        this.authenticateButton = UIFactory.makeJButton(AdminToolMessages.INFO_AUTHENTICATE_BUTTON_LABEL.get(), AdminToolMessages.INFO_AUTHENTICATE_STATUS_PANEL_BUTTON_TOOLTIP.get());
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        buttonsPanel.add((Component)this.authenticateButton, gbc);
        this.authenticateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StatusPanelDialog.this.authenticateClicked();
            }
        });
        this.quitButton = UIFactory.makeJButton(QuickSetupMessages.INFO_QUIT_BUTTON_LABEL.get(), AdminToolMessages.INFO_QUIT_STATUS_PANEL_BUTTON_TOOLTIP.get());
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        buttonsPanel.add((Component)this.quitButton, gbc);
        this.quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StatusPanelDialog.this.quitClicked();
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        p1.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        p1.add((Component)inputPanel, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        p.add((Component)new JScrollPane(p1), gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        p.add((Component)buttonsPanel, gbc);
        this.getContentPane().add(p);
        int maxWidth = 0;
        for (JLabel l : this.subsectionLabels) {
            int width = (int)l.getPreferredSize().getWidth();
            if (maxWidth > width) continue;
            maxWidth = width;
        }
        for (JLabel l : this.subsectionLabels) {
            int height = (int)l.getPreferredSize().getHeight();
            l.setPreferredSize(new Dimension(maxWidth, height));
        }
    }

    private void startClicked() {
        for (StatusPanelButtonListener l : this.listeners) {
            l.startClicked();
        }
    }

    private void quitClicked() {
        for (StatusPanelButtonListener l : this.listeners) {
            l.quitClicked();
        }
    }

    private void authenticateClicked() {
        for (StatusPanelButtonListener l : this.listeners) {
            l.authenticateClicked();
        }
    }

    private void stopClicked() {
        for (StatusPanelButtonListener l : this.listeners) {
            l.stopClicked();
        }
    }

    private void restartClicked() {
        for (StatusPanelButtonListener l : this.listeners) {
            l.restartClicked();
        }
    }

    private JPanel createSubsectionTitle(Message title) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 5;
        gbc.weightx = 0.5;
        p.add(Box.createHorizontalGlue(), gbc);
        gbc.weightx = 0.0;
        --gbc.gridwidth;
        p.add((Component)UIFactory.makeJLabel(UIFactory.IconType.SUBSECTION_LEFT, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 0.0;
        --gbc.gridwidth;
        gbc.insets.left = 20;
        JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, title, UIFactory.TextStyle.TITLE);
        l.setHorizontalAlignment(0);
        this.subsectionLabels.add(l);
        p.add((Component)l, gbc);
        gbc.gridwidth = -1;
        p.add((Component)UIFactory.makeJLabel(UIFactory.IconType.SUBSECTION_RIGHT, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 0.5;
        gbc.insets.left = 0;
        p.add(Box.createHorizontalGlue(), gbc);
        return p;
    }

    private JPanel createServerStatusPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        p.add((Component)this.createSubsectionTitle(AdminToolMessages.INFO_SERVER_STATUS_TITLE.get()), gbc);
        JPanel auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        gbc.anchor = 17;
        gbc.gridwidth = -1;
        auxPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_SERVER_STATUS_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), gbc);
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.setOpaque(false);
        gbc.gridwidth = 6;
        gbc.weightx = 0.0;
        this.lServerStatus = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.NOT_AVAILABLE, UIFactory.TextStyle.READ_ONLY);
        statusPanel.add((Component)this.lServerStatus, gbc);
        this.toolTipManager.registerComponent(this.lServerStatus);
        --gbc.gridwidth;
        this.stopButton = UIFactory.makeJButton(AdminToolMessages.INFO_STOP_BUTTON_LABEL.get(), AdminToolMessages.INFO_STOP_BUTTON_TOOLTIP.get());
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StatusPanelDialog.this.stopClicked();
            }
        });
        gbc.insets.left = 10;
        statusPanel.add((Component)this.stopButton, gbc);
        --gbc.gridwidth;
        gbc.insets.left = 5;
        this.startButton = UIFactory.makeJButton(AdminToolMessages.INFO_START_BUTTON_LABEL.get(), AdminToolMessages.INFO_START_BUTTON_TOOLTIP.get());
        statusPanel.add((Component)this.startButton, gbc);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StatusPanelDialog.this.startClicked();
            }
        });
        --gbc.gridwidth;
        this.restartButton = UIFactory.makeJButton(AdminToolMessages.INFO_RESTART_BUTTON_LABEL.get(), AdminToolMessages.INFO_RESTART_BUTTON_TOOLTIP.get());
        this.restartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StatusPanelDialog.this.restartClicked();
            }
        });
        statusPanel.add((Component)this.restartButton, gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        statusPanel.add(Box.createHorizontalGlue(), gbc);
        int maxButtonHeight = 0;
        maxButtonHeight = Math.max(maxButtonHeight, (int)this.startButton.getPreferredSize().getHeight());
        maxButtonHeight = Math.max(maxButtonHeight, (int)this.restartButton.getPreferredSize().getHeight());
        maxButtonHeight = Math.max(maxButtonHeight, (int)this.stopButton.getPreferredSize().getHeight());
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        statusPanel.add(Box.createVerticalStrut(maxButtonHeight), gbc);
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        auxPanel.add((Component)statusPanel, gbc);
        gbc.insets.left = 0;
        gbc.weightx = 0.0;
        gbc.insets.top = 10;
        gbc.gridwidth = -1;
        auxPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_CONNECTIONS_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), gbc);
        this.lCurrentConnections = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.NOT_AVAILABLE, UIFactory.TextStyle.READ_ONLY);
        this.toolTipManager.registerComponent(this.lCurrentConnections);
        gbc.gridwidth = 0;
        gbc.insets.left = 10;
        auxPanel.add((Component)this.lCurrentConnections, gbc);
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        p.add((Component)auxPanel, gbc);
        return p;
    }

    private JPanel createServerDetailsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        p.add((Component)this.createSubsectionTitle(AdminToolMessages.INFO_SERVER_DETAILS_TITLE.get()), gbc);
        JPanel auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        gbc.anchor = 18;
        gbc.weightx = 0.0;
        JLabel[] leftLabels = new JLabel[]{UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_HOSTNAME_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_INSTALLATION_PATH_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_OPENDS_VERSION_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_JAVA_VERSION_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID)};
        this.lHostname = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.NOT_AVAILABLE, UIFactory.TextStyle.READ_ONLY);
        this.lAdministrativeUsers = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.NOT_AVAILABLE, UIFactory.TextStyle.READ_ONLY);
        this.lInstallPath = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.NOT_AVAILABLE, UIFactory.TextStyle.READ_ONLY);
        this.lOpenDSVersion = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.NOT_AVAILABLE, UIFactory.TextStyle.READ_ONLY);
        this.lJavaVersion = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.NOT_AVAILABLE, UIFactory.TextStyle.READ_ONLY);
        JLabel[] rightLabels = new JLabel[]{this.lHostname, this.lAdministrativeUsers, this.lInstallPath, this.lOpenDSVersion, this.lJavaVersion};
        for (int i = 0; i < leftLabels.length; ++i) {
            gbc.insets.left = 0;
            if (i != 0) {
                gbc.insets.top = 10;
            }
            gbc.gridwidth = -1;
            auxPanel.add((Component)leftLabels[i], gbc);
            gbc.gridwidth = 0;
            gbc.insets.left = 10;
            auxPanel.add((Component)rightLabels[i], gbc);
            this.toolTipManager.registerComponent(rightLabels[i]);
        }
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        p.add((Component)auxPanel, gbc);
        return p;
    }

    private JPanel createListenersPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        p.add((Component)this.createSubsectionTitle(AdminToolMessages.INFO_LISTENERS_TITLE.get()), gbc);
        this.listenersTableModel = new ListenersTableModel();
        this.listenersTable = UIFactory.makeSortableTable(this.listenersTableModel, new ListenersCellRenderer(), UIFactory.makeHeaderRenderer());
        this.listenersTable.setFocusable(false);
        gbc.insets.top = 10;
        p.add((Component)this.listenersTable.getTableHeader(), gbc);
        int height = (int)this.listenersTable.getTableHeader().getPreferredSize().getHeight();
        this.listenersTable.setRowHeight(height);
        gbc.insets.top = 0;
        p.add((Component)this.listenersTable, gbc);
        this.lListenersTableEmpty = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, Message.EMPTY, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        gbc.insets.top = 10;
        p.add((Component)this.lListenersTableEmpty, gbc);
        this.lListenersTableEmpty.setVisible(false);
        this.toolTipManager.registerComponent(this.lListenersTableEmpty);
        return p;
    }

    private JPanel createDatabasesPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        p.add((Component)this.createSubsectionTitle(AdminToolMessages.INFO_DATABASES_TITLE.get()), gbc);
        this.dbTableModelWithReplication = new DatabasesTableModel(true);
        this.dbTableModelWithoutReplication = new DatabasesTableModel(false);
        this.dbTableWithReplication = UIFactory.makeSortableTable(this.dbTableModelWithReplication, new DatabasesCellRenderer(), UIFactory.makeHeaderRenderer());
        this.dbTableWithReplication.setFocusable(false);
        this.toolTipManager.registerComponent(this.dbTableWithReplication);
        this.dbTableWithoutReplication = UIFactory.makeSortableTable(this.dbTableModelWithoutReplication, new DatabasesCellRenderer(), UIFactory.makeHeaderRenderer());
        this.dbTableWithoutReplication.setFocusable(false);
        this.toolTipManager.registerComponent(this.dbTableWithoutReplication);
        gbc.insets.top = 10;
        p.add((Component)this.dbTableWithReplication.getTableHeader(), gbc);
        int height = (int)this.dbTableWithReplication.getTableHeader().getPreferredSize().getHeight();
        this.dbTableWithReplication.setRowHeight(height);
        gbc.insets.top = 0;
        p.add((Component)this.dbTableWithReplication, gbc);
        gbc.insets.top = 10;
        p.add((Component)this.dbTableWithoutReplication.getTableHeader(), gbc);
        height = (int)this.dbTableWithoutReplication.getTableHeader().getPreferredSize().getHeight();
        this.dbTableWithoutReplication.setRowHeight(height);
        gbc.insets.top = 0;
        p.add((Component)this.dbTableWithoutReplication, gbc);
        this.dbTableWithoutReplication.setVisible(false);
        gbc.insets.top = 10;
        this.lDbTableEmpty = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, Message.EMPTY, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        p.add((Component)this.lDbTableEmpty, gbc);
        this.lDbTableEmpty.setVisible(false);
        this.toolTipManager.registerComponent(this.lDbTableEmpty);
        return p;
    }

    private void setNotAvailableBecauseServerIsDown(JLabel l) {
        l.setText(this.NOT_AVAILABLE.toString());
        l.setIcon(UIFactory.getImageIcon(UIFactory.IconType.HELP_SMALL));
        l.setToolTipText(AdminToolMessages.INFO_NOT_AVAILABLE_SERVER_DOWN_TOOLTIP.get().toString());
        l.setHorizontalTextPosition(2);
    }

    private void setNotAvailableBecauseAuthenticationIsRequired(JLabel l) {
        l.setText(this.NOT_AVAILABLE.toString());
        l.setIcon(UIFactory.getImageIcon(UIFactory.IconType.HELP_SMALL));
        l.setToolTipText(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_TOOLTIP.get().toString());
        l.setHorizontalTextPosition(2);
    }

    private void setNotAvailable(JLabel l) {
        l.setText(this.NOT_AVAILABLE.toString());
        l.setIcon(null);
        l.setToolTipText(null);
    }

    private void setTextValue(JLabel l, String text) {
        l.setText(text);
        l.setIcon(null);
        l.setToolTipText(null);
    }

    private void updateStatusContents(ServerStatusDescriptor desc) {
        Message status;
        switch (desc.getStatus()) {
            case STARTED: {
                status = AdminToolMessages.INFO_SERVER_STARTED_LABEL.get();
                this.startButton.setVisible(false);
                this.restartButton.setVisible(true);
                this.stopButton.setVisible(true);
                break;
            }
            case STOPPED: {
                status = AdminToolMessages.INFO_SERVER_STOPPED_LABEL.get();
                this.startButton.setVisible(true);
                this.restartButton.setVisible(false);
                this.stopButton.setVisible(false);
                break;
            }
            case STARTING: {
                status = AdminToolMessages.INFO_SERVER_STARTING_LABEL.get();
                this.startButton.setVisible(false);
                this.restartButton.setVisible(false);
                this.stopButton.setVisible(false);
                break;
            }
            case STOPPING: {
                status = AdminToolMessages.INFO_SERVER_STOPPING_LABEL.get();
                this.startButton.setVisible(false);
                this.restartButton.setVisible(false);
                this.stopButton.setVisible(false);
                break;
            }
            case UNKNOWN: {
                status = AdminToolMessages.INFO_SERVER_UNKNOWN_STATUS_LABEL.get();
                this.startButton.setVisible(false);
                this.restartButton.setVisible(true);
                this.stopButton.setVisible(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status: " + (Object)((Object)desc.getStatus()));
            }
        }
        this.lServerStatus.setText(status.toString());
        this.authenticateButton.setVisible(desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED && (!desc.isAuthenticated() || desc.getErrorMessage() != null));
    }

    private void updateCurrentConnectionContents(ServerStatusDescriptor desc) {
        if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
            int nConn = desc.getOpenConnections();
            if (nConn >= 0) {
                this.setTextValue(this.lCurrentConnections, String.valueOf(nConn));
            } else if (!desc.isAuthenticated()) {
                this.setNotAvailableBecauseAuthenticationIsRequired(this.lCurrentConnections);
            } else {
                this.setNotAvailable(this.lCurrentConnections);
            }
        } else {
            this.setNotAvailableBecauseServerIsDown(this.lCurrentConnections);
        }
    }

    private void updateHostnameContents(ServerStatusDescriptor desc) {
        this.lHostname.setText(desc.getHostname());
    }

    private void updateAdministrativeUserContents(ServerStatusDescriptor desc) {
        Set<String> administrators = desc.getAdministrativeUsers();
        if (administrators.size() > 0) {
            TreeSet<Message> ordered = new TreeSet<Message>();
            for (String name : administrators) {
                ordered.add(this.formatter.getFormattedText(Message.raw(name, new Object[0])));
            }
            this.setTextValue(this.lAdministrativeUsers, "<html>" + UIFactory.applyFontToHtml(Utils.getMessageFromCollection(ordered, "<br>").toString(), UIFactory.READ_ONLY_FONT));
        } else if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
            if (!desc.isAuthenticated()) {
                this.setNotAvailableBecauseAuthenticationIsRequired(this.lAdministrativeUsers);
            } else {
                this.setNotAvailable(this.lAdministrativeUsers);
            }
        } else {
            this.setNotAvailable(this.lAdministrativeUsers);
        }
    }

    private void updateInstallPathContents(ServerStatusDescriptor desc) {
        File path = desc.getInstallPath();
        this.lInstallPath.setText(path.toString());
    }

    private void updateVersionContents(ServerStatusDescriptor desc) {
        String openDSVersion = desc.getOpenDSVersion();
        this.lOpenDSVersion.setText(openDSVersion);
    }

    private void updateJavaVersionContents(ServerStatusDescriptor desc) {
        if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
            String javaVersion = desc.getJavaVersion();
            if (javaVersion != null) {
                this.setTextValue(this.lJavaVersion, javaVersion);
            } else if (!desc.isAuthenticated()) {
                this.setNotAvailableBecauseAuthenticationIsRequired(this.lJavaVersion);
            } else {
                this.setNotAvailable(this.lJavaVersion);
            }
        } else {
            this.setNotAvailableBecauseServerIsDown(this.lJavaVersion);
        }
    }

    private void updateListenerContents(ServerStatusDescriptor desc) {
        Set<ListenerDescriptor> allListeners = desc.getListeners();
        LinkedHashSet<ListenerDescriptor> listeners = new LinkedHashSet<ListenerDescriptor>();
        for (ListenerDescriptor listener : allListeners) {
            if (listener.getProtocol() == ListenerDescriptor.Protocol.LDIF) continue;
            listeners.add(listener);
        }
        this.listenersTableModel.setData(listeners);
        if (this.listenersTableModel.getRowCount() == 0) {
            this.listenersTable.setVisible(false);
            this.listenersTable.getTableHeader().setVisible(false);
            this.lListenersTableEmpty.setVisible(true);
            if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
                if (!desc.isAuthenticated()) {
                    this.setNotAvailableBecauseAuthenticationIsRequired(this.lListenersTableEmpty);
                } else {
                    this.setTextValue(this.lListenersTableEmpty, AdminToolMessages.INFO_NO_LISTENERS_FOUND.get().toString());
                }
            } else {
                this.setTextValue(this.lListenersTableEmpty, AdminToolMessages.INFO_NO_LISTENERS_FOUND.get().toString());
            }
        } else {
            this.listenersTable.setVisible(true);
            this.listenersTable.getTableHeader().setVisible(true);
            this.lListenersTableEmpty.setVisible(false);
        }
    }

    private void updateDatabaseContents(ServerStatusDescriptor desc) {
        HashSet<BaseDNDescriptor> replicas = new HashSet<BaseDNDescriptor>();
        Set<DatabaseDescriptor> dbs = desc.getDatabases();
        for (DatabaseDescriptor db : dbs) {
            replicas.addAll(db.getBaseDns());
        }
        this.dbTableModelWithReplication.setData(replicas);
        this.dbTableModelWithoutReplication.setData(replicas);
        if (this.dbTableModelWithReplication.getRowCount() == 0) {
            this.dbTableWithoutReplication.setVisible(false);
            this.dbTableWithoutReplication.getTableHeader().setVisible(false);
            this.dbTableWithReplication.setVisible(false);
            this.dbTableWithReplication.getTableHeader().setVisible(false);
            this.lDbTableEmpty.setVisible(true);
            if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
                if (!desc.isAuthenticated()) {
                    this.setNotAvailableBecauseAuthenticationIsRequired(this.lDbTableEmpty);
                } else {
                    this.setTextValue(this.lDbTableEmpty, AdminToolMessages.INFO_NO_DBS_FOUND.get().toString());
                }
            } else {
                this.setTextValue(this.lDbTableEmpty, AdminToolMessages.INFO_NO_DBS_FOUND.get().toString());
            }
        } else {
            boolean replicated = false;
            for (BaseDNDescriptor suffix : replicas) {
                if (suffix.getType() != BaseDNDescriptor.Type.REPLICATED) continue;
                replicated = true;
            }
            this.updateTableSizes(this.dbTableWithoutReplication);
            this.updateTableSizes(this.dbTableWithReplication);
            this.dbTableWithoutReplication.setVisible(!replicated);
            this.dbTableWithoutReplication.getTableHeader().setVisible(!replicated);
            this.dbTableWithReplication.setVisible(replicated);
            this.dbTableWithReplication.getTableHeader().setVisible(replicated);
            this.lDbTableEmpty.setVisible(false);
        }
    }

    private void updateErrorContents(ServerStatusDescriptor desc) {
        Message errorMsg = desc.getErrorMessage();
        if (errorMsg == null) {
            this.lError.setVisible(false);
        } else {
            this.lError.setVisible(true);
            this.lError.setText(this.formatter.getFormattedError(errorMsg, false).toString());
        }
    }

    private void updateTableSizes(JTable table) {
        this.updateTableColumnWidth(table);
        this.updateTableRowHeight(table);
    }

    private void updateTableRowHeight(JTable table) {
        int headerMaxHeight = 0;
        for (int col = 0; col < table.getColumnCount(); ++col) {
            TableColumn tcol = table.getColumnModel().getColumn(col);
            TableCellRenderer renderer = tcol.getHeaderRenderer();
            Component comp = renderer.getTableCellRendererComponent(table, table.getModel().getColumnName(col), false, false, 0, col);
            int colHeight = (int)comp.getPreferredSize().getHeight();
            headerMaxHeight = Math.max(headerMaxHeight, colHeight);
        }
        JTableHeader header = table.getTableHeader();
        header.setPreferredSize(new Dimension((int)header.getPreferredSize().getWidth(), headerMaxHeight));
        for (int row = 0; row < table.getRowCount(); ++row) {
            int rowMaxHeight = table.getRowHeight();
            for (int col = 0; col < table.getColumnCount(); ++col) {
                TableCellRenderer renderer = table.getCellRenderer(row, col);
                Component comp = table.prepareRenderer(renderer, row, col);
                int colHeight = (int)comp.getPreferredSize().getHeight();
                rowMaxHeight = Math.max(rowMaxHeight, colHeight);
            }
            table.setRowHeight(row, rowMaxHeight);
        }
    }

    private void updateTableColumnWidth(JTable table) {
        int margin = table.getIntercellSpacing().width;
        for (int col = 0; col < table.getColumnCount(); ++col) {
            TableColumn tcol = table.getColumnModel().getColumn(col);
            TableCellRenderer renderer = tcol.getHeaderRenderer();
            Component comp = renderer.getTableCellRendererComponent(table, table.getModel().getColumnName(col), false, false, 0, col);
            int colMaxWidth = (int)comp.getPreferredSize().getWidth();
            for (int row = 0; row < table.getRowCount(); ++row) {
                renderer = table.getCellRenderer(row, col);
                comp = table.prepareRenderer(renderer, row, col);
                int colWidth = (int)comp.getPreferredSize().getWidth() + 2 * margin;
                colMaxWidth = Math.max(colMaxWidth, colWidth);
            }
            tcol.setPreferredWidth(colMaxWidth);
        }
    }

    private int getMaximalWidth() {
        boolean multipleScreen;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bl = multipleScreen = screenSize.width / screenSize.height >= 2;
        if (multipleScreen) {
            return Math.min(screenSize.width / 2 - 100, 1000);
        }
        return Math.min(screenSize.width - 100, 1000);
    }

    private int getMaximalHeight() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return Math.min(screenSize.height - 100, 800);
    }

    public static void main(String[] args) {
        try {
            UIFactory.initialize();
            StatusPanelDialog dlg = new StatusPanelDialog();
            dlg.packAndShow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class ListenersCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -256719167426289735L;

        public ListenersCellRenderer() {
            UIFactory.setTextStyle(this, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            StatusPanelDialog.this.setTextValue(this, (String)value);
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, this.getText(), isSelected, hasFocus, row, column);
            if (column == 0) {
                comp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, UIFactory.PANEL_BORDER_COLOR), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            } else {
                comp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            }
            return comp;
        }
    }

    class DatabasesCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -256719167426289735L;

        public DatabasesCellRenderer() {
            UIFactory.setTextStyle(this, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text = null;
            if (value instanceof String) {
                text = (String)value;
            } else if (value instanceof Message) {
                text = ((Message)value).toString();
            } else if (value instanceof Set) {
                LinkedHashSet<String> baseDns = new LinkedHashSet<String>();
                for (Object v : (Set)value) {
                    baseDns.add((String)v);
                }
                text = "<html>" + UIFactory.applyFontToHtml(Utils.getStringFromCollection(baseDns, "<br>"), UIFactory.SECONDARY_FIELD_VALID_FONT);
            } else if (StatusPanelDialog.this.lastDescriptor.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
                int nEntries = (Integer)value;
                if (nEntries >= 0) {
                    text = String.valueOf(nEntries);
                } else if (!StatusPanelDialog.this.lastDescriptor.isAuthenticated()) {
                    StatusPanelDialog.this.setNotAvailableBecauseAuthenticationIsRequired(this);
                } else {
                    StatusPanelDialog.this.setNotAvailable(this);
                }
            } else {
                StatusPanelDialog.this.setNotAvailableBecauseServerIsDown(this);
            }
            if (text != null) {
                StatusPanelDialog.this.setTextValue(this, text);
            }
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, this.getText(), isSelected, hasFocus, row, column);
            if (column == 0) {
                comp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, UIFactory.PANEL_BORDER_COLOR), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            } else {
                comp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            }
            return comp;
        }
    }
}

