/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public class ApplicationKeyManager
implements X509KeyManager {
    private static final Logger LOG = Logger.getLogger(ApplicationKeyManager.class.getName());
    private X509KeyManager sunJSSEX509KeyManager = null;

    public ApplicationKeyManager(KeyStore keystore, char[] password) {
        KeyManagerFactory kmf = null;
        String algo = "SunX509";
        String provider = "SunJSSE";
        try {
            kmf = KeyManagerFactory.getInstance(algo, provider);
            kmf.init(keystore, password);
            KeyManager[] kms = kmf.getKeyManagers();
            for (int i = 0; i < kms.length; ++i) {
                if (!(kms[i] instanceof X509KeyManager)) continue;
                this.sunJSSEX509KeyManager = (X509KeyManager)kms[i];
                break;
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.WARNING, "Error with the algorithm", e);
        }
        catch (NoSuchProviderException e) {
            LOG.log(Level.WARNING, "Error with the provider", e);
        }
        catch (KeyStoreException e) {
            LOG.log(Level.WARNING, "Error with the keystore", e);
        }
        catch (UnrecoverableKeyException e) {
            LOG.log(Level.WARNING, "Error with the key", e);
        }
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.chooseClientAlias(keyType, issuers, socket);
        }
        return null;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.chooseServerAlias(keyType, issuers, socket);
        }
        return null;
    }

    public X509Certificate[] getCertificateChain(String alias) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.getCertificateChain(alias);
        }
        return null;
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.getClientAliases(keyType, issuers);
        }
        return null;
    }

    public PrivateKey getPrivateKey(String alias) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.getPrivateKey(alias);
        }
        return null;
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.getServerAliases(keyType, issuers);
        }
        return null;
    }
}

