/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse;

public class ListUserAccessLoggingSettingsIterable
implements SdkIterable<ListUserAccessLoggingSettingsResponse> {
    private final WorkSpacesWebClient client;
    private final ListUserAccessLoggingSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserAccessLoggingSettingsIterable(WorkSpacesWebClient client, ListUserAccessLoggingSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUserAccessLoggingSettingsResponseFetcher();
    }

    public Iterator<ListUserAccessLoggingSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListUserAccessLoggingSettingsResponseFetcher
    implements SyncPageFetcher<ListUserAccessLoggingSettingsResponse> {
        private ListUserAccessLoggingSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserAccessLoggingSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUserAccessLoggingSettingsResponse nextPage(ListUserAccessLoggingSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListUserAccessLoggingSettingsIterable.this.client.listUserAccessLoggingSettings(ListUserAccessLoggingSettingsIterable.this.firstRequest);
            }
            return ListUserAccessLoggingSettingsIterable.this.client.listUserAccessLoggingSettings((ListUserAccessLoggingSettingsRequest)((Object)ListUserAccessLoggingSettingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

