/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsForEntityResponse;

public class ListGroupsForEntityPublisher
implements SdkPublisher<ListGroupsForEntityResponse> {
    private final WorkMailAsyncClient client;
    private final ListGroupsForEntityRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupsForEntityPublisher(WorkMailAsyncClient client, ListGroupsForEntityRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupsForEntityPublisher(WorkMailAsyncClient client, ListGroupsForEntityRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupsForEntityResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupsForEntityResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListGroupsForEntityResponseFetcher
    implements AsyncPageFetcher<ListGroupsForEntityResponse> {
        private ListGroupsForEntityResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsForEntityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupsForEntityResponse> nextPage(ListGroupsForEntityResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsForEntityPublisher.this.client.listGroupsForEntity(ListGroupsForEntityPublisher.this.firstRequest);
            }
            return ListGroupsForEntityPublisher.this.client.listGroupsForEntity((ListGroupsForEntityRequest)((Object)ListGroupsForEntityPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

