/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filtering options for <i>ListGroupsForEntity</i> operation. This is only used as input to Operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsForEntityFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ListGroupsForEntityFilters.Builder, ListGroupsForEntityFilters> {
    private static final SdkField<String> GROUP_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupNamePrefix").getter(getter(ListGroupsForEntityFilters::groupNamePrefix))
            .setter(setter(Builder::groupNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupNamePrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupNamePrefix;

    private ListGroupsForEntityFilters(BuilderImpl builder) {
        this.groupNamePrefix = builder.groupNamePrefix;
    }

    /**
     * <p>
     * Filters only group names that start with the provided name prefix.
     * </p>
     * 
     * @return Filters only group names that start with the provided name prefix.
     */
    public final String groupNamePrefix() {
        return groupNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupNamePrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsForEntityFilters)) {
            return false;
        }
        ListGroupsForEntityFilters other = (ListGroupsForEntityFilters) obj;
        return Objects.equals(groupNamePrefix(), other.groupNamePrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupsForEntityFilters").add("GroupNamePrefix", groupNamePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupNamePrefix":
            return Optional.ofNullable(clazz.cast(groupNamePrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsForEntityFilters, T> g) {
        return obj -> g.apply((ListGroupsForEntityFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListGroupsForEntityFilters> {
        /**
         * <p>
         * Filters only group names that start with the provided name prefix.
         * </p>
         * 
         * @param groupNamePrefix
         *        Filters only group names that start with the provided name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNamePrefix(String groupNamePrefix);
    }

    static final class BuilderImpl implements Builder {
        private String groupNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsForEntityFilters model) {
            groupNamePrefix(model.groupNamePrefix);
        }

        public final String getGroupNamePrefix() {
            return groupNamePrefix;
        }

        public final void setGroupNamePrefix(String groupNamePrefix) {
            this.groupNamePrefix = groupNamePrefix;
        }

        @Override
        public final Builder groupNamePrefix(String groupNamePrefix) {
            this.groupNamePrefix = groupNamePrefix;
            return this;
        }

        @Override
        public ListGroupsForEntityFilters build() {
            return new ListGroupsForEntityFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
