/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;

public class DescribeRootFoldersIterable
implements SdkIterable<DescribeRootFoldersResponse> {
    private final WorkDocsClient client;
    private final DescribeRootFoldersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRootFoldersIterable(WorkDocsClient client, DescribeRootFoldersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRootFoldersResponseFetcher();
    }

    public Iterator<DescribeRootFoldersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FolderMetadata> folders() {
        Function<DescribeRootFoldersResponse, Iterator> getIterator = response -> {
            if (response != null && response.folders() != null) {
                return response.folders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRootFoldersResponseFetcher
    implements SyncPageFetcher<DescribeRootFoldersResponse> {
        private DescribeRootFoldersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRootFoldersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeRootFoldersResponse nextPage(DescribeRootFoldersResponse previousPage) {
            if (previousPage == null) {
                return DescribeRootFoldersIterable.this.client.describeRootFolders(DescribeRootFoldersIterable.this.firstRequest);
            }
            return DescribeRootFoldersIterable.this.client.describeRootFolders((DescribeRootFoldersRequest)((Object)DescribeRootFoldersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

