/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.Activity;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse;

public class DescribeActivitiesPublisher
implements SdkPublisher<DescribeActivitiesResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeActivitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeActivitiesPublisher(WorkDocsAsyncClient client, DescribeActivitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeActivitiesPublisher(WorkDocsAsyncClient client, DescribeActivitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeActivitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeActivitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Activity> userActivities() {
        Function<DescribeActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.userActivities() != null) {
                return response.userActivities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeActivitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeActivitiesResponseFetcher
    implements AsyncPageFetcher<DescribeActivitiesResponse> {
        private DescribeActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeActivitiesResponse> nextPage(DescribeActivitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeActivitiesPublisher.this.client.describeActivities(DescribeActivitiesPublisher.this.firstRequest);
            }
            return DescribeActivitiesPublisher.this.client.describeActivities((DescribeActivitiesRequest)((Object)DescribeActivitiesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

