/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMedicalScribeJobResponse extends TranscribeResponse implements
        ToCopyableBuilder<GetMedicalScribeJobResponse.Builder, GetMedicalScribeJobResponse> {
    private static final SdkField<MedicalScribeJob> MEDICAL_SCRIBE_JOB_FIELD = SdkField
            .<MedicalScribeJob> builder(MarshallingType.SDK_POJO).memberName("MedicalScribeJob")
            .getter(getter(GetMedicalScribeJobResponse::medicalScribeJob)).setter(setter(Builder::medicalScribeJob))
            .constructor(MedicalScribeJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDICAL_SCRIBE_JOB_FIELD));

    private final MedicalScribeJob medicalScribeJob;

    private GetMedicalScribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.medicalScribeJob = builder.medicalScribeJob;
    }

    /**
     * <p>
     * Provides detailed information about the specified Medical Scribe job, including job status and, if applicable,
     * failure reason
     * </p>
     * 
     * @return Provides detailed information about the specified Medical Scribe job, including job status and, if
     *         applicable, failure reason
     */
    public final MedicalScribeJob medicalScribeJob() {
        return medicalScribeJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(medicalScribeJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMedicalScribeJobResponse)) {
            return false;
        }
        GetMedicalScribeJobResponse other = (GetMedicalScribeJobResponse) obj;
        return Objects.equals(medicalScribeJob(), other.medicalScribeJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMedicalScribeJobResponse").add("MedicalScribeJob", medicalScribeJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MedicalScribeJob":
            return Optional.ofNullable(clazz.cast(medicalScribeJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMedicalScribeJobResponse, T> g) {
        return obj -> g.apply((GetMedicalScribeJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMedicalScribeJobResponse> {
        /**
         * <p>
         * Provides detailed information about the specified Medical Scribe job, including job status and, if
         * applicable, failure reason
         * </p>
         * 
         * @param medicalScribeJob
         *        Provides detailed information about the specified Medical Scribe job, including job status and, if
         *        applicable, failure reason
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalScribeJob(MedicalScribeJob medicalScribeJob);

        /**
         * <p>
         * Provides detailed information about the specified Medical Scribe job, including job status and, if
         * applicable, failure reason
         * </p>
         * This is a convenience method that creates an instance of the {@link MedicalScribeJob.Builder} avoiding the
         * need to create one manually via {@link MedicalScribeJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalScribeJob.Builder#build()} is called immediately and its
         * result is passed to {@link #medicalScribeJob(MedicalScribeJob)}.
         * 
         * @param medicalScribeJob
         *        a consumer that will call methods on {@link MedicalScribeJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #medicalScribeJob(MedicalScribeJob)
         */
        default Builder medicalScribeJob(Consumer<MedicalScribeJob.Builder> medicalScribeJob) {
            return medicalScribeJob(MedicalScribeJob.builder().applyMutation(medicalScribeJob).build());
        }
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private MedicalScribeJob medicalScribeJob;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMedicalScribeJobResponse model) {
            super(model);
            medicalScribeJob(model.medicalScribeJob);
        }

        public final MedicalScribeJob.Builder getMedicalScribeJob() {
            return medicalScribeJob != null ? medicalScribeJob.toBuilder() : null;
        }

        public final void setMedicalScribeJob(MedicalScribeJob.BuilderImpl medicalScribeJob) {
            this.medicalScribeJob = medicalScribeJob != null ? medicalScribeJob.build() : null;
        }

        @Override
        public final Builder medicalScribeJob(MedicalScribeJob medicalScribeJob) {
            this.medicalScribeJob = medicalScribeJob;
            return this;
        }

        @Override
        public GetMedicalScribeJobResponse build() {
            return new GetMedicalScribeJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
