/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationEventType;
import software.amazon.awssdk.services.supplychain.model.SupplyChainRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendDataIntegrationEventRequest
extends SupplyChainRequest
implements ToCopyableBuilder<Builder, SendDataIntegrationEventRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(SendDataIntegrationEventRequest.getter(SendDataIntegrationEventRequest::instanceId)).setter(SendDataIntegrationEventRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("instanceId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(SendDataIntegrationEventRequest.getter(SendDataIntegrationEventRequest::eventTypeAsString)).setter(SendDataIntegrationEventRequest.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("data").getter(SendDataIntegrationEventRequest.getter(SendDataIntegrationEventRequest::data)).setter(SendDataIntegrationEventRequest.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<String> EVENT_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventGroupId").getter(SendDataIntegrationEventRequest.getter(SendDataIntegrationEventRequest::eventGroupId)).setter(SendDataIntegrationEventRequest.setter(Builder::eventGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventGroupId").build()}).build();
    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTimestamp").getter(SendDataIntegrationEventRequest.getter(SendDataIntegrationEventRequest::eventTimestamp)).setter(SendDataIntegrationEventRequest.setter(Builder::eventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(SendDataIntegrationEventRequest.getter(SendDataIntegrationEventRequest::clientToken)).setter(SendDataIntegrationEventRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, EVENT_TYPE_FIELD, DATA_FIELD, EVENT_GROUP_ID_FIELD, EVENT_TIMESTAMP_FIELD, CLIENT_TOKEN_FIELD));
    private final String instanceId;
    private final String eventType;
    private final String data;
    private final String eventGroupId;
    private final Instant eventTimestamp;
    private final String clientToken;

    private SendDataIntegrationEventRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.eventType = builder.eventType;
        this.data = builder.data;
        this.eventGroupId = builder.eventGroupId;
        this.eventTimestamp = builder.eventTimestamp;
        this.clientToken = builder.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final DataIntegrationEventType eventType() {
        return DataIntegrationEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final String data() {
        return this.data;
    }

    public final String eventGroupId() {
        return this.eventGroupId;
    }

    public final Instant eventTimestamp() {
        return this.eventTimestamp;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataIntegrationEventRequest)) {
            return false;
        }
        SendDataIntegrationEventRequest other = (SendDataIntegrationEventRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.eventGroupId(), other.eventGroupId()) && Objects.equals(this.eventTimestamp(), other.eventTimestamp()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"SendDataIntegrationEventRequest").add("InstanceId", (Object)this.instanceId()).add("EventType", (Object)this.eventTypeAsString()).add("Data", (Object)(this.data() == null ? null : "*** Sensitive Data Redacted ***")).add("EventGroupId", (Object)this.eventGroupId()).add("EventTimestamp", (Object)this.eventTimestamp()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "eventGroupId": {
                return Optional.ofNullable(clazz.cast(this.eventGroupId()));
            }
            case "eventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.eventTimestamp()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendDataIntegrationEventRequest, T> g) {
        return obj -> g.apply((SendDataIntegrationEventRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupplyChainRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String eventType;
        private String data;
        private String eventGroupId;
        private Instant eventTimestamp;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataIntegrationEventRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.eventType(model.eventType);
            this.data(model.data);
            this.eventGroupId(model.eventGroupId);
            this.eventTimestamp(model.eventTimestamp);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(DataIntegrationEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getData() {
            return this.data;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final String getEventGroupId() {
            return this.eventGroupId;
        }

        public final void setEventGroupId(String eventGroupId) {
            this.eventGroupId = eventGroupId;
        }

        @Override
        public final Builder eventGroupId(String eventGroupId) {
            this.eventGroupId = eventGroupId;
            return this;
        }

        public final Instant getEventTimestamp() {
            return this.eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDataIntegrationEventRequest build() {
            return new SendDataIntegrationEventRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SupplyChainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendDataIntegrationEventRequest> {
        public Builder instanceId(String var1);

        public Builder eventType(String var1);

        public Builder eventType(DataIntegrationEventType var1);

        public Builder data(String var1);

        public Builder eventGroupId(String var1);

        public Builder eventTimestamp(Instant var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

