/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutApplicationGrantRequest extends SsoAdminRequest implements
        ToCopyableBuilder<PutApplicationGrantRequest.Builder, PutApplicationGrantRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(PutApplicationGrantRequest::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<Grant> GRANT_FIELD = SdkField.<Grant> builder(MarshallingType.SDK_POJO).memberName("Grant")
            .getter(getter(PutApplicationGrantRequest::grant)).setter(setter(Builder::grant)).constructor(Grant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grant").build()).build();

    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantType").getter(getter(PutApplicationGrantRequest::grantTypeAsString))
            .setter(setter(Builder::grantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            GRANT_FIELD, GRANT_TYPE_FIELD));

    private final String applicationArn;

    private final Grant grant;

    private final String grantType;

    private PutApplicationGrantRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.grant = builder.grant;
        this.grantType = builder.grantType;
    }

    /**
     * <p>
     * Specifies the ARN of the application to update.
     * </p>
     * 
     * @return Specifies the ARN of the application to update.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * Specifies a structure that describes the grant to update.
     * </p>
     * 
     * @return Specifies a structure that describes the grant to update.
     */
    public final Grant grant() {
        return grant;
    }

    /**
     * <p>
     * Specifies the type of grant to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grantType} will
     * return {@link GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grantTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of grant to update.
     * @see GrantType
     */
    public final GrantType grantType() {
        return GrantType.fromValue(grantType);
    }

    /**
     * <p>
     * Specifies the type of grant to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grantType} will
     * return {@link GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grantTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of grant to update.
     * @see GrantType
     */
    public final String grantTypeAsString() {
        return grantType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(grant());
        hashCode = 31 * hashCode + Objects.hashCode(grantTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationGrantRequest)) {
            return false;
        }
        PutApplicationGrantRequest other = (PutApplicationGrantRequest) obj;
        return Objects.equals(applicationArn(), other.applicationArn()) && Objects.equals(grant(), other.grant())
                && Objects.equals(grantTypeAsString(), other.grantTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutApplicationGrantRequest").add("ApplicationArn", applicationArn()).add("Grant", grant())
                .add("GrantType", grantTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "Grant":
            return Optional.ofNullable(clazz.cast(grant()));
        case "GrantType":
            return Optional.ofNullable(clazz.cast(grantTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutApplicationGrantRequest, T> g) {
        return obj -> g.apply((PutApplicationGrantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutApplicationGrantRequest> {
        /**
         * <p>
         * Specifies the ARN of the application to update.
         * </p>
         * 
         * @param applicationArn
         *        Specifies the ARN of the application to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * Specifies a structure that describes the grant to update.
         * </p>
         * 
         * @param grant
         *        Specifies a structure that describes the grant to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grant(Grant grant);

        /**
         * <p>
         * Specifies a structure that describes the grant to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link Grant.Builder} avoiding the need to
         * create one manually via {@link Grant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Grant.Builder#build()} is called immediately and its result is
         * passed to {@link #grant(Grant)}.
         * 
         * @param grant
         *        a consumer that will call methods on {@link Grant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grant(Grant)
         */
        default Builder grant(Consumer<Grant.Builder> grant) {
            return grant(Grant.builder().applyMutation(grant).build());
        }

        /**
         * <p>
         * Specifies the type of grant to update.
         * </p>
         * 
         * @param grantType
         *        Specifies the type of grant to update.
         * @see GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantType
         */
        Builder grantType(String grantType);

        /**
         * <p>
         * Specifies the type of grant to update.
         * </p>
         * 
         * @param grantType
         *        Specifies the type of grant to update.
         * @see GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantType
         */
        Builder grantType(GrantType grantType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String applicationArn;

        private Grant grant;

        private String grantType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationGrantRequest model) {
            super(model);
            applicationArn(model.applicationArn);
            grant(model.grant);
            grantType(model.grantType);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final Grant.Builder getGrant() {
            return grant != null ? grant.toBuilder() : null;
        }

        public final void setGrant(Grant.BuilderImpl grant) {
            this.grant = grant != null ? grant.build() : null;
        }

        @Override
        public final Builder grant(Grant grant) {
            this.grant = grant;
            return this;
        }

        public final String getGrantType() {
            return grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        @Override
        public final Builder grantType(GrantType grantType) {
            this.grantType(grantType == null ? null : grantType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApplicationGrantRequest build() {
            return new PutApplicationGrantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
