/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a
 * domain level.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StudioWebPortalSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<StudioWebPortalSettings.Builder, StudioWebPortalSettings> {
    private static final SdkField<List<String>> HIDDEN_ML_TOOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HiddenMlTools")
            .getter(getter(StudioWebPortalSettings::hiddenMlToolsAsStrings))
            .setter(setter(Builder::hiddenMlToolsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenMlTools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> HIDDEN_APP_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HiddenAppTypes")
            .getter(getter(StudioWebPortalSettings::hiddenAppTypesAsStrings))
            .setter(setter(Builder::hiddenAppTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenAppTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIDDEN_ML_TOOLS_FIELD,
            HIDDEN_APP_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> hiddenMlTools;

    private final List<String> hiddenAppTypes;

    private StudioWebPortalSettings(BuilderImpl builder) {
        this.hiddenMlTools = builder.hiddenMlTools;
        this.hiddenAppTypes = builder.hiddenAppTypes;
    }

    /**
     * <p>
     * The machine learning tools that are hidden from the Studio left navigation pane.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHiddenMlTools} method.
     * </p>
     * 
     * @return The machine learning tools that are hidden from the Studio left navigation pane.
     */
    public final List<MlTools> hiddenMlTools() {
        return HiddenMlToolsListCopier.copyStringToEnum(hiddenMlTools);
    }

    /**
     * For responses, this returns true if the service returned a value for the HiddenMlTools property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHiddenMlTools() {
        return hiddenMlTools != null && !(hiddenMlTools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The machine learning tools that are hidden from the Studio left navigation pane.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHiddenMlTools} method.
     * </p>
     * 
     * @return The machine learning tools that are hidden from the Studio left navigation pane.
     */
    public final List<String> hiddenMlToolsAsStrings() {
        return hiddenMlTools;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications supported in
     * Studio</a> that are hidden from the Studio left navigation pane.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHiddenAppTypes} method.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications
     *         supported in Studio</a> that are hidden from the Studio left navigation pane.
     */
    public final List<AppType> hiddenAppTypes() {
        return HiddenAppTypesListCopier.copyStringToEnum(hiddenAppTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the HiddenAppTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHiddenAppTypes() {
        return hiddenAppTypes != null && !(hiddenAppTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications supported in
     * Studio</a> that are hidden from the Studio left navigation pane.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHiddenAppTypes} method.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications
     *         supported in Studio</a> that are hidden from the Studio left navigation pane.
     */
    public final List<String> hiddenAppTypesAsStrings() {
        return hiddenAppTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHiddenMlTools() ? hiddenMlToolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHiddenAppTypes() ? hiddenAppTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioWebPortalSettings)) {
            return false;
        }
        StudioWebPortalSettings other = (StudioWebPortalSettings) obj;
        return hasHiddenMlTools() == other.hasHiddenMlTools()
                && Objects.equals(hiddenMlToolsAsStrings(), other.hiddenMlToolsAsStrings())
                && hasHiddenAppTypes() == other.hasHiddenAppTypes()
                && Objects.equals(hiddenAppTypesAsStrings(), other.hiddenAppTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StudioWebPortalSettings")
                .add("HiddenMlTools", hasHiddenMlTools() ? hiddenMlToolsAsStrings() : null)
                .add("HiddenAppTypes", hasHiddenAppTypes() ? hiddenAppTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HiddenMlTools":
            return Optional.ofNullable(clazz.cast(hiddenMlToolsAsStrings()));
        case "HiddenAppTypes":
            return Optional.ofNullable(clazz.cast(hiddenAppTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioWebPortalSettings, T> g) {
        return obj -> g.apply((StudioWebPortalSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StudioWebPortalSettings> {
        /**
         * <p>
         * The machine learning tools that are hidden from the Studio left navigation pane.
         * </p>
         * 
         * @param hiddenMlTools
         *        The machine learning tools that are hidden from the Studio left navigation pane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenMlToolsWithStrings(Collection<String> hiddenMlTools);

        /**
         * <p>
         * The machine learning tools that are hidden from the Studio left navigation pane.
         * </p>
         * 
         * @param hiddenMlTools
         *        The machine learning tools that are hidden from the Studio left navigation pane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenMlToolsWithStrings(String... hiddenMlTools);

        /**
         * <p>
         * The machine learning tools that are hidden from the Studio left navigation pane.
         * </p>
         * 
         * @param hiddenMlTools
         *        The machine learning tools that are hidden from the Studio left navigation pane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenMlTools(Collection<MlTools> hiddenMlTools);

        /**
         * <p>
         * The machine learning tools that are hidden from the Studio left navigation pane.
         * </p>
         * 
         * @param hiddenMlTools
         *        The machine learning tools that are hidden from the Studio left navigation pane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenMlTools(MlTools... hiddenMlTools);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications supported
         * in Studio</a> that are hidden from the Studio left navigation pane.
         * </p>
         * 
         * @param hiddenAppTypes
         *        The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications
         *        supported in Studio</a> that are hidden from the Studio left navigation pane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenAppTypesWithStrings(Collection<String> hiddenAppTypes);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications supported
         * in Studio</a> that are hidden from the Studio left navigation pane.
         * </p>
         * 
         * @param hiddenAppTypes
         *        The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications
         *        supported in Studio</a> that are hidden from the Studio left navigation pane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenAppTypesWithStrings(String... hiddenAppTypes);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications supported
         * in Studio</a> that are hidden from the Studio left navigation pane.
         * </p>
         * 
         * @param hiddenAppTypes
         *        The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications
         *        supported in Studio</a> that are hidden from the Studio left navigation pane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenAppTypes(Collection<AppType> hiddenAppTypes);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications supported
         * in Studio</a> that are hidden from the Studio left navigation pane.
         * </p>
         * 
         * @param hiddenAppTypes
         *        The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications
         *        supported in Studio</a> that are hidden from the Studio left navigation pane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenAppTypes(AppType... hiddenAppTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> hiddenMlTools = DefaultSdkAutoConstructList.getInstance();

        private List<String> hiddenAppTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StudioWebPortalSettings model) {
            hiddenMlToolsWithStrings(model.hiddenMlTools);
            hiddenAppTypesWithStrings(model.hiddenAppTypes);
        }

        public final Collection<String> getHiddenMlTools() {
            if (hiddenMlTools instanceof SdkAutoConstructList) {
                return null;
            }
            return hiddenMlTools;
        }

        public final void setHiddenMlTools(Collection<String> hiddenMlTools) {
            this.hiddenMlTools = HiddenMlToolsListCopier.copy(hiddenMlTools);
        }

        @Override
        public final Builder hiddenMlToolsWithStrings(Collection<String> hiddenMlTools) {
            this.hiddenMlTools = HiddenMlToolsListCopier.copy(hiddenMlTools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenMlToolsWithStrings(String... hiddenMlTools) {
            hiddenMlToolsWithStrings(Arrays.asList(hiddenMlTools));
            return this;
        }

        @Override
        public final Builder hiddenMlTools(Collection<MlTools> hiddenMlTools) {
            this.hiddenMlTools = HiddenMlToolsListCopier.copyEnumToString(hiddenMlTools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenMlTools(MlTools... hiddenMlTools) {
            hiddenMlTools(Arrays.asList(hiddenMlTools));
            return this;
        }

        public final Collection<String> getHiddenAppTypes() {
            if (hiddenAppTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return hiddenAppTypes;
        }

        public final void setHiddenAppTypes(Collection<String> hiddenAppTypes) {
            this.hiddenAppTypes = HiddenAppTypesListCopier.copy(hiddenAppTypes);
        }

        @Override
        public final Builder hiddenAppTypesWithStrings(Collection<String> hiddenAppTypes) {
            this.hiddenAppTypes = HiddenAppTypesListCopier.copy(hiddenAppTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenAppTypesWithStrings(String... hiddenAppTypes) {
            hiddenAppTypesWithStrings(Arrays.asList(hiddenAppTypes));
            return this;
        }

        @Override
        public final Builder hiddenAppTypes(Collection<AppType> hiddenAppTypes) {
            this.hiddenAppTypes = HiddenAppTypesListCopier.copyEnumToString(hiddenAppTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenAppTypes(AppType... hiddenAppTypes) {
            hiddenAppTypes(Arrays.asList(hiddenAppTypes));
            return this;
        }

        @Override
        public StudioWebPortalSettings build() {
            return new StudioWebPortalSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
