/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeClusterSecurityGroupIngressRequest extends RedshiftRequest implements
        ToCopyableBuilder<RevokeClusterSecurityGroupIngressRequest.Builder, RevokeClusterSecurityGroupIngressRequest> {
    private static final SdkField<String> CLUSTER_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSecurityGroupName")
            .getter(getter(RevokeClusterSecurityGroupIngressRequest::clusterSecurityGroupName))
            .setter(setter(Builder::clusterSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroupName").build())
            .build();

    private static final SdkField<String> CIDRIP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CIDRIP")
            .getter(getter(RevokeClusterSecurityGroupIngressRequest::cidrip)).setter(setter(Builder::cidrip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CIDRIP").build()).build();

    private static final SdkField<String> EC2_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2SecurityGroupName").getter(getter(RevokeClusterSecurityGroupIngressRequest::ec2SecurityGroupName))
            .setter(setter(Builder::ec2SecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupName").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2SecurityGroupOwnerId")
            .getter(getter(RevokeClusterSecurityGroupIngressRequest::ec2SecurityGroupOwnerId))
            .setter(setter(Builder::ec2SecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupOwnerId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SECURITY_GROUP_NAME_FIELD, CIDRIP_FIELD, EC2_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_OWNER_ID_FIELD));

    private final String clusterSecurityGroupName;

    private final String cidrip;

    private final String ec2SecurityGroupName;

    private final String ec2SecurityGroupOwnerId;

    private RevokeClusterSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.clusterSecurityGroupName = builder.clusterSecurityGroupName;
        this.cidrip = builder.cidrip;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    /**
     * <p>
     * The name of the security Group from which to revoke the ingress rule.
     * </p>
     * 
     * @return The name of the security Group from which to revoke the ingress rule.
     */
    public final String clusterSecurityGroupName() {
        return clusterSecurityGroupName;
    }

    /**
     * <p>
     * The IP range for which to revoke access. This range must be a valid Classless Inter-Domain Routing (CIDR) block
     * of IP addresses. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code> and
     * <code>EC2SecurityGroupOwnerId</code> cannot be provided.
     * </p>
     * 
     * @return The IP range for which to revoke access. This range must be a valid Classless Inter-Domain Routing (CIDR)
     *         block of IP addresses. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code> and
     *         <code>EC2SecurityGroupOwnerId</code> cannot be provided.
     */
    public final String cidrip() {
        return cidrip;
    }

    /**
     * <p>
     * The name of the EC2 Security Group whose access is to be revoked. If <code>EC2SecurityGroupName</code> is
     * specified, <code>EC2SecurityGroupOwnerId</code> must also be provided and <code>CIDRIP</code> cannot be provided.
     * </p>
     * 
     * @return The name of the EC2 Security Group whose access is to be revoked. If <code>EC2SecurityGroupName</code> is
     *         specified, <code>EC2SecurityGroupOwnerId</code> must also be provided and <code>CIDRIP</code> cannot be
     *         provided.
     */
    public final String ec2SecurityGroupName() {
        return ec2SecurityGroupName;
    }

    /**
     * <p>
     * The Amazon Web Services account number of the owner of the security group specified in the
     * <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID is not an acceptable value. If
     * <code>EC2SecurityGroupOwnerId</code> is specified, <code>EC2SecurityGroupName</code> must also be provided. and
     * <code>CIDRIP</code> cannot be provided.
     * </p>
     * <p>
     * Example: <code>111122223333</code>
     * </p>
     * 
     * @return The Amazon Web Services account number of the owner of the security group specified in the
     *         <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID is not an acceptable
     *         value. If <code>EC2SecurityGroupOwnerId</code> is specified, <code>EC2SecurityGroupName</code> must also
     *         be provided. and <code>CIDRIP</code> cannot be provided. </p>
     *         <p>
     *         Example: <code>111122223333</code>
     */
    public final String ec2SecurityGroupOwnerId() {
        return ec2SecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cidrip());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupOwnerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeClusterSecurityGroupIngressRequest)) {
            return false;
        }
        RevokeClusterSecurityGroupIngressRequest other = (RevokeClusterSecurityGroupIngressRequest) obj;
        return Objects.equals(clusterSecurityGroupName(), other.clusterSecurityGroupName())
                && Objects.equals(cidrip(), other.cidrip())
                && Objects.equals(ec2SecurityGroupName(), other.ec2SecurityGroupName())
                && Objects.equals(ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeClusterSecurityGroupIngressRequest")
                .add("ClusterSecurityGroupName", clusterSecurityGroupName()).add("CIDRIP", cidrip())
                .add("EC2SecurityGroupName", ec2SecurityGroupName()).add("EC2SecurityGroupOwnerId", ec2SecurityGroupOwnerId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSecurityGroupName":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroupName()));
        case "CIDRIP":
            return Optional.ofNullable(clazz.cast(cidrip()));
        case "EC2SecurityGroupName":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupName()));
        case "EC2SecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeClusterSecurityGroupIngressRequest, T> g) {
        return obj -> g.apply((RevokeClusterSecurityGroupIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RevokeClusterSecurityGroupIngressRequest> {
        /**
         * <p>
         * The name of the security Group from which to revoke the ingress rule.
         * </p>
         * 
         * @param clusterSecurityGroupName
         *        The name of the security Group from which to revoke the ingress rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroupName(String clusterSecurityGroupName);

        /**
         * <p>
         * The IP range for which to revoke access. This range must be a valid Classless Inter-Domain Routing (CIDR)
         * block of IP addresses. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code> and
         * <code>EC2SecurityGroupOwnerId</code> cannot be provided.
         * </p>
         * 
         * @param cidrip
         *        The IP range for which to revoke access. This range must be a valid Classless Inter-Domain Routing
         *        (CIDR) block of IP addresses. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code>
         *        and <code>EC2SecurityGroupOwnerId</code> cannot be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrip(String cidrip);

        /**
         * <p>
         * The name of the EC2 Security Group whose access is to be revoked. If <code>EC2SecurityGroupName</code> is
         * specified, <code>EC2SecurityGroupOwnerId</code> must also be provided and <code>CIDRIP</code> cannot be
         * provided.
         * </p>
         * 
         * @param ec2SecurityGroupName
         *        The name of the EC2 Security Group whose access is to be revoked. If <code>EC2SecurityGroupName</code>
         *        is specified, <code>EC2SecurityGroupOwnerId</code> must also be provided and <code>CIDRIP</code>
         *        cannot be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupName(String ec2SecurityGroupName);

        /**
         * <p>
         * The Amazon Web Services account number of the owner of the security group specified in the
         * <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID is not an acceptable
         * value. If <code>EC2SecurityGroupOwnerId</code> is specified, <code>EC2SecurityGroupName</code> must also be
         * provided. and <code>CIDRIP</code> cannot be provided.
         * </p>
         * <p>
         * Example: <code>111122223333</code>
         * </p>
         * 
         * @param ec2SecurityGroupOwnerId
         *        The Amazon Web Services account number of the owner of the security group specified in the
         *        <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID is not an
         *        acceptable value. If <code>EC2SecurityGroupOwnerId</code> is specified,
         *        <code>EC2SecurityGroupName</code> must also be provided. and <code>CIDRIP</code> cannot be provided.
         *        </p>
         *        <p>
         *        Example: <code>111122223333</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterSecurityGroupName;

        private String cidrip;

        private String ec2SecurityGroupName;

        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeClusterSecurityGroupIngressRequest model) {
            super(model);
            clusterSecurityGroupName(model.clusterSecurityGroupName);
            cidrip(model.cidrip);
            ec2SecurityGroupName(model.ec2SecurityGroupName);
            ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getClusterSecurityGroupName() {
            return clusterSecurityGroupName;
        }

        public final void setClusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
        }

        @Override
        public final Builder clusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
            return this;
        }

        public final String getCidrip() {
            return cidrip;
        }

        public final void setCidrip(String cidrip) {
            this.cidrip = cidrip;
        }

        @Override
        public final Builder cidrip(String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        public final String getEc2SecurityGroupName() {
            return ec2SecurityGroupName;
        }

        public final void setEc2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final String getEc2SecurityGroupOwnerId() {
            return ec2SecurityGroupOwnerId;
        }

        public final void setEc2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeClusterSecurityGroupIngressRequest build() {
            return new RevokeClusterSecurityGroupIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
