/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of options that configure how each panel displays in a small multiples chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PanelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PanelConfiguration.Builder, PanelConfiguration> {
    private static final SdkField<PanelTitleOptions> TITLE_FIELD = SdkField.<PanelTitleOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Title").getter(getter(PanelConfiguration::title)).setter(setter(Builder::title))
            .constructor(PanelTitleOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> BORDER_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BorderVisibility").getter(getter(PanelConfiguration::borderVisibilityAsString))
            .setter(setter(Builder::borderVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderVisibility").build()).build();

    private static final SdkField<String> BORDER_THICKNESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BorderThickness").getter(getter(PanelConfiguration::borderThickness))
            .setter(setter(Builder::borderThickness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderThickness").build()).build();

    private static final SdkField<String> BORDER_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BorderStyle").getter(getter(PanelConfiguration::borderStyleAsString))
            .setter(setter(Builder::borderStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderStyle").build()).build();

    private static final SdkField<String> BORDER_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BorderColor").getter(getter(PanelConfiguration::borderColor)).setter(setter(Builder::borderColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderColor").build()).build();

    private static final SdkField<String> GUTTER_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GutterVisibility").getter(getter(PanelConfiguration::gutterVisibilityAsString))
            .setter(setter(Builder::gutterVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GutterVisibility").build()).build();

    private static final SdkField<String> GUTTER_SPACING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GutterSpacing").getter(getter(PanelConfiguration::gutterSpacing)).setter(setter(Builder::gutterSpacing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GutterSpacing").build()).build();

    private static final SdkField<String> BACKGROUND_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackgroundVisibility").getter(getter(PanelConfiguration::backgroundVisibilityAsString))
            .setter(setter(Builder::backgroundVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundVisibility").build())
            .build();

    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackgroundColor").getter(getter(PanelConfiguration::backgroundColor))
            .setter(setter(Builder::backgroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            BORDER_VISIBILITY_FIELD, BORDER_THICKNESS_FIELD, BORDER_STYLE_FIELD, BORDER_COLOR_FIELD, GUTTER_VISIBILITY_FIELD,
            GUTTER_SPACING_FIELD, BACKGROUND_VISIBILITY_FIELD, BACKGROUND_COLOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final PanelTitleOptions title;

    private final String borderVisibility;

    private final String borderThickness;

    private final String borderStyle;

    private final String borderColor;

    private final String gutterVisibility;

    private final String gutterSpacing;

    private final String backgroundVisibility;

    private final String backgroundColor;

    private PanelConfiguration(BuilderImpl builder) {
        this.title = builder.title;
        this.borderVisibility = builder.borderVisibility;
        this.borderThickness = builder.borderThickness;
        this.borderStyle = builder.borderStyle;
        this.borderColor = builder.borderColor;
        this.gutterVisibility = builder.gutterVisibility;
        this.gutterSpacing = builder.gutterSpacing;
        this.backgroundVisibility = builder.backgroundVisibility;
        this.backgroundColor = builder.backgroundColor;
    }

    /**
     * <p>
     * Configures the title display within each small multiples panel.
     * </p>
     * 
     * @return Configures the title display within each small multiples panel.
     */
    public final PanelTitleOptions title() {
        return title;
    }

    /**
     * <p>
     * Determines whether or not each panel displays a border.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #borderVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #borderVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not each panel displays a border.
     * @see Visibility
     */
    public final Visibility borderVisibility() {
        return Visibility.fromValue(borderVisibility);
    }

    /**
     * <p>
     * Determines whether or not each panel displays a border.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #borderVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #borderVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not each panel displays a border.
     * @see Visibility
     */
    public final String borderVisibilityAsString() {
        return borderVisibility;
    }

    /**
     * <p>
     * Sets the line thickness of panel borders.
     * </p>
     * 
     * @return Sets the line thickness of panel borders.
     */
    public final String borderThickness() {
        return borderThickness;
    }

    /**
     * <p>
     * Sets the line style of panel borders.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #borderStyle} will
     * return {@link PanelBorderStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #borderStyleAsString}.
     * </p>
     * 
     * @return Sets the line style of panel borders.
     * @see PanelBorderStyle
     */
    public final PanelBorderStyle borderStyle() {
        return PanelBorderStyle.fromValue(borderStyle);
    }

    /**
     * <p>
     * Sets the line style of panel borders.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #borderStyle} will
     * return {@link PanelBorderStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #borderStyleAsString}.
     * </p>
     * 
     * @return Sets the line style of panel borders.
     * @see PanelBorderStyle
     */
    public final String borderStyleAsString() {
        return borderStyle;
    }

    /**
     * <p>
     * Sets the line color of panel borders.
     * </p>
     * 
     * @return Sets the line color of panel borders.
     */
    public final String borderColor() {
        return borderColor;
    }

    /**
     * <p>
     * Determines whether or not negative space between sibling panels is rendered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gutterVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gutterVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not negative space between sibling panels is rendered.
     * @see Visibility
     */
    public final Visibility gutterVisibility() {
        return Visibility.fromValue(gutterVisibility);
    }

    /**
     * <p>
     * Determines whether or not negative space between sibling panels is rendered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gutterVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gutterVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not negative space between sibling panels is rendered.
     * @see Visibility
     */
    public final String gutterVisibilityAsString() {
        return gutterVisibility;
    }

    /**
     * <p>
     * Sets the total amount of negative space to display between sibling panels.
     * </p>
     * 
     * @return Sets the total amount of negative space to display between sibling panels.
     */
    public final String gutterSpacing() {
        return gutterSpacing;
    }

    /**
     * <p>
     * Determines whether or not a background for each small multiples panel is rendered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #backgroundVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #backgroundVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not a background for each small multiples panel is rendered.
     * @see Visibility
     */
    public final Visibility backgroundVisibility() {
        return Visibility.fromValue(backgroundVisibility);
    }

    /**
     * <p>
     * Determines whether or not a background for each small multiples panel is rendered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #backgroundVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #backgroundVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not a background for each small multiples panel is rendered.
     * @see Visibility
     */
    public final String backgroundVisibilityAsString() {
        return backgroundVisibility;
    }

    /**
     * <p>
     * Sets the background color for each panel.
     * </p>
     * 
     * @return Sets the background color for each panel.
     */
    public final String backgroundColor() {
        return backgroundColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(borderVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(borderThickness());
        hashCode = 31 * hashCode + Objects.hashCode(borderStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(borderColor());
        hashCode = 31 * hashCode + Objects.hashCode(gutterVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gutterSpacing());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PanelConfiguration)) {
            return false;
        }
        PanelConfiguration other = (PanelConfiguration) obj;
        return Objects.equals(title(), other.title())
                && Objects.equals(borderVisibilityAsString(), other.borderVisibilityAsString())
                && Objects.equals(borderThickness(), other.borderThickness())
                && Objects.equals(borderStyleAsString(), other.borderStyleAsString())
                && Objects.equals(borderColor(), other.borderColor())
                && Objects.equals(gutterVisibilityAsString(), other.gutterVisibilityAsString())
                && Objects.equals(gutterSpacing(), other.gutterSpacing())
                && Objects.equals(backgroundVisibilityAsString(), other.backgroundVisibilityAsString())
                && Objects.equals(backgroundColor(), other.backgroundColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PanelConfiguration").add("Title", title()).add("BorderVisibility", borderVisibilityAsString())
                .add("BorderThickness", borderThickness()).add("BorderStyle", borderStyleAsString())
                .add("BorderColor", borderColor()).add("GutterVisibility", gutterVisibilityAsString())
                .add("GutterSpacing", gutterSpacing()).add("BackgroundVisibility", backgroundVisibilityAsString())
                .add("BackgroundColor", backgroundColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "BorderVisibility":
            return Optional.ofNullable(clazz.cast(borderVisibilityAsString()));
        case "BorderThickness":
            return Optional.ofNullable(clazz.cast(borderThickness()));
        case "BorderStyle":
            return Optional.ofNullable(clazz.cast(borderStyleAsString()));
        case "BorderColor":
            return Optional.ofNullable(clazz.cast(borderColor()));
        case "GutterVisibility":
            return Optional.ofNullable(clazz.cast(gutterVisibilityAsString()));
        case "GutterSpacing":
            return Optional.ofNullable(clazz.cast(gutterSpacing()));
        case "BackgroundVisibility":
            return Optional.ofNullable(clazz.cast(backgroundVisibilityAsString()));
        case "BackgroundColor":
            return Optional.ofNullable(clazz.cast(backgroundColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PanelConfiguration, T> g) {
        return obj -> g.apply((PanelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PanelConfiguration> {
        /**
         * <p>
         * Configures the title display within each small multiples panel.
         * </p>
         * 
         * @param title
         *        Configures the title display within each small multiples panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(PanelTitleOptions title);

        /**
         * <p>
         * Configures the title display within each small multiples panel.
         * </p>
         * This is a convenience method that creates an instance of the {@link PanelTitleOptions.Builder} avoiding the
         * need to create one manually via {@link PanelTitleOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PanelTitleOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #title(PanelTitleOptions)}.
         * 
         * @param title
         *        a consumer that will call methods on {@link PanelTitleOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(PanelTitleOptions)
         */
        default Builder title(Consumer<PanelTitleOptions.Builder> title) {
            return title(PanelTitleOptions.builder().applyMutation(title).build());
        }

        /**
         * <p>
         * Determines whether or not each panel displays a border.
         * </p>
         * 
         * @param borderVisibility
         *        Determines whether or not each panel displays a border.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder borderVisibility(String borderVisibility);

        /**
         * <p>
         * Determines whether or not each panel displays a border.
         * </p>
         * 
         * @param borderVisibility
         *        Determines whether or not each panel displays a border.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder borderVisibility(Visibility borderVisibility);

        /**
         * <p>
         * Sets the line thickness of panel borders.
         * </p>
         * 
         * @param borderThickness
         *        Sets the line thickness of panel borders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder borderThickness(String borderThickness);

        /**
         * <p>
         * Sets the line style of panel borders.
         * </p>
         * 
         * @param borderStyle
         *        Sets the line style of panel borders.
         * @see PanelBorderStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PanelBorderStyle
         */
        Builder borderStyle(String borderStyle);

        /**
         * <p>
         * Sets the line style of panel borders.
         * </p>
         * 
         * @param borderStyle
         *        Sets the line style of panel borders.
         * @see PanelBorderStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PanelBorderStyle
         */
        Builder borderStyle(PanelBorderStyle borderStyle);

        /**
         * <p>
         * Sets the line color of panel borders.
         * </p>
         * 
         * @param borderColor
         *        Sets the line color of panel borders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder borderColor(String borderColor);

        /**
         * <p>
         * Determines whether or not negative space between sibling panels is rendered.
         * </p>
         * 
         * @param gutterVisibility
         *        Determines whether or not negative space between sibling panels is rendered.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder gutterVisibility(String gutterVisibility);

        /**
         * <p>
         * Determines whether or not negative space between sibling panels is rendered.
         * </p>
         * 
         * @param gutterVisibility
         *        Determines whether or not negative space between sibling panels is rendered.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder gutterVisibility(Visibility gutterVisibility);

        /**
         * <p>
         * Sets the total amount of negative space to display between sibling panels.
         * </p>
         * 
         * @param gutterSpacing
         *        Sets the total amount of negative space to display between sibling panels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gutterSpacing(String gutterSpacing);

        /**
         * <p>
         * Determines whether or not a background for each small multiples panel is rendered.
         * </p>
         * 
         * @param backgroundVisibility
         *        Determines whether or not a background for each small multiples panel is rendered.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder backgroundVisibility(String backgroundVisibility);

        /**
         * <p>
         * Determines whether or not a background for each small multiples panel is rendered.
         * </p>
         * 
         * @param backgroundVisibility
         *        Determines whether or not a background for each small multiples panel is rendered.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder backgroundVisibility(Visibility backgroundVisibility);

        /**
         * <p>
         * Sets the background color for each panel.
         * </p>
         * 
         * @param backgroundColor
         *        Sets the background color for each panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundColor(String backgroundColor);
    }

    static final class BuilderImpl implements Builder {
        private PanelTitleOptions title;

        private String borderVisibility;

        private String borderThickness;

        private String borderStyle;

        private String borderColor;

        private String gutterVisibility;

        private String gutterSpacing;

        private String backgroundVisibility;

        private String backgroundColor;

        private BuilderImpl() {
        }

        private BuilderImpl(PanelConfiguration model) {
            title(model.title);
            borderVisibility(model.borderVisibility);
            borderThickness(model.borderThickness);
            borderStyle(model.borderStyle);
            borderColor(model.borderColor);
            gutterVisibility(model.gutterVisibility);
            gutterSpacing(model.gutterSpacing);
            backgroundVisibility(model.backgroundVisibility);
            backgroundColor(model.backgroundColor);
        }

        public final PanelTitleOptions.Builder getTitle() {
            return title != null ? title.toBuilder() : null;
        }

        public final void setTitle(PanelTitleOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(PanelTitleOptions title) {
            this.title = title;
            return this;
        }

        public final String getBorderVisibility() {
            return borderVisibility;
        }

        public final void setBorderVisibility(String borderVisibility) {
            this.borderVisibility = borderVisibility;
        }

        @Override
        public final Builder borderVisibility(String borderVisibility) {
            this.borderVisibility = borderVisibility;
            return this;
        }

        @Override
        public final Builder borderVisibility(Visibility borderVisibility) {
            this.borderVisibility(borderVisibility == null ? null : borderVisibility.toString());
            return this;
        }

        public final String getBorderThickness() {
            return borderThickness;
        }

        public final void setBorderThickness(String borderThickness) {
            this.borderThickness = borderThickness;
        }

        @Override
        public final Builder borderThickness(String borderThickness) {
            this.borderThickness = borderThickness;
            return this;
        }

        public final String getBorderStyle() {
            return borderStyle;
        }

        public final void setBorderStyle(String borderStyle) {
            this.borderStyle = borderStyle;
        }

        @Override
        public final Builder borderStyle(String borderStyle) {
            this.borderStyle = borderStyle;
            return this;
        }

        @Override
        public final Builder borderStyle(PanelBorderStyle borderStyle) {
            this.borderStyle(borderStyle == null ? null : borderStyle.toString());
            return this;
        }

        public final String getBorderColor() {
            return borderColor;
        }

        public final void setBorderColor(String borderColor) {
            this.borderColor = borderColor;
        }

        @Override
        public final Builder borderColor(String borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public final String getGutterVisibility() {
            return gutterVisibility;
        }

        public final void setGutterVisibility(String gutterVisibility) {
            this.gutterVisibility = gutterVisibility;
        }

        @Override
        public final Builder gutterVisibility(String gutterVisibility) {
            this.gutterVisibility = gutterVisibility;
            return this;
        }

        @Override
        public final Builder gutterVisibility(Visibility gutterVisibility) {
            this.gutterVisibility(gutterVisibility == null ? null : gutterVisibility.toString());
            return this;
        }

        public final String getGutterSpacing() {
            return gutterSpacing;
        }

        public final void setGutterSpacing(String gutterSpacing) {
            this.gutterSpacing = gutterSpacing;
        }

        @Override
        public final Builder gutterSpacing(String gutterSpacing) {
            this.gutterSpacing = gutterSpacing;
            return this;
        }

        public final String getBackgroundVisibility() {
            return backgroundVisibility;
        }

        public final void setBackgroundVisibility(String backgroundVisibility) {
            this.backgroundVisibility = backgroundVisibility;
        }

        @Override
        public final Builder backgroundVisibility(String backgroundVisibility) {
            this.backgroundVisibility = backgroundVisibility;
            return this;
        }

        @Override
        public final Builder backgroundVisibility(Visibility backgroundVisibility) {
            this.backgroundVisibility(backgroundVisibility == null ? null : backgroundVisibility.toString());
            return this;
        }

        public final String getBackgroundColor() {
            return backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public PanelConfiguration build() {
            return new PanelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
