/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamedEntityDefinitionMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<NamedEntityDefinitionMetric.Builder, NamedEntityDefinitionMetric> {
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Aggregation").getter(getter(NamedEntityDefinitionMetric::aggregationAsString))
            .setter(setter(Builder::aggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()).build();

    private static final SdkField<Map<String, String>> AGGREGATION_FUNCTION_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AggregationFunctionParameters")
            .getter(getter(NamedEntityDefinitionMetric::aggregationFunctionParameters))
            .setter(setter(Builder::aggregationFunctionParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunctionParameters")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_FIELD,
            AGGREGATION_FUNCTION_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aggregation;

    private final Map<String, String> aggregationFunctionParameters;

    private NamedEntityDefinitionMetric(BuilderImpl builder) {
        this.aggregation = builder.aggregation;
        this.aggregationFunctionParameters = builder.aggregationFunctionParameters;
    }

    /**
     * <p>
     * The aggregation of a named entity. Valid values for this structure are <code>SUM</code>, <code>MIN</code>,
     * <code>MAX</code>, <code>COUNT</code>, <code>AVERAGE</code>, <code>DISTINCT_COUNT</code>, <code>STDEV</code>,
     * <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, <code>PERCENTILE</code>, <code>MEDIAN</code>, and
     * <code>CUSTOM</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link NamedEntityAggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The aggregation of a named entity. Valid values for this structure are <code>SUM</code>, <code>MIN</code>
     *         , <code>MAX</code>, <code>COUNT</code>, <code>AVERAGE</code>, <code>DISTINCT_COUNT</code>,
     *         <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, <code>PERCENTILE</code>,
     *         <code>MEDIAN</code>, and <code>CUSTOM</code>.
     * @see NamedEntityAggType
     */
    public final NamedEntityAggType aggregation() {
        return NamedEntityAggType.fromValue(aggregation);
    }

    /**
     * <p>
     * The aggregation of a named entity. Valid values for this structure are <code>SUM</code>, <code>MIN</code>,
     * <code>MAX</code>, <code>COUNT</code>, <code>AVERAGE</code>, <code>DISTINCT_COUNT</code>, <code>STDEV</code>,
     * <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, <code>PERCENTILE</code>, <code>MEDIAN</code>, and
     * <code>CUSTOM</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link NamedEntityAggType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The aggregation of a named entity. Valid values for this structure are <code>SUM</code>, <code>MIN</code>
     *         , <code>MAX</code>, <code>COUNT</code>, <code>AVERAGE</code>, <code>DISTINCT_COUNT</code>,
     *         <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, <code>PERCENTILE</code>,
     *         <code>MEDIAN</code>, and <code>CUSTOM</code>.
     * @see NamedEntityAggType
     */
    public final String aggregationAsString() {
        return aggregation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregationFunctionParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAggregationFunctionParameters() {
        return aggregationFunctionParameters != null && !(aggregationFunctionParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The additional parameters for an aggregation function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregationFunctionParameters} method.
     * </p>
     * 
     * @return The additional parameters for an aggregation function.
     */
    public final Map<String, String> aggregationFunctionParameters() {
        return aggregationFunctionParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregationFunctionParameters() ? aggregationFunctionParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedEntityDefinitionMetric)) {
            return false;
        }
        NamedEntityDefinitionMetric other = (NamedEntityDefinitionMetric) obj;
        return Objects.equals(aggregationAsString(), other.aggregationAsString())
                && hasAggregationFunctionParameters() == other.hasAggregationFunctionParameters()
                && Objects.equals(aggregationFunctionParameters(), other.aggregationFunctionParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("NamedEntityDefinitionMetric")
                .add("Aggregation", aggregationAsString())
                .add("AggregationFunctionParameters", hasAggregationFunctionParameters() ? aggregationFunctionParameters() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsString()));
        case "AggregationFunctionParameters":
            return Optional.ofNullable(clazz.cast(aggregationFunctionParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamedEntityDefinitionMetric, T> g) {
        return obj -> g.apply((NamedEntityDefinitionMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NamedEntityDefinitionMetric> {
        /**
         * <p>
         * The aggregation of a named entity. Valid values for this structure are <code>SUM</code>, <code>MIN</code>,
         * <code>MAX</code>, <code>COUNT</code>, <code>AVERAGE</code>, <code>DISTINCT_COUNT</code>, <code>STDEV</code>,
         * <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, <code>PERCENTILE</code>, <code>MEDIAN</code>, and
         * <code>CUSTOM</code>.
         * </p>
         * 
         * @param aggregation
         *        The aggregation of a named entity. Valid values for this structure are <code>SUM</code>,
         *        <code>MIN</code>, <code>MAX</code>, <code>COUNT</code>, <code>AVERAGE</code>,
         *        <code>DISTINCT_COUNT</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         *        <code>VARP</code>, <code>PERCENTILE</code>, <code>MEDIAN</code>, and <code>CUSTOM</code>.
         * @see NamedEntityAggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamedEntityAggType
         */
        Builder aggregation(String aggregation);

        /**
         * <p>
         * The aggregation of a named entity. Valid values for this structure are <code>SUM</code>, <code>MIN</code>,
         * <code>MAX</code>, <code>COUNT</code>, <code>AVERAGE</code>, <code>DISTINCT_COUNT</code>, <code>STDEV</code>,
         * <code>STDEVP</code>, <code>VAR</code>, <code>VARP</code>, <code>PERCENTILE</code>, <code>MEDIAN</code>, and
         * <code>CUSTOM</code>.
         * </p>
         * 
         * @param aggregation
         *        The aggregation of a named entity. Valid values for this structure are <code>SUM</code>,
         *        <code>MIN</code>, <code>MAX</code>, <code>COUNT</code>, <code>AVERAGE</code>,
         *        <code>DISTINCT_COUNT</code>, <code>STDEV</code>, <code>STDEVP</code>, <code>VAR</code>,
         *        <code>VARP</code>, <code>PERCENTILE</code>, <code>MEDIAN</code>, and <code>CUSTOM</code>.
         * @see NamedEntityAggType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamedEntityAggType
         */
        Builder aggregation(NamedEntityAggType aggregation);

        /**
         * <p>
         * The additional parameters for an aggregation function.
         * </p>
         * 
         * @param aggregationFunctionParameters
         *        The additional parameters for an aggregation function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunctionParameters(Map<String, String> aggregationFunctionParameters);
    }

    static final class BuilderImpl implements Builder {
        private String aggregation;

        private Map<String, String> aggregationFunctionParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NamedEntityDefinitionMetric model) {
            aggregation(model.aggregation);
            aggregationFunctionParameters(model.aggregationFunctionParameters);
        }

        public final String getAggregation() {
            return aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(NamedEntityAggType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final Map<String, String> getAggregationFunctionParameters() {
            if (aggregationFunctionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return aggregationFunctionParameters;
        }

        public final void setAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggregationFunctionParametersCopier.copy(aggregationFunctionParameters);
        }

        @Override
        public final Builder aggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggregationFunctionParametersCopier.copy(aggregationFunctionParameters);
            return this;
        }

        @Override
        public NamedEntityDefinitionMetric build() {
            return new NamedEntityDefinitionMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
