/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for an IAM Identity Center configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityCenterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityCenterConfiguration.Builder, IdentityCenterConfiguration> {
    private static final SdkField<Boolean> ENABLE_IDENTITY_PROPAGATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnableIdentityPropagation")
            .getter(getter(IdentityCenterConfiguration::enableIdentityPropagation))
            .setter(setter(Builder::enableIdentityPropagation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIdentityPropagation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLE_IDENTITY_PROPAGATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableIdentityPropagation;

    private IdentityCenterConfiguration(BuilderImpl builder) {
        this.enableIdentityPropagation = builder.enableIdentityPropagation;
    }

    /**
     * <p>
     * A Boolean option that controls whether Trusted Identity Propagation should be used.
     * </p>
     * 
     * @return A Boolean option that controls whether Trusted Identity Propagation should be used.
     */
    public final Boolean enableIdentityPropagation() {
        return enableIdentityPropagation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableIdentityPropagation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityCenterConfiguration)) {
            return false;
        }
        IdentityCenterConfiguration other = (IdentityCenterConfiguration) obj;
        return Objects.equals(enableIdentityPropagation(), other.enableIdentityPropagation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityCenterConfiguration").add("EnableIdentityPropagation", enableIdentityPropagation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableIdentityPropagation":
            return Optional.ofNullable(clazz.cast(enableIdentityPropagation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityCenterConfiguration, T> g) {
        return obj -> g.apply((IdentityCenterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityCenterConfiguration> {
        /**
         * <p>
         * A Boolean option that controls whether Trusted Identity Propagation should be used.
         * </p>
         * 
         * @param enableIdentityPropagation
         *        A Boolean option that controls whether Trusted Identity Propagation should be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIdentityPropagation(Boolean enableIdentityPropagation);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableIdentityPropagation;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityCenterConfiguration model) {
            enableIdentityPropagation(model.enableIdentityPropagation);
        }

        public final Boolean getEnableIdentityPropagation() {
            return enableIdentityPropagation;
        }

        public final void setEnableIdentityPropagation(Boolean enableIdentityPropagation) {
            this.enableIdentityPropagation = enableIdentityPropagation;
        }

        @Override
        public final Builder enableIdentityPropagation(Boolean enableIdentityPropagation) {
            this.enableIdentityPropagation = enableIdentityPropagation;
            return this;
        }

        @Override
        public IdentityCenterConfiguration build() {
            return new IdentityCenterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
