/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The color configuration of a <code>GaugeChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GaugeChartColorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GaugeChartColorConfiguration.Builder, GaugeChartColorConfiguration> {
    private static final SdkField<String> FOREGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForegroundColor").getter(getter(GaugeChartColorConfiguration::foregroundColor))
            .setter(setter(Builder::foregroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForegroundColor").build()).build();

    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackgroundColor").getter(getter(GaugeChartColorConfiguration::backgroundColor))
            .setter(setter(Builder::backgroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOREGROUND_COLOR_FIELD,
            BACKGROUND_COLOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String foregroundColor;

    private final String backgroundColor;

    private GaugeChartColorConfiguration(BuilderImpl builder) {
        this.foregroundColor = builder.foregroundColor;
        this.backgroundColor = builder.backgroundColor;
    }

    /**
     * <p>
     * The foreground color configuration of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The foreground color configuration of a <code>GaugeChartVisual</code>.
     */
    public final String foregroundColor() {
        return foregroundColor;
    }

    /**
     * <p>
     * The background color configuration of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The background color configuration of a <code>GaugeChartVisual</code>.
     */
    public final String backgroundColor() {
        return backgroundColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(foregroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GaugeChartColorConfiguration)) {
            return false;
        }
        GaugeChartColorConfiguration other = (GaugeChartColorConfiguration) obj;
        return Objects.equals(foregroundColor(), other.foregroundColor())
                && Objects.equals(backgroundColor(), other.backgroundColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GaugeChartColorConfiguration").add("ForegroundColor", foregroundColor())
                .add("BackgroundColor", backgroundColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForegroundColor":
            return Optional.ofNullable(clazz.cast(foregroundColor()));
        case "BackgroundColor":
            return Optional.ofNullable(clazz.cast(backgroundColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GaugeChartColorConfiguration, T> g) {
        return obj -> g.apply((GaugeChartColorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GaugeChartColorConfiguration> {
        /**
         * <p>
         * The foreground color configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param foregroundColor
         *        The foreground color configuration of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foregroundColor(String foregroundColor);

        /**
         * <p>
         * The background color configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param backgroundColor
         *        The background color configuration of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundColor(String backgroundColor);
    }

    static final class BuilderImpl implements Builder {
        private String foregroundColor;

        private String backgroundColor;

        private BuilderImpl() {
        }

        private BuilderImpl(GaugeChartColorConfiguration model) {
            foregroundColor(model.foregroundColor);
            backgroundColor(model.backgroundColor);
        }

        public final String getForegroundColor() {
            return foregroundColor;
        }

        public final void setForegroundColor(String foregroundColor) {
            this.foregroundColor = foregroundColor;
        }

        @Override
        public final Builder foregroundColor(String foregroundColor) {
            this.foregroundColor = foregroundColor;
            return this;
        }

        public final String getBackgroundColor() {
            return backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public GaugeChartColorConfiguration build() {
            return new GaugeChartColorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
