/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a <code>BarChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BarChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BarChartConfiguration.Builder, BarChartConfiguration> {
    private static final SdkField<BarChartFieldWells> FIELD_WELLS_FIELD = SdkField
            .<BarChartFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(BarChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(BarChartFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<BarChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<BarChartSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(BarChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(BarChartSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<String> ORIENTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Orientation").getter(getter(BarChartConfiguration::orientationAsString))
            .setter(setter(Builder::orientation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orientation").build()).build();

    private static final SdkField<String> BARS_ARRANGEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BarsArrangement").getter(getter(BarChartConfiguration::barsArrangementAsString))
            .setter(setter(Builder::barsArrangement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarsArrangement").build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(BarChartConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final SdkField<SmallMultiplesOptions> SMALL_MULTIPLES_OPTIONS_FIELD = SdkField
            .<SmallMultiplesOptions> builder(MarshallingType.SDK_POJO).memberName("SmallMultiplesOptions")
            .getter(getter(BarChartConfiguration::smallMultiplesOptions)).setter(setter(Builder::smallMultiplesOptions))
            .constructor(SmallMultiplesOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesOptions").build())
            .build();

    private static final SdkField<AxisDisplayOptions> CATEGORY_AXIS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryAxis")
            .getter(getter(BarChartConfiguration::categoryAxis)).setter(setter(Builder::categoryAxis))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxis").build()).build();

    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryLabelOptions")
            .getter(getter(BarChartConfiguration::categoryLabelOptions)).setter(setter(Builder::categoryLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build())
            .build();

    private static final SdkField<AxisDisplayOptions> VALUE_AXIS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("ValueAxis")
            .getter(getter(BarChartConfiguration::valueAxis)).setter(setter(Builder::valueAxis))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueAxis").build()).build();

    private static final SdkField<ChartAxisLabelOptions> VALUE_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("ValueLabelOptions")
            .getter(getter(BarChartConfiguration::valueLabelOptions)).setter(setter(Builder::valueLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLabelOptions").build()).build();

    private static final SdkField<ChartAxisLabelOptions> COLOR_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("ColorLabelOptions")
            .getter(getter(BarChartConfiguration::colorLabelOptions)).setter(setter(Builder::colorLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorLabelOptions").build()).build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(BarChartConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(BarChartConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(BarChartConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<List<ReferenceLine>> REFERENCE_LINES_FIELD = SdkField
            .<List<ReferenceLine>> builder(MarshallingType.LIST)
            .memberName("ReferenceLines")
            .getter(getter(BarChartConfiguration::referenceLines))
            .setter(setter(Builder::referenceLines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReferenceLine> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReferenceLine::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContributionAnalysisDefault>> CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD = SdkField
            .<List<ContributionAnalysisDefault>> builder(MarshallingType.LIST)
            .memberName("ContributionAnalysisDefaults")
            .getter(getter(BarChartConfiguration::contributionAnalysisDefaults))
            .setter(setter(Builder::contributionAnalysisDefaults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionAnalysisDefaults")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContributionAnalysisDefault> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContributionAnalysisDefault::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(BarChartConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, ORIENTATION_FIELD, BARS_ARRANGEMENT_FIELD, VISUAL_PALETTE_FIELD,
            SMALL_MULTIPLES_OPTIONS_FIELD, CATEGORY_AXIS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, VALUE_AXIS_FIELD,
            VALUE_LABEL_OPTIONS_FIELD, COLOR_LABEL_OPTIONS_FIELD, LEGEND_FIELD, DATA_LABELS_FIELD, TOOLTIP_FIELD,
            REFERENCE_LINES_FIELD, CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD, INTERACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final BarChartFieldWells fieldWells;

    private final BarChartSortConfiguration sortConfiguration;

    private final String orientation;

    private final String barsArrangement;

    private final VisualPalette visualPalette;

    private final SmallMultiplesOptions smallMultiplesOptions;

    private final AxisDisplayOptions categoryAxis;

    private final ChartAxisLabelOptions categoryLabelOptions;

    private final AxisDisplayOptions valueAxis;

    private final ChartAxisLabelOptions valueLabelOptions;

    private final ChartAxisLabelOptions colorLabelOptions;

    private final LegendOptions legend;

    private final DataLabelOptions dataLabels;

    private final TooltipOptions tooltip;

    private final List<ReferenceLine> referenceLines;

    private final List<ContributionAnalysisDefault> contributionAnalysisDefaults;

    private final VisualInteractionOptions interactions;

    private BarChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.orientation = builder.orientation;
        this.barsArrangement = builder.barsArrangement;
        this.visualPalette = builder.visualPalette;
        this.smallMultiplesOptions = builder.smallMultiplesOptions;
        this.categoryAxis = builder.categoryAxis;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.valueAxis = builder.valueAxis;
        this.valueLabelOptions = builder.valueLabelOptions;
        this.colorLabelOptions = builder.colorLabelOptions;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.tooltip = builder.tooltip;
        this.referenceLines = builder.referenceLines;
        this.contributionAnalysisDefaults = builder.contributionAnalysisDefaults;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final BarChartFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a <code>BarChartVisual</code>.
     * </p>
     * 
     * @return The sort configuration of a <code>BarChartVisual</code>.
     */
    public final BarChartSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The orientation of the bars in a bar chart visual. There are two valid values in this structure:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HORIZONTAL</code>: Used for charts that have horizontal bars. Visuals that use this value are horizontal
     * bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERTICAL</code>: Used for charts that have vertical bars. Visuals that use this value are vertical bar
     * charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orientation} will
     * return {@link BarChartOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orientationAsString}.
     * </p>
     * 
     * @return The orientation of the bars in a bar chart visual. There are two valid values in this structure:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HORIZONTAL</code>: Used for charts that have horizontal bars. Visuals that use this value are
     *         horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERTICAL</code>: Used for charts that have vertical bars. Visuals that use this value are vertical
     *         bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
     *         </p>
     *         </li>
     * @see BarChartOrientation
     */
    public final BarChartOrientation orientation() {
        return BarChartOrientation.fromValue(orientation);
    }

    /**
     * <p>
     * The orientation of the bars in a bar chart visual. There are two valid values in this structure:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HORIZONTAL</code>: Used for charts that have horizontal bars. Visuals that use this value are horizontal
     * bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERTICAL</code>: Used for charts that have vertical bars. Visuals that use this value are vertical bar
     * charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orientation} will
     * return {@link BarChartOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orientationAsString}.
     * </p>
     * 
     * @return The orientation of the bars in a bar chart visual. There are two valid values in this structure:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HORIZONTAL</code>: Used for charts that have horizontal bars. Visuals that use this value are
     *         horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERTICAL</code>: Used for charts that have vertical bars. Visuals that use this value are vertical
     *         bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
     *         </p>
     *         </li>
     * @see BarChartOrientation
     */
    public final String orientationAsString() {
        return orientation;
    }

    /**
     * <p>
     * Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of bar that is
     * used in the visual.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #barsArrangement}
     * will return {@link BarsArrangement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #barsArrangementAsString}.
     * </p>
     * 
     * @return Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of bar
     *         that is used in the visual.
     * @see BarsArrangement
     */
    public final BarsArrangement barsArrangement() {
        return BarsArrangement.fromValue(barsArrangement);
    }

    /**
     * <p>
     * Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of bar that is
     * used in the visual.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #barsArrangement}
     * will return {@link BarsArrangement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #barsArrangementAsString}.
     * </p>
     * 
     * @return Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of bar
     *         that is used in the visual.
     * @see BarsArrangement
     */
    public final String barsArrangementAsString() {
        return barsArrangement;
    }

    /**
     * <p>
     * The palette (chart color) display setup of the visual.
     * </p>
     * 
     * @return The palette (chart color) display setup of the visual.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    /**
     * <p>
     * The small multiples setup for the visual.
     * </p>
     * 
     * @return The small multiples setup for the visual.
     */
    public final SmallMultiplesOptions smallMultiplesOptions() {
        return smallMultiplesOptions;
    }

    /**
     * <p>
     * The label display options (grid line, range, scale, axis step) for bar chart category.
     * </p>
     * 
     * @return The label display options (grid line, range, scale, axis step) for bar chart category.
     */
    public final AxisDisplayOptions categoryAxis() {
        return categoryAxis;
    }

    /**
     * <p>
     * The label options (label text, label visibility and sort icon visibility) for a bar chart.
     * </p>
     * 
     * @return The label options (label text, label visibility and sort icon visibility) for a bar chart.
     */
    public final ChartAxisLabelOptions categoryLabelOptions() {
        return categoryLabelOptions;
    }

    /**
     * <p>
     * The label display options (grid line, range, scale, axis step) for a bar chart value.
     * </p>
     * 
     * @return The label display options (grid line, range, scale, axis step) for a bar chart value.
     */
    public final AxisDisplayOptions valueAxis() {
        return valueAxis;
    }

    /**
     * <p>
     * The label options (label text, label visibility and sort icon visibility) for a bar chart value.
     * </p>
     * 
     * @return The label options (label text, label visibility and sort icon visibility) for a bar chart value.
     */
    public final ChartAxisLabelOptions valueLabelOptions() {
        return valueLabelOptions;
    }

    /**
     * <p>
     * The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar
     * chart.
     * </p>
     * 
     * @return The label options (label text, label visibility and sort icon visibility) for a color that is used in a
     *         bar chart.
     */
    public final ChartAxisLabelOptions colorLabelOptions() {
        return colorLabelOptions;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The options that determine if visual data labels are displayed.
     * </p>
     * 
     * @return The options that determine if visual data labels are displayed.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * <p>
     * The tooltip display setup of the visual.
     * </p>
     * 
     * @return The tooltip display setup of the visual.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceLines property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceLines() {
        return referenceLines != null && !(referenceLines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reference line setup of the visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceLines} method.
     * </p>
     * 
     * @return The reference line setup of the visual.
     */
    public final List<ReferenceLine> referenceLines() {
        return referenceLines;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContributionAnalysisDefaults property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContributionAnalysisDefaults() {
        return contributionAnalysisDefaults != null && !(contributionAnalysisDefaults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contribution analysis (anomaly configuration) setup of the visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContributionAnalysisDefaults} method.
     * </p>
     * 
     * @return The contribution analysis (anomaly configuration) setup of the visual.
     */
    public final List<ContributionAnalysisDefault> contributionAnalysisDefaults() {
        return contributionAnalysisDefaults;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(orientationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(barsArrangementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(smallMultiplesOptions());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAxis());
        hashCode = 31 * hashCode + Objects.hashCode(categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(valueAxis());
        hashCode = 31 * hashCode + Objects.hashCode(valueLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(colorLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceLines() ? referenceLines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContributionAnalysisDefaults() ? contributionAnalysisDefaults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BarChartConfiguration)) {
            return false;
        }
        BarChartConfiguration other = (BarChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(orientationAsString(), other.orientationAsString())
                && Objects.equals(barsArrangementAsString(), other.barsArrangementAsString())
                && Objects.equals(visualPalette(), other.visualPalette())
                && Objects.equals(smallMultiplesOptions(), other.smallMultiplesOptions())
                && Objects.equals(categoryAxis(), other.categoryAxis())
                && Objects.equals(categoryLabelOptions(), other.categoryLabelOptions())
                && Objects.equals(valueAxis(), other.valueAxis())
                && Objects.equals(valueLabelOptions(), other.valueLabelOptions())
                && Objects.equals(colorLabelOptions(), other.colorLabelOptions()) && Objects.equals(legend(), other.legend())
                && Objects.equals(dataLabels(), other.dataLabels()) && Objects.equals(tooltip(), other.tooltip())
                && hasReferenceLines() == other.hasReferenceLines() && Objects.equals(referenceLines(), other.referenceLines())
                && hasContributionAnalysisDefaults() == other.hasContributionAnalysisDefaults()
                && Objects.equals(contributionAnalysisDefaults(), other.contributionAnalysisDefaults())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BarChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("Orientation", orientationAsString())
                .add("BarsArrangement", barsArrangementAsString()).add("VisualPalette", visualPalette())
                .add("SmallMultiplesOptions", smallMultiplesOptions()).add("CategoryAxis", categoryAxis())
                .add("CategoryLabelOptions", categoryLabelOptions()).add("ValueAxis", valueAxis())
                .add("ValueLabelOptions", valueLabelOptions()).add("ColorLabelOptions", colorLabelOptions())
                .add("Legend", legend()).add("DataLabels", dataLabels()).add("Tooltip", tooltip())
                .add("ReferenceLines", hasReferenceLines() ? referenceLines() : null)
                .add("ContributionAnalysisDefaults", hasContributionAnalysisDefaults() ? contributionAnalysisDefaults() : null)
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "Orientation":
            return Optional.ofNullable(clazz.cast(orientationAsString()));
        case "BarsArrangement":
            return Optional.ofNullable(clazz.cast(barsArrangementAsString()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        case "SmallMultiplesOptions":
            return Optional.ofNullable(clazz.cast(smallMultiplesOptions()));
        case "CategoryAxis":
            return Optional.ofNullable(clazz.cast(categoryAxis()));
        case "CategoryLabelOptions":
            return Optional.ofNullable(clazz.cast(categoryLabelOptions()));
        case "ValueAxis":
            return Optional.ofNullable(clazz.cast(valueAxis()));
        case "ValueLabelOptions":
            return Optional.ofNullable(clazz.cast(valueLabelOptions()));
        case "ColorLabelOptions":
            return Optional.ofNullable(clazz.cast(colorLabelOptions()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "ReferenceLines":
            return Optional.ofNullable(clazz.cast(referenceLines()));
        case "ContributionAnalysisDefaults":
            return Optional.ofNullable(clazz.cast(contributionAnalysisDefaults()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BarChartConfiguration, T> g) {
        return obj -> g.apply((BarChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BarChartConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(BarChartFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link BarChartFieldWells.Builder} avoiding the
         * need to create one manually via {@link BarChartFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BarChartFieldWells.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldWells(BarChartFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link BarChartFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(BarChartFieldWells)
         */
        default Builder fieldWells(Consumer<BarChartFieldWells.Builder> fieldWells) {
            return fieldWells(BarChartFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a <code>BarChartVisual</code>.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a <code>BarChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(BarChartSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a <code>BarChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BarChartSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link BarChartSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BarChartSortConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sortConfiguration(BarChartSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link BarChartSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(BarChartSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<BarChartSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(BarChartSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The orientation of the bars in a bar chart visual. There are two valid values in this structure:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HORIZONTAL</code>: Used for charts that have horizontal bars. Visuals that use this value are
         * horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERTICAL</code>: Used for charts that have vertical bars. Visuals that use this value are vertical bar
         * charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
         * </p>
         * </li>
         * </ul>
         * 
         * @param orientation
         *        The orientation of the bars in a bar chart visual. There are two valid values in this structure:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HORIZONTAL</code>: Used for charts that have horizontal bars. Visuals that use this value are
         *        horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERTICAL</code>: Used for charts that have vertical bars. Visuals that use this value are
         *        vertical bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
         *        </p>
         *        </li>
         * @see BarChartOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BarChartOrientation
         */
        Builder orientation(String orientation);

        /**
         * <p>
         * The orientation of the bars in a bar chart visual. There are two valid values in this structure:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HORIZONTAL</code>: Used for charts that have horizontal bars. Visuals that use this value are
         * horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERTICAL</code>: Used for charts that have vertical bars. Visuals that use this value are vertical bar
         * charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
         * </p>
         * </li>
         * </ul>
         * 
         * @param orientation
         *        The orientation of the bars in a bar chart visual. There are two valid values in this structure:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HORIZONTAL</code>: Used for charts that have horizontal bars. Visuals that use this value are
         *        horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERTICAL</code>: Used for charts that have vertical bars. Visuals that use this value are
         *        vertical bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
         *        </p>
         *        </li>
         * @see BarChartOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BarChartOrientation
         */
        Builder orientation(BarChartOrientation orientation);

        /**
         * <p>
         * Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of bar
         * that is used in the visual.
         * </p>
         * 
         * @param barsArrangement
         *        Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of
         *        bar that is used in the visual.
         * @see BarsArrangement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BarsArrangement
         */
        Builder barsArrangement(String barsArrangement);

        /**
         * <p>
         * Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of bar
         * that is used in the visual.
         * </p>
         * 
         * @param barsArrangement
         *        Determines the arrangement of the bars. The orientation and arrangement of bars determine the type of
         *        bar that is used in the visual.
         * @see BarsArrangement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BarsArrangement
         */
        Builder barsArrangement(BarsArrangement barsArrangement);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * 
         * @param visualPalette
         *        The palette (chart color) display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }

        /**
         * <p>
         * The small multiples setup for the visual.
         * </p>
         * 
         * @param smallMultiplesOptions
         *        The small multiples setup for the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions);

        /**
         * <p>
         * The small multiples setup for the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmallMultiplesOptions.Builder} avoiding
         * the need to create one manually via {@link SmallMultiplesOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmallMultiplesOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #smallMultiplesOptions(SmallMultiplesOptions)}.
         * 
         * @param smallMultiplesOptions
         *        a consumer that will call methods on {@link SmallMultiplesOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smallMultiplesOptions(SmallMultiplesOptions)
         */
        default Builder smallMultiplesOptions(Consumer<SmallMultiplesOptions.Builder> smallMultiplesOptions) {
            return smallMultiplesOptions(SmallMultiplesOptions.builder().applyMutation(smallMultiplesOptions).build());
        }

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) for bar chart category.
         * </p>
         * 
         * @param categoryAxis
         *        The label display options (grid line, range, scale, axis step) for bar chart category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryAxis(AxisDisplayOptions categoryAxis);

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) for bar chart category.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #categoryAxis(AxisDisplayOptions)}.
         * 
         * @param categoryAxis
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryAxis(AxisDisplayOptions)
         */
        default Builder categoryAxis(Consumer<AxisDisplayOptions.Builder> categoryAxis) {
            return categoryAxis(AxisDisplayOptions.builder().applyMutation(categoryAxis).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility and sort icon visibility) for a bar chart.
         * </p>
         * 
         * @param categoryLabelOptions
         *        The label options (label text, label visibility and sort icon visibility) for a bar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility and sort icon visibility) for a bar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param categoryLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryLabelOptions(ChartAxisLabelOptions)
         */
        default Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return categoryLabelOptions(ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions).build());
        }

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) for a bar chart value.
         * </p>
         * 
         * @param valueAxis
         *        The label display options (grid line, range, scale, axis step) for a bar chart value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueAxis(AxisDisplayOptions valueAxis);

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) for a bar chart value.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #valueAxis(AxisDisplayOptions)}.
         * 
         * @param valueAxis
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueAxis(AxisDisplayOptions)
         */
        default Builder valueAxis(Consumer<AxisDisplayOptions.Builder> valueAxis) {
            return valueAxis(AxisDisplayOptions.builder().applyMutation(valueAxis).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility and sort icon visibility) for a bar chart value.
         * </p>
         * 
         * @param valueLabelOptions
         *        The label options (label text, label visibility and sort icon visibility) for a bar chart value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueLabelOptions(ChartAxisLabelOptions valueLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility and sort icon visibility) for a bar chart value.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #valueLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param valueLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueLabelOptions(ChartAxisLabelOptions)
         */
        default Builder valueLabelOptions(Consumer<ChartAxisLabelOptions.Builder> valueLabelOptions) {
            return valueLabelOptions(ChartAxisLabelOptions.builder().applyMutation(valueLabelOptions).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar
         * chart.
         * </p>
         * 
         * @param colorLabelOptions
         *        The label options (label text, label visibility and sort icon visibility) for a color that is used in
         *        a bar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar
         * chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #colorLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param colorLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorLabelOptions(ChartAxisLabelOptions)
         */
        default Builder colorLabelOptions(Consumer<ChartAxisLabelOptions.Builder> colorLabelOptions) {
            return colorLabelOptions(ChartAxisLabelOptions.builder().applyMutation(colorLabelOptions).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param legend
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * 
         * @param dataLabels
         *        The options that determine if visual data labels are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * 
         * @param tooltip
         *        The tooltip display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The reference line setup of the visual.
         * </p>
         * 
         * @param referenceLines
         *        The reference line setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLines(Collection<ReferenceLine> referenceLines);

        /**
         * <p>
         * The reference line setup of the visual.
         * </p>
         * 
         * @param referenceLines
         *        The reference line setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLines(ReferenceLine... referenceLines);

        /**
         * <p>
         * The reference line setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder#build()} is called immediately
         * and its result is passed to {@link #referenceLines(List<ReferenceLine>)}.
         * 
         * @param referenceLines
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceLines(java.util.Collection<ReferenceLine>)
         */
        Builder referenceLines(Consumer<ReferenceLine.Builder>... referenceLines);

        /**
         * <p>
         * The contribution analysis (anomaly configuration) setup of the visual.
         * </p>
         * 
         * @param contributionAnalysisDefaults
         *        The contribution analysis (anomaly configuration) setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults);

        /**
         * <p>
         * The contribution analysis (anomaly configuration) setup of the visual.
         * </p>
         * 
         * @param contributionAnalysisDefaults
         *        The contribution analysis (anomaly configuration) setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionAnalysisDefaults(ContributionAnalysisDefault... contributionAnalysisDefaults);

        /**
         * <p>
         * The contribution analysis (anomaly configuration) setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #contributionAnalysisDefaults(List<ContributionAnalysisDefault>)}.
         * 
         * @param contributionAnalysisDefaults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributionAnalysisDefaults(java.util.Collection<ContributionAnalysisDefault>)
         */
        Builder contributionAnalysisDefaults(Consumer<ContributionAnalysisDefault.Builder>... contributionAnalysisDefaults);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BarChartFieldWells fieldWells;

        private BarChartSortConfiguration sortConfiguration;

        private String orientation;

        private String barsArrangement;

        private VisualPalette visualPalette;

        private SmallMultiplesOptions smallMultiplesOptions;

        private AxisDisplayOptions categoryAxis;

        private ChartAxisLabelOptions categoryLabelOptions;

        private AxisDisplayOptions valueAxis;

        private ChartAxisLabelOptions valueLabelOptions;

        private ChartAxisLabelOptions colorLabelOptions;

        private LegendOptions legend;

        private DataLabelOptions dataLabels;

        private TooltipOptions tooltip;

        private List<ReferenceLine> referenceLines = DefaultSdkAutoConstructList.getInstance();

        private List<ContributionAnalysisDefault> contributionAnalysisDefaults = DefaultSdkAutoConstructList.getInstance();

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(BarChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            orientation(model.orientation);
            barsArrangement(model.barsArrangement);
            visualPalette(model.visualPalette);
            smallMultiplesOptions(model.smallMultiplesOptions);
            categoryAxis(model.categoryAxis);
            categoryLabelOptions(model.categoryLabelOptions);
            valueAxis(model.valueAxis);
            valueLabelOptions(model.valueLabelOptions);
            colorLabelOptions(model.colorLabelOptions);
            legend(model.legend);
            dataLabels(model.dataLabels);
            tooltip(model.tooltip);
            referenceLines(model.referenceLines);
            contributionAnalysisDefaults(model.contributionAnalysisDefaults);
            interactions(model.interactions);
        }

        public final BarChartFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(BarChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(BarChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final BarChartSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(BarChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(BarChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final String getOrientation() {
            return orientation;
        }

        public final void setOrientation(String orientation) {
            this.orientation = orientation;
        }

        @Override
        public final Builder orientation(String orientation) {
            this.orientation = orientation;
            return this;
        }

        @Override
        public final Builder orientation(BarChartOrientation orientation) {
            this.orientation(orientation == null ? null : orientation.toString());
            return this;
        }

        public final String getBarsArrangement() {
            return barsArrangement;
        }

        public final void setBarsArrangement(String barsArrangement) {
            this.barsArrangement = barsArrangement;
        }

        @Override
        public final Builder barsArrangement(String barsArrangement) {
            this.barsArrangement = barsArrangement;
            return this;
        }

        @Override
        public final Builder barsArrangement(BarsArrangement barsArrangement) {
            this.barsArrangement(barsArrangement == null ? null : barsArrangement.toString());
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final SmallMultiplesOptions.Builder getSmallMultiplesOptions() {
            return smallMultiplesOptions != null ? smallMultiplesOptions.toBuilder() : null;
        }

        public final void setSmallMultiplesOptions(SmallMultiplesOptions.BuilderImpl smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions != null ? smallMultiplesOptions.build() : null;
        }

        @Override
        public final Builder smallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getCategoryAxis() {
            return categoryAxis != null ? categoryAxis.toBuilder() : null;
        }

        public final void setCategoryAxis(AxisDisplayOptions.BuilderImpl categoryAxis) {
            this.categoryAxis = categoryAxis != null ? categoryAxis.build() : null;
        }

        @Override
        public final Builder categoryAxis(AxisDisplayOptions categoryAxis) {
            this.categoryAxis = categoryAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return categoryLabelOptions != null ? categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getValueAxis() {
            return valueAxis != null ? valueAxis.toBuilder() : null;
        }

        public final void setValueAxis(AxisDisplayOptions.BuilderImpl valueAxis) {
            this.valueAxis = valueAxis != null ? valueAxis.build() : null;
        }

        @Override
        public final Builder valueAxis(AxisDisplayOptions valueAxis) {
            this.valueAxis = valueAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getValueLabelOptions() {
            return valueLabelOptions != null ? valueLabelOptions.toBuilder() : null;
        }

        public final void setValueLabelOptions(ChartAxisLabelOptions.BuilderImpl valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions != null ? valueLabelOptions.build() : null;
        }

        @Override
        public final Builder valueLabelOptions(ChartAxisLabelOptions valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getColorLabelOptions() {
            return colorLabelOptions != null ? colorLabelOptions.toBuilder() : null;
        }

        public final void setColorLabelOptions(ChartAxisLabelOptions.BuilderImpl colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions != null ? colorLabelOptions.build() : null;
        }

        @Override
        public final Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final List<ReferenceLine.Builder> getReferenceLines() {
            List<ReferenceLine.Builder> result = ReferenceLineListCopier.copyToBuilder(this.referenceLines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLines(Collection<ReferenceLine.BuilderImpl> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copyFromBuilder(referenceLines);
        }

        @Override
        public final Builder referenceLines(Collection<ReferenceLine> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copy(referenceLines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(ReferenceLine... referenceLines) {
            referenceLines(Arrays.asList(referenceLines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(Consumer<ReferenceLine.Builder>... referenceLines) {
            referenceLines(Stream.of(referenceLines).map(c -> ReferenceLine.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ContributionAnalysisDefault.Builder> getContributionAnalysisDefaults() {
            List<ContributionAnalysisDefault.Builder> result = ContributionAnalysisDefaultListCopier
                    .copyToBuilder(this.contributionAnalysisDefaults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributionAnalysisDefaults(
                Collection<ContributionAnalysisDefault.BuilderImpl> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier
                    .copyFromBuilder(contributionAnalysisDefaults);
        }

        @Override
        public final Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier.copy(contributionAnalysisDefaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(ContributionAnalysisDefault... contributionAnalysisDefaults) {
            contributionAnalysisDefaults(Arrays.asList(contributionAnalysisDefaults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(
                Consumer<ContributionAnalysisDefault.Builder>... contributionAnalysisDefaults) {
            contributionAnalysisDefaults(Stream.of(contributionAnalysisDefaults)
                    .map(c -> ContributionAnalysisDefault.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public BarChartConfiguration build() {
            return new BarChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
