/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.UserGroupsCopier;
import software.amazon.awssdk.services.qbusiness.model.UserIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsersAndGroups
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsersAndGroups> {
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userIds").getter(UsersAndGroups.getter(UsersAndGroups::userIds)).setter(UsersAndGroups.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userGroups").getter(UsersAndGroups.getter(UsersAndGroups::userGroups)).setter(UsersAndGroups.setter(Builder::userGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IDS_FIELD, USER_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> userIds;
    private final List<String> userGroups;

    private UsersAndGroups(BuilderImpl builder) {
        this.userIds = builder.userIds;
        this.userGroups = builder.userGroups;
    }

    public final boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public final List<String> userIds() {
        return this.userIds;
    }

    public final boolean hasUserGroups() {
        return this.userGroups != null && !(this.userGroups instanceof SdkAutoConstructList);
    }

    public final List<String> userGroups() {
        return this.userGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIds() ? this.userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroups() ? this.userGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsersAndGroups)) {
            return false;
        }
        UsersAndGroups other = (UsersAndGroups)obj;
        return this.hasUserIds() == other.hasUserIds() && Objects.equals(this.userIds(), other.userIds()) && this.hasUserGroups() == other.hasUserGroups() && Objects.equals(this.userGroups(), other.userGroups());
    }

    public final String toString() {
        return ToString.builder((String)"UsersAndGroups").add("UserIds", this.hasUserIds() ? this.userIds() : null).add("UserGroups", this.hasUserGroups() ? this.userGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
            case "userGroups": {
                return Optional.ofNullable(clazz.cast(this.userGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsersAndGroups, T> g) {
        return obj -> g.apply((UsersAndGroups)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsersAndGroups model) {
            this.userIds(model.userIds);
            this.userGroups(model.userGroups);
        }

        public final Collection<String> getUserIds() {
            if (this.userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdsCopier.copy(userIds);
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdsCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final Collection<String> getUserGroups() {
            if (this.userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroups;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String ... userGroups) {
            this.userGroups(Arrays.asList(userGroups));
            return this;
        }

        public UsersAndGroups build() {
            return new UsersAndGroups(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsersAndGroups> {
        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder userGroups(Collection<String> var1);

        public Builder userGroups(String ... var1);
    }
}

