/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.PluginBuildStatus;
import software.amazon.awssdk.services.qbusiness.model.PluginState;
import software.amazon.awssdk.services.qbusiness.model.PluginType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Plugin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Plugin> {
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginId").getter(Plugin.getter(Plugin::pluginId)).setter(Plugin.setter(Builder::pluginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(Plugin.getter(Plugin::displayName)).setter(Plugin.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Plugin.getter(Plugin::typeAsString)).setter(Plugin.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverUrl").getter(Plugin.getter(Plugin::serverUrl)).setter(Plugin.setter(Builder::serverUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Plugin.getter(Plugin::stateAsString)).setter(Plugin.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> BUILD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildStatus").getter(Plugin.getter(Plugin::buildStatusAsString)).setter(Plugin.setter(Builder::buildStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Plugin.getter(Plugin::createdAt)).setter(Plugin.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Plugin.getter(Plugin::updatedAt)).setter(Plugin.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLUGIN_ID_FIELD, DISPLAY_NAME_FIELD, TYPE_FIELD, SERVER_URL_FIELD, STATE_FIELD, BUILD_STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pluginId;
    private final String displayName;
    private final String type;
    private final String serverUrl;
    private final String state;
    private final String buildStatus;
    private final Instant createdAt;
    private final Instant updatedAt;

    private Plugin(BuilderImpl builder) {
        this.pluginId = builder.pluginId;
        this.displayName = builder.displayName;
        this.type = builder.type;
        this.serverUrl = builder.serverUrl;
        this.state = builder.state;
        this.buildStatus = builder.buildStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String pluginId() {
        return this.pluginId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final PluginType type() {
        return PluginType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String serverUrl() {
        return this.serverUrl;
    }

    public final PluginState state() {
        return PluginState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final PluginBuildStatus buildStatus() {
        return PluginBuildStatus.fromValue(this.buildStatus);
    }

    public final String buildStatusAsString() {
        return this.buildStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Plugin)) {
            return false;
        }
        Plugin other = (Plugin)obj;
        return Objects.equals(this.pluginId(), other.pluginId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.serverUrl(), other.serverUrl()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.buildStatusAsString(), other.buildStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"Plugin").add("PluginId", (Object)this.pluginId()).add("DisplayName", (Object)this.displayName()).add("Type", (Object)this.typeAsString()).add("ServerUrl", (Object)this.serverUrl()).add("State", (Object)this.stateAsString()).add("BuildStatus", (Object)this.buildStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pluginId": {
                return Optional.ofNullable(clazz.cast(this.pluginId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "serverUrl": {
                return Optional.ofNullable(clazz.cast(this.serverUrl()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "buildStatus": {
                return Optional.ofNullable(clazz.cast(this.buildStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Plugin, T> g) {
        return obj -> g.apply((Plugin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pluginId;
        private String displayName;
        private String type;
        private String serverUrl;
        private String state;
        private String buildStatus;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Plugin model) {
            this.pluginId(model.pluginId);
            this.displayName(model.displayName);
            this.type(model.type);
            this.serverUrl(model.serverUrl);
            this.state(model.state);
            this.buildStatus(model.buildStatus);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PluginType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getServerUrl() {
            return this.serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PluginState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getBuildStatus() {
            return this.buildStatus;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(PluginBuildStatus buildStatus) {
            this.buildStatus(buildStatus == null ? null : buildStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Plugin build() {
            return new Plugin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Plugin> {
        public Builder pluginId(String var1);

        public Builder displayName(String var1);

        public Builder type(String var1);

        public Builder type(PluginType var1);

        public Builder serverUrl(String var1);

        public Builder state(String var1);

        public Builder state(PluginState var1);

        public Builder buildStatus(String var1);

        public Builder buildStatus(PluginBuildStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

