/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.DataSourceStatus;
import software.amazon.awssdk.services.qbusiness.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.qbusiness.model.DocumentEnrichmentConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ErrorDetail;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataSourceResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetDataSourceResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(GetDataSourceResponse.getter(GetDataSourceResponse::applicationId)).setter(GetDataSourceResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexId").getter(GetDataSourceResponse.getter(GetDataSourceResponse::indexId)).setter(GetDataSourceResponse.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(GetDataSourceResponse.getter(GetDataSourceResponse::dataSourceId)).setter(GetDataSourceResponse.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceArn").getter(GetDataSourceResponse.getter(GetDataSourceResponse::dataSourceArn)).setter(GetDataSourceResponse.setter(Builder::dataSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetDataSourceResponse.getter(GetDataSourceResponse::displayName)).setter(GetDataSourceResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetDataSourceResponse.getter(GetDataSourceResponse::type)).setter(GetDataSourceResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Document> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("configuration").getter(GetDataSourceResponse.getter(GetDataSourceResponse::configuration)).setter(GetDataSourceResponse.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(GetDataSourceResponse.getter(GetDataSourceResponse::vpcConfiguration)).setter(GetDataSourceResponse.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetDataSourceResponse.getter(GetDataSourceResponse::createdAt)).setter(GetDataSourceResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetDataSourceResponse.getter(GetDataSourceResponse::updatedAt)).setter(GetDataSourceResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetDataSourceResponse.getter(GetDataSourceResponse::description)).setter(GetDataSourceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetDataSourceResponse.getter(GetDataSourceResponse::statusAsString)).setter(GetDataSourceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SYNC_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSchedule").getter(GetDataSourceResponse.getter(GetDataSourceResponse::syncSchedule)).setter(GetDataSourceResponse.setter(Builder::syncSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSchedule").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetDataSourceResponse.getter(GetDataSourceResponse::roleArn)).setter(GetDataSourceResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(GetDataSourceResponse.getter(GetDataSourceResponse::error)).setter(GetDataSourceResponse.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<DocumentEnrichmentConfiguration> DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentEnrichmentConfiguration").getter(GetDataSourceResponse.getter(GetDataSourceResponse::documentEnrichmentConfiguration)).setter(GetDataSourceResponse.setter(Builder::documentEnrichmentConfiguration)).constructor(DocumentEnrichmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentEnrichmentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, INDEX_ID_FIELD, DATA_SOURCE_ID_FIELD, DATA_SOURCE_ARN_FIELD, DISPLAY_NAME_FIELD, TYPE_FIELD, CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, SYNC_SCHEDULE_FIELD, ROLE_ARN_FIELD, ERROR_FIELD, DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD));
    private final String applicationId;
    private final String indexId;
    private final String dataSourceId;
    private final String dataSourceArn;
    private final String displayName;
    private final String type;
    private final Document configuration;
    private final DataSourceVpcConfiguration vpcConfiguration;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String description;
    private final String status;
    private final String syncSchedule;
    private final String roleArn;
    private final ErrorDetail error;
    private final DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

    private GetDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceArn = builder.dataSourceArn;
        this.displayName = builder.displayName;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.description = builder.description;
        this.status = builder.status;
        this.syncSchedule = builder.syncSchedule;
        this.roleArn = builder.roleArn;
        this.error = builder.error;
        this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String dataSourceArn() {
        return this.dataSourceArn;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String type() {
        return this.type;
    }

    public final Document configuration() {
        return this.configuration;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String description() {
        return this.description;
    }

    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String syncSchedule() {
        return this.syncSchedule;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public final DocumentEnrichmentConfiguration documentEnrichmentConfiguration() {
        return this.documentEnrichmentConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentEnrichmentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceResponse)) {
            return false;
        }
        GetDataSourceResponse other = (GetDataSourceResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataSourceArn(), other.dataSourceArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.syncSchedule(), other.syncSchedule()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.documentEnrichmentConfiguration(), other.documentEnrichmentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataSourceResponse").add("ApplicationId", (Object)this.applicationId()).add("IndexId", (Object)this.indexId()).add("DataSourceId", (Object)this.dataSourceId()).add("DataSourceArn", (Object)this.dataSourceArn()).add("DisplayName", (Object)this.displayName()).add("Type", (Object)this.type()).add("Configuration", (Object)this.configuration()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("SyncSchedule", (Object)this.syncSchedule()).add("RoleArn", (Object)this.roleArn()).add("Error", (Object)this.error()).add("DocumentEnrichmentConfiguration", (Object)this.documentEnrichmentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "indexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "dataSourceArn": {
                return Optional.ofNullable(clazz.cast(this.dataSourceArn()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "syncSchedule": {
                return Optional.ofNullable(clazz.cast(this.syncSchedule()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "documentEnrichmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.documentEnrichmentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataSourceResponse, T> g) {
        return obj -> g.apply((GetDataSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String indexId;
        private String dataSourceId;
        private String dataSourceArn;
        private String displayName;
        private String type;
        private Document configuration;
        private DataSourceVpcConfiguration vpcConfiguration;
        private Instant createdAt;
        private Instant updatedAt;
        private String description;
        private String status;
        private String syncSchedule;
        private String roleArn;
        private ErrorDetail error;
        private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.indexId(model.indexId);
            this.dataSourceId(model.dataSourceId);
            this.dataSourceArn(model.dataSourceArn);
            this.displayName(model.displayName);
            this.type(model.type);
            this.configuration(model.configuration);
            this.vpcConfiguration(model.vpcConfiguration);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.description(model.description);
            this.status(model.status);
            this.syncSchedule(model.syncSchedule);
            this.roleArn(model.roleArn);
            this.error(model.error);
            this.documentEnrichmentConfiguration(model.documentEnrichmentConfiguration);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDataSourceArn() {
            return this.dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Document getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(Document configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(Document configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSyncSchedule() {
            return this.syncSchedule;
        }

        public final void setSyncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
        }

        @Override
        public final Builder syncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final DocumentEnrichmentConfiguration.Builder getDocumentEnrichmentConfiguration() {
            return this.documentEnrichmentConfiguration != null ? this.documentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setDocumentEnrichmentConfiguration(DocumentEnrichmentConfiguration.BuilderImpl documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration.build() : null;
        }

        @Override
        public final Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        @Override
        public GetDataSourceResponse build() {
            return new GetDataSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataSourceResponse> {
        public Builder applicationId(String var1);

        public Builder indexId(String var1);

        public Builder dataSourceId(String var1);

        public Builder dataSourceArn(String var1);

        public Builder displayName(String var1);

        public Builder type(String var1);

        public Builder configuration(Document var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(DataSourceStatus var1);

        public Builder syncSchedule(String var1);

        public Builder roleArn(String var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }

        public Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration var1);

        default public Builder documentEnrichmentConfiguration(Consumer<DocumentEnrichmentConfiguration.Builder> documentEnrichmentConfiguration) {
            return this.documentEnrichmentConfiguration((DocumentEnrichmentConfiguration)((DocumentEnrichmentConfiguration.Builder)DocumentEnrichmentConfiguration.builder().applyMutation(documentEnrichmentConfiguration)).build());
        }
    }
}

