/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DeleteDocument;
import software.amazon.awssdk.services.qbusiness.model.DeleteDocumentsCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteDocumentRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, BatchDeleteDocumentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(BatchDeleteDocumentRequest.getter(BatchDeleteDocumentRequest::applicationId)).setter(BatchDeleteDocumentRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexId").getter(BatchDeleteDocumentRequest.getter(BatchDeleteDocumentRequest::indexId)).setter(BatchDeleteDocumentRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()}).build();
    private static final SdkField<List<DeleteDocument>> DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("documents").getter(BatchDeleteDocumentRequest.getter(BatchDeleteDocumentRequest::documents)).setter(BatchDeleteDocumentRequest.setter(Builder::documents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_SOURCE_SYNC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceSyncId").getter(BatchDeleteDocumentRequest.getter(BatchDeleteDocumentRequest::dataSourceSyncId)).setter(BatchDeleteDocumentRequest.setter(Builder::dataSourceSyncId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceSyncId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, INDEX_ID_FIELD, DOCUMENTS_FIELD, DATA_SOURCE_SYNC_ID_FIELD));
    private final String applicationId;
    private final String indexId;
    private final List<DeleteDocument> documents;
    private final String dataSourceSyncId;

    private BatchDeleteDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.documents = builder.documents;
        this.dataSourceSyncId = builder.dataSourceSyncId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final boolean hasDocuments() {
        return this.documents != null && !(this.documents instanceof SdkAutoConstructList);
    }

    public final List<DeleteDocument> documents() {
        return this.documents;
    }

    public final String dataSourceSyncId() {
        return this.dataSourceSyncId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocuments() ? this.documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceSyncId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDocumentRequest)) {
            return false;
        }
        BatchDeleteDocumentRequest other = (BatchDeleteDocumentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.indexId(), other.indexId()) && this.hasDocuments() == other.hasDocuments() && Objects.equals(this.documents(), other.documents()) && Objects.equals(this.dataSourceSyncId(), other.dataSourceSyncId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteDocumentRequest").add("ApplicationId", (Object)this.applicationId()).add("IndexId", (Object)this.indexId()).add("Documents", this.hasDocuments() ? this.documents() : null).add("DataSourceSyncId", (Object)this.dataSourceSyncId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "indexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "documents": {
                return Optional.ofNullable(clazz.cast(this.documents()));
            }
            case "dataSourceSyncId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceSyncId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDocumentRequest, T> g) {
        return obj -> g.apply((BatchDeleteDocumentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String indexId;
        private List<DeleteDocument> documents = DefaultSdkAutoConstructList.getInstance();
        private String dataSourceSyncId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDocumentRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.indexId(model.indexId);
            this.documents(model.documents);
            this.dataSourceSyncId(model.dataSourceSyncId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final List<DeleteDocument.Builder> getDocuments() {
            List<DeleteDocument.Builder> result = DeleteDocumentsCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<DeleteDocument.BuilderImpl> documents) {
            this.documents = DeleteDocumentsCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<DeleteDocument> documents) {
            this.documents = DeleteDocumentsCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(DeleteDocument ... documents) {
            this.documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<DeleteDocument.Builder> ... documents) {
            this.documents(Stream.of(documents).map(c -> (DeleteDocument)((DeleteDocument.Builder)DeleteDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataSourceSyncId() {
            return this.dataSourceSyncId;
        }

        public final void setDataSourceSyncId(String dataSourceSyncId) {
            this.dataSourceSyncId = dataSourceSyncId;
        }

        @Override
        public final Builder dataSourceSyncId(String dataSourceSyncId) {
            this.dataSourceSyncId = dataSourceSyncId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteDocumentRequest build() {
            return new BatchDeleteDocumentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteDocumentRequest> {
        public Builder applicationId(String var1);

        public Builder indexId(String var1);

        public Builder documents(Collection<DeleteDocument> var1);

        public Builder documents(DeleteDocument ... var1);

        public Builder documents(Consumer<DeleteDocument.Builder> ... var1);

        public Builder dataSourceSyncId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

