/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLexiconResponse extends PollyResponse implements
        ToCopyableBuilder<GetLexiconResponse.Builder, GetLexiconResponse> {
    private static final SdkField<Lexicon> LEXICON_FIELD = SdkField.<Lexicon> builder(MarshallingType.SDK_POJO)
            .memberName("Lexicon").getter(getter(GetLexiconResponse::lexicon)).setter(setter(Builder::lexicon))
            .constructor(Lexicon::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lexicon").build()).build();

    private static final SdkField<LexiconAttributes> LEXICON_ATTRIBUTES_FIELD = SdkField
            .<LexiconAttributes> builder(MarshallingType.SDK_POJO).memberName("LexiconAttributes")
            .getter(getter(GetLexiconResponse::lexiconAttributes)).setter(setter(Builder::lexiconAttributes))
            .constructor(LexiconAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexiconAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEXICON_FIELD,
            LEXICON_ATTRIBUTES_FIELD));

    private final Lexicon lexicon;

    private final LexiconAttributes lexiconAttributes;

    private GetLexiconResponse(BuilderImpl builder) {
        super(builder);
        this.lexicon = builder.lexicon;
        this.lexiconAttributes = builder.lexiconAttributes;
    }

    /**
     * <p>
     * Lexicon object that provides name and the string content of the lexicon.
     * </p>
     * 
     * @return Lexicon object that provides name and the string content of the lexicon.
     */
    public final Lexicon lexicon() {
        return lexicon;
    }

    /**
     * <p>
     * Metadata of the lexicon, including phonetic alphabetic used, language code, lexicon ARN, number of lexemes
     * defined in the lexicon, and size of lexicon in bytes.
     * </p>
     * 
     * @return Metadata of the lexicon, including phonetic alphabetic used, language code, lexicon ARN, number of
     *         lexemes defined in the lexicon, and size of lexicon in bytes.
     */
    public final LexiconAttributes lexiconAttributes() {
        return lexiconAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lexicon());
        hashCode = 31 * hashCode + Objects.hashCode(lexiconAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLexiconResponse)) {
            return false;
        }
        GetLexiconResponse other = (GetLexiconResponse) obj;
        return Objects.equals(lexicon(), other.lexicon()) && Objects.equals(lexiconAttributes(), other.lexiconAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLexiconResponse").add("Lexicon", lexicon()).add("LexiconAttributes", lexiconAttributes())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lexicon":
            return Optional.ofNullable(clazz.cast(lexicon()));
        case "LexiconAttributes":
            return Optional.ofNullable(clazz.cast(lexiconAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLexiconResponse, T> g) {
        return obj -> g.apply((GetLexiconResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PollyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLexiconResponse> {
        /**
         * <p>
         * Lexicon object that provides name and the string content of the lexicon.
         * </p>
         * 
         * @param lexicon
         *        Lexicon object that provides name and the string content of the lexicon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexicon(Lexicon lexicon);

        /**
         * <p>
         * Lexicon object that provides name and the string content of the lexicon.
         * </p>
         * This is a convenience method that creates an instance of the {@link Lexicon.Builder} avoiding the need to
         * create one manually via {@link Lexicon#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Lexicon.Builder#build()} is called immediately and its result is
         * passed to {@link #lexicon(Lexicon)}.
         * 
         * @param lexicon
         *        a consumer that will call methods on {@link Lexicon.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lexicon(Lexicon)
         */
        default Builder lexicon(Consumer<Lexicon.Builder> lexicon) {
            return lexicon(Lexicon.builder().applyMutation(lexicon).build());
        }

        /**
         * <p>
         * Metadata of the lexicon, including phonetic alphabetic used, language code, lexicon ARN, number of lexemes
         * defined in the lexicon, and size of lexicon in bytes.
         * </p>
         * 
         * @param lexiconAttributes
         *        Metadata of the lexicon, including phonetic alphabetic used, language code, lexicon ARN, number of
         *        lexemes defined in the lexicon, and size of lexicon in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexiconAttributes(LexiconAttributes lexiconAttributes);

        /**
         * <p>
         * Metadata of the lexicon, including phonetic alphabetic used, language code, lexicon ARN, number of lexemes
         * defined in the lexicon, and size of lexicon in bytes.
         * </p>
         * This is a convenience method that creates an instance of the {@link LexiconAttributes.Builder} avoiding the
         * need to create one manually via {@link LexiconAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LexiconAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #lexiconAttributes(LexiconAttributes)}.
         * 
         * @param lexiconAttributes
         *        a consumer that will call methods on {@link LexiconAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lexiconAttributes(LexiconAttributes)
         */
        default Builder lexiconAttributes(Consumer<LexiconAttributes.Builder> lexiconAttributes) {
            return lexiconAttributes(LexiconAttributes.builder().applyMutation(lexiconAttributes).build());
        }
    }

    static final class BuilderImpl extends PollyResponse.BuilderImpl implements Builder {
        private Lexicon lexicon;

        private LexiconAttributes lexiconAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLexiconResponse model) {
            super(model);
            lexicon(model.lexicon);
            lexiconAttributes(model.lexiconAttributes);
        }

        public final Lexicon.Builder getLexicon() {
            return lexicon != null ? lexicon.toBuilder() : null;
        }

        public final void setLexicon(Lexicon.BuilderImpl lexicon) {
            this.lexicon = lexicon != null ? lexicon.build() : null;
        }

        @Override
        public final Builder lexicon(Lexicon lexicon) {
            this.lexicon = lexicon;
            return this;
        }

        public final LexiconAttributes.Builder getLexiconAttributes() {
            return lexiconAttributes != null ? lexiconAttributes.toBuilder() : null;
        }

        public final void setLexiconAttributes(LexiconAttributes.BuilderImpl lexiconAttributes) {
            this.lexiconAttributes = lexiconAttributes != null ? lexiconAttributes.build() : null;
        }

        @Override
        public final Builder lexiconAttributes(LexiconAttributes lexiconAttributes) {
            this.lexiconAttributes = lexiconAttributes;
            return this;
        }

        @Override
        public GetLexiconResponse build() {
            return new GetLexiconResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
